package elemental2.dom;

import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class XPathResult {
  @JsOverlay public static final double ANY_TYPE = XPathResult__Constants.ANY_TYPE;

  @JsOverlay
  public static final double ANY_UNORDERED_NODE_TYPE =
      XPathResult__Constants.ANY_UNORDERED_NODE_TYPE;

  @JsOverlay public static final double BOOLEAN_TYPE = XPathResult__Constants.BOOLEAN_TYPE;

  @JsOverlay
  public static final double FIRST_ORDERED_NODE_TYPE =
      XPathResult__Constants.FIRST_ORDERED_NODE_TYPE;

  @JsOverlay public static final double NUMBER_TYPE = XPathResult__Constants.NUMBER_TYPE;

  @JsOverlay
  public static final double ORDERED_NODE_ITERATOR_TYPE =
      XPathResult__Constants.ORDERED_NODE_ITERATOR_TYPE;

  @JsOverlay
  public static final double ORDERED_NODE_SNAPSHOT_TYPE =
      XPathResult__Constants.ORDERED_NODE_SNAPSHOT_TYPE;

  @JsOverlay public static final double STRING_TYPE = XPathResult__Constants.STRING_TYPE;

  @JsOverlay
  public static final double UNORDERED_NODE_ITERATOR_TYPE =
      XPathResult__Constants.UNORDERED_NODE_ITERATOR_TYPE;

  @JsOverlay
  public static final double UNORDERED_NODE_SNAPSHOT_TYPE =
      XPathResult__Constants.UNORDERED_NODE_SNAPSHOT_TYPE;

  public boolean booleanValue;
  public boolean invalidInteratorState;
  public double numberValue;
  public int resultType;
  public Node singleNodeValue;
  public int snapshotLength;
  public String stringValue;

  public native Node iterateNext();

  public native Node snapshotItem(int index);
}
