package elemental2.dom;

import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;
import jsinterop.base.JsPropertyMap;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public interface RTCRtpSendParameters {
  @JsOverlay
  static RTCRtpSendParameters create() {
    return Js.uncheckedCast(JsPropertyMap.of());
  }

  @JsProperty
  String getDegradationPreference();

  @JsProperty
  RTCRtpEncodingParameters[] getEncodings();

  @JsProperty
  String getTransactionId();

  @JsProperty
  void setDegradationPreference(String degradationPreference);

  @JsProperty
  void setEncodings(RTCRtpEncodingParameters[] encodings);

  @JsProperty
  void setTransactionId(String transactionId);
}
