package elemental2.dom;

import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class MediaSource implements EventTarget {
  public static native boolean isTypeSupported(String type);

  public SourceBuffer[] activeSourceBuffers;
  public double duration;
  public String readyState;
  public SourceBuffer[] sourceBuffers;

  public native void addEventListener(
      String type, EventListener listener, EventTarget.AddEventListenerOptionsUnionType options);

  public native void addEventListener(String type, EventListener listener);

  public native SourceBuffer addSourceBuffer(String type);

  public native void clearLiveSeekableRange();

  public native boolean dispatchEvent(Event evt);

  public native void endOfStream();

  public native void endOfStream(String error);

  public native void removeEventListener(
      String type, EventListener listener, EventTarget.RemoveEventListenerOptionsUnionType options);

  public native void removeEventListener(String type, EventListener listener);

  public native void removeSourceBuffer(SourceBuffer sourceBuffer);

  public native Object setLiveSeekableRange(double start, double end);
}
