package elemental2.dom;

import elemental2.core.JsArray;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public interface CanvasDrawingStyles {
  @JsProperty
  String getFont();

  @JsProperty
  String getLineCap();

  JsArray<Double> getLineDash();

  @JsProperty
  String getLineJoin();

  @JsProperty
  double getLineWidth();

  @JsProperty
  double getMiterLimit();

  @JsProperty
  String getTextAlign();

  @JsProperty
  String getTextBaseline();

  @JsProperty
  void setFont(String font);

  @JsProperty
  void setLineCap(String lineCap);

  void setLineDash(JsArray<Double> segments);

  @JsOverlay
  default void setLineDash(double[] segments) {
    setLineDash(Js.<JsArray<Double>>uncheckedCast(segments));
  }

  @JsProperty
  void setLineJoin(String lineJoin);

  @JsProperty
  void setLineWidth(double lineWidth);

  @JsProperty
  void setMiterLimit(double miterLimit);

  @JsProperty
  void setTextAlign(String textAlign);

  @JsProperty
  void setTextBaseline(String textBaseline);
}
