package elemental2.dom;

import elemental2.core.JsArray;
import elemental2.core.Transferable;
import jsinterop.annotations.JsFunction;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public interface DedicatedWorkerGlobalScope extends WorkerGlobalScope {
  @JsFunction
  public interface OnmessageFn {
    void onInvoke(MessageEvent<Object> event);
  }

  @JsProperty
  DedicatedWorkerGlobalScope.OnmessageFn getOnmessage();

  void postMessage(Object message, JsArray<Transferable> transfer);

  @JsOverlay
  default void postMessage(Object message, Transferable[] transfer) {
    postMessage(message, Js.<JsArray<Transferable>>uncheckedCast(transfer));
  }

  void postMessage(Object message);

  @JsProperty
  void setOnmessage(DedicatedWorkerGlobalScope.OnmessageFn onmessage);

  void webkitPostMessage(Object message, JsArray<Transferable> transfer);

  @JsOverlay
  default void webkitPostMessage(Object message, Transferable[] transfer) {
    webkitPostMessage(message, Js.<JsArray<Transferable>>uncheckedCast(transfer));
  }

  void webkitPostMessage(Object message);
}
