package elemental2.dom;

import jsinterop.annotations.JsFunction;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class EventSource implements EventTarget {
  @JsFunction
  public interface OnerrorFn {
    void onInvoke(Event event);
  }

  @JsFunction
  public interface OnmessageFn {
    void onInvoke(MessageEvent<String> event);
  }

  @JsFunction
  public interface OnopenFn {
    void onInvoke(Event event);
  }

  @JsOverlay public static final int CLOSED = EventSource__Constants.CLOSED;
  @JsOverlay public static final int CONNECTING = EventSource__Constants.CONNECTING;
  @JsOverlay public static final int OPEN = EventSource__Constants.OPEN;
  public EventSource.OnerrorFn onerror;
  public EventSource.OnmessageFn onmessage;
  public EventSource.OnopenFn onopen;
  public int readyState;
  public String url;
  public boolean withCredentials;

  public EventSource(String url, EventSourceInit eventSourceInitDict) {}

  public EventSource(String url) {}

  public native void addEventListener(
      String type, EventListener listener, EventTarget.AddEventListenerOptionsUnionType options);

  public native void addEventListener(String type, EventListener listener);

  public native void close();

  public native boolean dispatchEvent(Event evt);

  public native void removeEventListener(
      String type, EventListener listener, EventTarget.RemoveEventListenerOptionsUnionType options);

  public native void removeEventListener(String type, EventListener listener);
}
