package elemental2.dom;

import elemental2.core.JsArray;
import elemental2.promise.Promise;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public interface MediaDevices extends EventTarget {
  Promise<JsArray<MediaDeviceInfo>> enumerateDevices();

  Promise<MediaStream> getDisplayMedia();

  Promise<MediaStream> getDisplayMedia(MediaStreamConstraints constraints);

  MediaTrackSupportedConstraints getSupportedConstraints();

  Promise<MediaStream> getUserMedia(MediaStreamConstraints constraints);
}
