package elemental2.dom;

import elemental2.core.JsArray;
import elemental2.core.Transferable;
import jsinterop.annotations.JsFunction;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class Worker implements EventTarget {
  @JsFunction
  public interface OnerrorFn {
    void onInvoke(ErrorEvent event);
  }

  @JsFunction
  public interface OnmessageFn {
    void onInvoke(MessageEvent<Object> event);
  }

  public Worker.OnerrorFn onerror;
  public Worker.OnmessageFn onmessage;

  public Worker(String scriptURL, WorkerOptions options) {}

  public Worker(String scriptURL) {}

  public native void addEventListener(
      String type, EventListener listener, EventTarget.AddEventListenerOptionsUnionType options);

  public native void addEventListener(String type, EventListener listener);

  public native boolean dispatchEvent(Event evt);

  public native void postMessage(Object message, JsArray<Transferable> transfer);

  @JsOverlay
  public final void postMessage(Object message, Transferable[] transfer) {
    postMessage(message, Js.<JsArray<Transferable>>uncheckedCast(transfer));
  }

  public native void postMessage(Object message);

  public native void removeEventListener(
      String type, EventListener listener, EventTarget.RemoveEventListenerOptionsUnionType options);

  public native void removeEventListener(String type, EventListener listener);

  public native void terminate();

  public native void webkitPostMessage(Object message, JsArray<Transferable> transfer);

  @JsOverlay
  public final void webkitPostMessage(Object message, Transferable[] transfer) {
    webkitPostMessage(message, Js.<JsArray<Transferable>>uncheckedCast(transfer));
  }

  public native void webkitPostMessage(Object message);
}
