package elemental2.dom;

import elemental2.core.JsArray;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;
import jsinterop.base.JsPropertyMap;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public interface MediaTrackConstraints extends MediaTrackConstraintSet {
  @JsOverlay
  static MediaTrackConstraints create() {
    return Js.uncheckedCast(JsPropertyMap.of());
  }

  @JsProperty
  JsArray<MediaTrackConstraintSet> getAdvanced();

  @JsProperty
  void setAdvanced(JsArray<MediaTrackConstraintSet> advanced);

  @JsOverlay
  default void setAdvanced(MediaTrackConstraintSet[] advanced) {
    setAdvanced(Js.<JsArray<MediaTrackConstraintSet>>uncheckedCast(advanced));
  }
}
