package elemental2.dom;

import elemental2.core.JsArray;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public interface RTCIceServerInterface_ {
  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface GetUrlsUnionType {
    @JsOverlay
    static RTCIceServerInterface_.GetUrlsUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default JsArray<String> asJsArray() {
      return Js.cast(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isJsArray() {
      return (Object) this instanceof JsArray;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsProperty
  String getCredential();

  @JsProperty
  RTCIceServerInterface_.GetUrlsUnionType getUrls();

  @JsProperty
  String getUsername();

  @JsProperty
  void setCredential(String credential);

  @JsProperty
  void setUrls(RTCIceServerInterface_.GetUrlsUnionType urls);

  @JsOverlay
  default void setUrls(JsArray<String> urls) {
    setUrls(Js.<RTCIceServerInterface_.GetUrlsUnionType>uncheckedCast(urls));
  }

  @JsOverlay
  default void setUrls(String urls) {
    setUrls(Js.<RTCIceServerInterface_.GetUrlsUnionType>uncheckedCast(urls));
  }

  @JsOverlay
  default void setUrls(String[] urls) {
    setUrls(Js.<JsArray<String>>uncheckedCast(urls));
  }

  @JsProperty
  void setUsername(String username);
}
