package elemental2.dom;

import elemental2.core.JsArray;
import elemental2.promise.Promise;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public interface ServiceWorkerClients {
  Promise<Void> claim();

  Promise<ServiceWorkerClient> get(String id);

  Promise<JsArray<ServiceWorkerClient>> getAll();

  Promise<JsArray<ServiceWorkerClient>> getAll(ServiceWorkerClientQueryOptions options);

  Promise<JsArray<ServiceWorkerClient>> matchAll();

  Promise<JsArray<ServiceWorkerClient>> matchAll(ServiceWorkerClientQueryOptions options);

  Promise<ServiceWorkerClient> openWindow(String url);
}
