package elemental2.dom;

import elemental2.core.JsArray;
import elemental2.promise.Promise;
import jsinterop.annotations.JsFunction;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public interface ServiceWorkerContainer extends EventTarget {
  @JsFunction
  public interface OncontrollerchangeFn {
    void onInvoke(Event event);
  }

  @JsFunction
  public interface OnerrorFn {
    void onInvoke(ErrorEvent event);
  }

  @JsFunction
  public interface OnmessageFn {
    void onInvoke(ExtendableMessageEvent p0);
  }

  @JsProperty
  ServiceWorker getController();

  @JsProperty
  ServiceWorkerContainer.OncontrollerchangeFn getOncontrollerchange();

  @JsProperty
  ServiceWorkerContainer.OnerrorFn getOnerror();

  @JsProperty
  ServiceWorkerContainer.OnmessageFn getOnmessage();

  @JsProperty
  Promise<ServiceWorkerRegistration> getReady();

  Promise<ServiceWorkerRegistration> getRegistration();

  Promise<ServiceWorkerRegistration> getRegistration(String documentURL);

  Promise<JsArray<ServiceWorkerRegistration>> getRegistrations();

  Promise<ServiceWorkerRegistration> register(String scriptURL, RegistrationOptions options);

  Promise<ServiceWorkerRegistration> register(String scriptURL);

  @JsProperty
  void setController(ServiceWorker controller);

  @JsProperty
  void setOncontrollerchange(ServiceWorkerContainer.OncontrollerchangeFn oncontrollerchange);

  @JsProperty
  void setOnerror(ServiceWorkerContainer.OnerrorFn onerror);

  @JsProperty
  void setOnmessage(ServiceWorkerContainer.OnmessageFn onmessage);

  @JsProperty
  void setReady(Promise<ServiceWorkerRegistration> ready);
}
