package elemental2.dom;

import jsinterop.annotations.JsFunction;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;
import jsinterop.base.JsPropertyMap;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public interface TrustedTypePolicyOptions {
  @JsFunction
  public interface CreateHTMLFn {
    String onInvoke(String p0, Object... p1);
  }

  @JsFunction
  public interface CreateScriptFn {
    String onInvoke(String p0, Object... p1);
  }

  @JsFunction
  public interface CreateScriptURLFn {
    String onInvoke(String p0, Object... p1);
  }

  @JsFunction
  public interface CreateURLFn {
    String onInvoke(String p0, Object... p1);
  }

  @JsOverlay
  static TrustedTypePolicyOptions create() {
    return Js.uncheckedCast(JsPropertyMap.of());
  }

  @JsProperty
  TrustedTypePolicyOptions.CreateHTMLFn getCreateHTML();

  @JsProperty
  TrustedTypePolicyOptions.CreateScriptFn getCreateScript();

  @JsProperty
  TrustedTypePolicyOptions.CreateScriptURLFn getCreateScriptURL();

  @JsProperty
  TrustedTypePolicyOptions.CreateURLFn getCreateURL();

  @JsProperty
  void setCreateHTML(TrustedTypePolicyOptions.CreateHTMLFn createHTML);

  @JsProperty
  void setCreateScript(TrustedTypePolicyOptions.CreateScriptFn createScript);

  @JsProperty
  void setCreateScriptURL(TrustedTypePolicyOptions.CreateScriptURLFn createScriptURL);

  @JsProperty
  void setCreateURL(TrustedTypePolicyOptions.CreateURLFn createURL);
}
