package elemental2.indexeddb;

import elemental2.dom.Event;
import elemental2.dom.EventInit;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class IDBVersionChangeEvent extends Event {
  public double newVersion;
  public double oldVersion;

  public IDBVersionChangeEvent(String type, IDBVersionChangeEventInit eventInit) {
    // This call is only here for java compilation purpose.
    super((String) null, (EventInit) null);
  }

  public IDBVersionChangeEvent(String type) {
    // This call is only here for java compilation purpose.
    super((String) null, (EventInit) null);
  }
}
