package elemental2.indexeddb;

import elemental2.dom.ServiceWorkerGlobalScope;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;

@JsType(isNative = true, name = "ServiceWorkerGlobalScope", namespace = JsPackage.GLOBAL)
public interface IndexedDbServiceWorkerGlobalScope extends ServiceWorkerGlobalScope {
  @JsOverlay
  static IndexedDbServiceWorkerGlobalScope of(ServiceWorkerGlobalScope o) {
    return Js.cast(o);
  }

  @JsProperty
  IDBFactory getIndexedDB();

  @JsProperty
  void setIndexedDB(IDBFactory indexedDB);
}
