package elemental2.indexeddb;

import elemental2.core.ArrayBuffer;
import elemental2.core.ArrayBufferView;
import elemental2.core.JsArray;
import elemental2.core.JsDate;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class IDBIndex {
  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface CountKeyUnionType {
    @JsOverlay
    static IDBIndex.CountKeyUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default ArrayBuffer asArrayBuffer() {
      return Js.cast(this);
    }

    @JsOverlay
    default ArrayBufferView asArrayBufferView() {
      return Js.cast(this);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default IDBKeyRange asIDBKeyRange() {
      return Js.cast(this);
    }

    @JsOverlay
    default JsArray<Object> asJsArray() {
      return Js.cast(this);
    }

    @JsOverlay
    default JsDate asJsDate() {
      return Js.cast(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isArrayBuffer() {
      return (Object) this instanceof ArrayBuffer;
    }

    @JsOverlay
    default boolean isArrayBufferView() {
      return (Object) this instanceof ArrayBufferView;
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isIDBKeyRange() {
      return (Object) this instanceof IDBKeyRange;
    }

    @JsOverlay
    default boolean isJsArray() {
      return (Object) this instanceof JsArray;
    }

    @JsOverlay
    default boolean isJsDate() {
      return (Object) this instanceof JsDate;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface GetAllKeysQueryUnionType {
    @JsOverlay
    static IDBIndex.GetAllKeysQueryUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default ArrayBuffer asArrayBuffer() {
      return Js.cast(this);
    }

    @JsOverlay
    default ArrayBufferView asArrayBufferView() {
      return Js.cast(this);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default IDBKeyRange asIDBKeyRange() {
      return Js.cast(this);
    }

    @JsOverlay
    default JsArray<Object> asJsArray() {
      return Js.cast(this);
    }

    @JsOverlay
    default JsDate asJsDate() {
      return Js.cast(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isArrayBuffer() {
      return (Object) this instanceof ArrayBuffer;
    }

    @JsOverlay
    default boolean isArrayBufferView() {
      return (Object) this instanceof ArrayBufferView;
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isIDBKeyRange() {
      return (Object) this instanceof IDBKeyRange;
    }

    @JsOverlay
    default boolean isJsArray() {
      return (Object) this instanceof JsArray;
    }

    @JsOverlay
    default boolean isJsDate() {
      return (Object) this instanceof JsDate;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface GetAllQueryUnionType {
    @JsOverlay
    static IDBIndex.GetAllQueryUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default ArrayBuffer asArrayBuffer() {
      return Js.cast(this);
    }

    @JsOverlay
    default ArrayBufferView asArrayBufferView() {
      return Js.cast(this);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default IDBKeyRange asIDBKeyRange() {
      return Js.cast(this);
    }

    @JsOverlay
    default JsArray<Object> asJsArray() {
      return Js.cast(this);
    }

    @JsOverlay
    default JsDate asJsDate() {
      return Js.cast(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isArrayBuffer() {
      return (Object) this instanceof ArrayBuffer;
    }

    @JsOverlay
    default boolean isArrayBufferView() {
      return (Object) this instanceof ArrayBufferView;
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isIDBKeyRange() {
      return (Object) this instanceof IDBKeyRange;
    }

    @JsOverlay
    default boolean isJsArray() {
      return (Object) this instanceof JsArray;
    }

    @JsOverlay
    default boolean isJsDate() {
      return (Object) this instanceof JsDate;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface GetKeyKeyUnionType {
    @JsOverlay
    static IDBIndex.GetKeyKeyUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default ArrayBuffer asArrayBuffer() {
      return Js.cast(this);
    }

    @JsOverlay
    default ArrayBufferView asArrayBufferView() {
      return Js.cast(this);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default IDBKeyRange asIDBKeyRange() {
      return Js.cast(this);
    }

    @JsOverlay
    default JsArray<Object> asJsArray() {
      return Js.cast(this);
    }

    @JsOverlay
    default JsDate asJsDate() {
      return Js.cast(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isArrayBuffer() {
      return (Object) this instanceof ArrayBuffer;
    }

    @JsOverlay
    default boolean isArrayBufferView() {
      return (Object) this instanceof ArrayBufferView;
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isIDBKeyRange() {
      return (Object) this instanceof IDBKeyRange;
    }

    @JsOverlay
    default boolean isJsArray() {
      return (Object) this instanceof JsArray;
    }

    @JsOverlay
    default boolean isJsDate() {
      return (Object) this instanceof JsDate;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface GetKeyUnionType {
    @JsOverlay
    static IDBIndex.GetKeyUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default ArrayBuffer asArrayBuffer() {
      return Js.cast(this);
    }

    @JsOverlay
    default ArrayBufferView asArrayBufferView() {
      return Js.cast(this);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default IDBKeyRange asIDBKeyRange() {
      return Js.cast(this);
    }

    @JsOverlay
    default JsArray<Object> asJsArray() {
      return Js.cast(this);
    }

    @JsOverlay
    default JsDate asJsDate() {
      return Js.cast(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isArrayBuffer() {
      return (Object) this instanceof ArrayBuffer;
    }

    @JsOverlay
    default boolean isArrayBufferView() {
      return (Object) this instanceof ArrayBufferView;
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isIDBKeyRange() {
      return (Object) this instanceof IDBKeyRange;
    }

    @JsOverlay
    default boolean isJsArray() {
      return (Object) this instanceof JsArray;
    }

    @JsOverlay
    default boolean isJsDate() {
      return (Object) this instanceof JsDate;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface OpenCursorRangeUnionType {
    @JsOverlay
    static IDBIndex.OpenCursorRangeUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default ArrayBuffer asArrayBuffer() {
      return Js.cast(this);
    }

    @JsOverlay
    default ArrayBufferView asArrayBufferView() {
      return Js.cast(this);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default IDBKeyRange asIDBKeyRange() {
      return Js.cast(this);
    }

    @JsOverlay
    default JsArray<Object> asJsArray() {
      return Js.cast(this);
    }

    @JsOverlay
    default JsDate asJsDate() {
      return Js.cast(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isArrayBuffer() {
      return (Object) this instanceof ArrayBuffer;
    }

    @JsOverlay
    default boolean isArrayBufferView() {
      return (Object) this instanceof ArrayBufferView;
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isIDBKeyRange() {
      return (Object) this instanceof IDBKeyRange;
    }

    @JsOverlay
    default boolean isJsArray() {
      return (Object) this instanceof JsArray;
    }

    @JsOverlay
    default boolean isJsDate() {
      return (Object) this instanceof JsDate;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface OpenKeyCursorRangeUnionType {
    @JsOverlay
    static IDBIndex.OpenKeyCursorRangeUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default ArrayBuffer asArrayBuffer() {
      return Js.cast(this);
    }

    @JsOverlay
    default ArrayBufferView asArrayBufferView() {
      return Js.cast(this);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default IDBKeyRange asIDBKeyRange() {
      return Js.cast(this);
    }

    @JsOverlay
    default JsArray<Object> asJsArray() {
      return Js.cast(this);
    }

    @JsOverlay
    default JsDate asJsDate() {
      return Js.cast(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isArrayBuffer() {
      return (Object) this instanceof ArrayBuffer;
    }

    @JsOverlay
    default boolean isArrayBufferView() {
      return (Object) this instanceof ArrayBufferView;
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isIDBKeyRange() {
      return (Object) this instanceof IDBKeyRange;
    }

    @JsOverlay
    default boolean isJsArray() {
      return (Object) this instanceof JsArray;
    }

    @JsOverlay
    default boolean isJsDate() {
      return (Object) this instanceof JsDate;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  public Object keyPath;
  public boolean multiEntry;
  public String name;
  public IDBObjectStore objectStore;
  public boolean unique;

  public native IDBRequest count();

  @JsOverlay
  public final IDBRequest count(ArrayBuffer key) {
    return count(Js.<IDBIndex.CountKeyUnionType>uncheckedCast(key));
  }

  @JsOverlay
  public final IDBRequest count(ArrayBufferView key) {
    return count(Js.<IDBIndex.CountKeyUnionType>uncheckedCast(key));
  }

  public native IDBRequest count(IDBIndex.CountKeyUnionType key);

  @JsOverlay
  public final IDBRequest count(IDBKeyRange key) {
    return count(Js.<IDBIndex.CountKeyUnionType>uncheckedCast(key));
  }

  @JsOverlay
  public final IDBRequest count(JsArray<Object> key) {
    return count(Js.<IDBIndex.CountKeyUnionType>uncheckedCast(key));
  }

  @JsOverlay
  public final IDBRequest count(JsDate key) {
    return count(Js.<IDBIndex.CountKeyUnionType>uncheckedCast(key));
  }

  @JsOverlay
  public final IDBRequest count(Object[] key) {
    return count(Js.<JsArray<Object>>uncheckedCast(key));
  }

  @JsOverlay
  public final IDBRequest count(String key) {
    return count(Js.<IDBIndex.CountKeyUnionType>uncheckedCast(key));
  }

  @JsOverlay
  public final IDBRequest count(double key) {
    return count(Js.<IDBIndex.CountKeyUnionType>uncheckedCast(key));
  }

  @JsOverlay
  public final IDBRequest get(ArrayBuffer key) {
    return get(Js.<IDBIndex.GetKeyUnionType>uncheckedCast(key));
  }

  @JsOverlay
  public final IDBRequest get(ArrayBufferView key) {
    return get(Js.<IDBIndex.GetKeyUnionType>uncheckedCast(key));
  }

  public native IDBRequest get(IDBIndex.GetKeyUnionType key);

  @JsOverlay
  public final IDBRequest get(IDBKeyRange key) {
    return get(Js.<IDBIndex.GetKeyUnionType>uncheckedCast(key));
  }

  @JsOverlay
  public final IDBRequest get(JsArray<Object> key) {
    return get(Js.<IDBIndex.GetKeyUnionType>uncheckedCast(key));
  }

  @JsOverlay
  public final IDBRequest get(JsDate key) {
    return get(Js.<IDBIndex.GetKeyUnionType>uncheckedCast(key));
  }

  @JsOverlay
  public final IDBRequest get(Object[] key) {
    return get(Js.<JsArray<Object>>uncheckedCast(key));
  }

  @JsOverlay
  public final IDBRequest get(String key) {
    return get(Js.<IDBIndex.GetKeyUnionType>uncheckedCast(key));
  }

  @JsOverlay
  public final IDBRequest get(double key) {
    return get(Js.<IDBIndex.GetKeyUnionType>uncheckedCast(key));
  }

  public native IDBRequest getAll();

  @JsOverlay
  public final IDBRequest getAll(ArrayBuffer query, int count) {
    return getAll(Js.<IDBIndex.GetAllQueryUnionType>uncheckedCast(query), count);
  }

  @JsOverlay
  public final IDBRequest getAll(ArrayBuffer query) {
    return getAll(Js.<IDBIndex.GetAllQueryUnionType>uncheckedCast(query));
  }

  @JsOverlay
  public final IDBRequest getAll(ArrayBufferView query, int count) {
    return getAll(Js.<IDBIndex.GetAllQueryUnionType>uncheckedCast(query), count);
  }

  @JsOverlay
  public final IDBRequest getAll(ArrayBufferView query) {
    return getAll(Js.<IDBIndex.GetAllQueryUnionType>uncheckedCast(query));
  }

  public native IDBRequest getAll(IDBIndex.GetAllQueryUnionType query, int count);

  public native IDBRequest getAll(IDBIndex.GetAllQueryUnionType query);

  @JsOverlay
  public final IDBRequest getAll(IDBKeyRange query, int count) {
    return getAll(Js.<IDBIndex.GetAllQueryUnionType>uncheckedCast(query), count);
  }

  @JsOverlay
  public final IDBRequest getAll(IDBKeyRange query) {
    return getAll(Js.<IDBIndex.GetAllQueryUnionType>uncheckedCast(query));
  }

  @JsOverlay
  public final IDBRequest getAll(JsArray<Object> query, int count) {
    return getAll(Js.<IDBIndex.GetAllQueryUnionType>uncheckedCast(query), count);
  }

  @JsOverlay
  public final IDBRequest getAll(JsArray<Object> query) {
    return getAll(Js.<IDBIndex.GetAllQueryUnionType>uncheckedCast(query));
  }

  @JsOverlay
  public final IDBRequest getAll(JsDate query, int count) {
    return getAll(Js.<IDBIndex.GetAllQueryUnionType>uncheckedCast(query), count);
  }

  @JsOverlay
  public final IDBRequest getAll(JsDate query) {
    return getAll(Js.<IDBIndex.GetAllQueryUnionType>uncheckedCast(query));
  }

  @JsOverlay
  public final IDBRequest getAll(Object[] query, int count) {
    return getAll(Js.<JsArray<Object>>uncheckedCast(query), count);
  }

  @JsOverlay
  public final IDBRequest getAll(Object[] query) {
    return getAll(Js.<JsArray<Object>>uncheckedCast(query));
  }

  @JsOverlay
  public final IDBRequest getAll(String query, int count) {
    return getAll(Js.<IDBIndex.GetAllQueryUnionType>uncheckedCast(query), count);
  }

  @JsOverlay
  public final IDBRequest getAll(String query) {
    return getAll(Js.<IDBIndex.GetAllQueryUnionType>uncheckedCast(query));
  }

  @JsOverlay
  public final IDBRequest getAll(double query, int count) {
    return getAll(Js.<IDBIndex.GetAllQueryUnionType>uncheckedCast(query), count);
  }

  @JsOverlay
  public final IDBRequest getAll(double query) {
    return getAll(Js.<IDBIndex.GetAllQueryUnionType>uncheckedCast(query));
  }

  public native IDBRequest getAllKeys();

  @JsOverlay
  public final IDBRequest getAllKeys(ArrayBuffer query, int count) {
    return getAllKeys(Js.<IDBIndex.GetAllKeysQueryUnionType>uncheckedCast(query), count);
  }

  @JsOverlay
  public final IDBRequest getAllKeys(ArrayBuffer query) {
    return getAllKeys(Js.<IDBIndex.GetAllKeysQueryUnionType>uncheckedCast(query));
  }

  @JsOverlay
  public final IDBRequest getAllKeys(ArrayBufferView query, int count) {
    return getAllKeys(Js.<IDBIndex.GetAllKeysQueryUnionType>uncheckedCast(query), count);
  }

  @JsOverlay
  public final IDBRequest getAllKeys(ArrayBufferView query) {
    return getAllKeys(Js.<IDBIndex.GetAllKeysQueryUnionType>uncheckedCast(query));
  }

  public native IDBRequest getAllKeys(IDBIndex.GetAllKeysQueryUnionType query, int count);

  public native IDBRequest getAllKeys(IDBIndex.GetAllKeysQueryUnionType query);

  @JsOverlay
  public final IDBRequest getAllKeys(IDBKeyRange query, int count) {
    return getAllKeys(Js.<IDBIndex.GetAllKeysQueryUnionType>uncheckedCast(query), count);
  }

  @JsOverlay
  public final IDBRequest getAllKeys(IDBKeyRange query) {
    return getAllKeys(Js.<IDBIndex.GetAllKeysQueryUnionType>uncheckedCast(query));
  }

  @JsOverlay
  public final IDBRequest getAllKeys(JsArray<Object> query, int count) {
    return getAllKeys(Js.<IDBIndex.GetAllKeysQueryUnionType>uncheckedCast(query), count);
  }

  @JsOverlay
  public final IDBRequest getAllKeys(JsArray<Object> query) {
    return getAllKeys(Js.<IDBIndex.GetAllKeysQueryUnionType>uncheckedCast(query));
  }

  @JsOverlay
  public final IDBRequest getAllKeys(JsDate query, int count) {
    return getAllKeys(Js.<IDBIndex.GetAllKeysQueryUnionType>uncheckedCast(query), count);
  }

  @JsOverlay
  public final IDBRequest getAllKeys(JsDate query) {
    return getAllKeys(Js.<IDBIndex.GetAllKeysQueryUnionType>uncheckedCast(query));
  }

  @JsOverlay
  public final IDBRequest getAllKeys(Object[] query, int count) {
    return getAllKeys(Js.<JsArray<Object>>uncheckedCast(query), count);
  }

  @JsOverlay
  public final IDBRequest getAllKeys(Object[] query) {
    return getAllKeys(Js.<JsArray<Object>>uncheckedCast(query));
  }

  @JsOverlay
  public final IDBRequest getAllKeys(String query, int count) {
    return getAllKeys(Js.<IDBIndex.GetAllKeysQueryUnionType>uncheckedCast(query), count);
  }

  @JsOverlay
  public final IDBRequest getAllKeys(String query) {
    return getAllKeys(Js.<IDBIndex.GetAllKeysQueryUnionType>uncheckedCast(query));
  }

  @JsOverlay
  public final IDBRequest getAllKeys(double query, int count) {
    return getAllKeys(Js.<IDBIndex.GetAllKeysQueryUnionType>uncheckedCast(query), count);
  }

  @JsOverlay
  public final IDBRequest getAllKeys(double query) {
    return getAllKeys(Js.<IDBIndex.GetAllKeysQueryUnionType>uncheckedCast(query));
  }

  @JsOverlay
  public final IDBRequest getKey(ArrayBuffer key) {
    return getKey(Js.<IDBIndex.GetKeyKeyUnionType>uncheckedCast(key));
  }

  @JsOverlay
  public final IDBRequest getKey(ArrayBufferView key) {
    return getKey(Js.<IDBIndex.GetKeyKeyUnionType>uncheckedCast(key));
  }

  public native IDBRequest getKey(IDBIndex.GetKeyKeyUnionType key);

  @JsOverlay
  public final IDBRequest getKey(IDBKeyRange key) {
    return getKey(Js.<IDBIndex.GetKeyKeyUnionType>uncheckedCast(key));
  }

  @JsOverlay
  public final IDBRequest getKey(JsArray<Object> key) {
    return getKey(Js.<IDBIndex.GetKeyKeyUnionType>uncheckedCast(key));
  }

  @JsOverlay
  public final IDBRequest getKey(JsDate key) {
    return getKey(Js.<IDBIndex.GetKeyKeyUnionType>uncheckedCast(key));
  }

  @JsOverlay
  public final IDBRequest getKey(Object[] key) {
    return getKey(Js.<JsArray<Object>>uncheckedCast(key));
  }

  @JsOverlay
  public final IDBRequest getKey(String key) {
    return getKey(Js.<IDBIndex.GetKeyKeyUnionType>uncheckedCast(key));
  }

  @JsOverlay
  public final IDBRequest getKey(double key) {
    return getKey(Js.<IDBIndex.GetKeyKeyUnionType>uncheckedCast(key));
  }

  public native IDBRequest openCursor();

  @JsOverlay
  public final IDBRequest openCursor(ArrayBuffer range, String direction) {
    return openCursor(Js.<IDBIndex.OpenCursorRangeUnionType>uncheckedCast(range), direction);
  }

  @JsOverlay
  public final IDBRequest openCursor(ArrayBuffer range) {
    return openCursor(Js.<IDBIndex.OpenCursorRangeUnionType>uncheckedCast(range));
  }

  @JsOverlay
  public final IDBRequest openCursor(ArrayBufferView range, String direction) {
    return openCursor(Js.<IDBIndex.OpenCursorRangeUnionType>uncheckedCast(range), direction);
  }

  @JsOverlay
  public final IDBRequest openCursor(ArrayBufferView range) {
    return openCursor(Js.<IDBIndex.OpenCursorRangeUnionType>uncheckedCast(range));
  }

  @JsOverlay
  public final IDBRequest openCursor(IDBKeyRange range, String direction) {
    return openCursor(Js.<IDBIndex.OpenCursorRangeUnionType>uncheckedCast(range), direction);
  }

  @JsOverlay
  public final IDBRequest openCursor(IDBKeyRange range) {
    return openCursor(Js.<IDBIndex.OpenCursorRangeUnionType>uncheckedCast(range));
  }

  @JsOverlay
  public final IDBRequest openCursor(JsArray<Object> range, String direction) {
    return openCursor(Js.<IDBIndex.OpenCursorRangeUnionType>uncheckedCast(range), direction);
  }

  @JsOverlay
  public final IDBRequest openCursor(JsArray<Object> range) {
    return openCursor(Js.<IDBIndex.OpenCursorRangeUnionType>uncheckedCast(range));
  }

  @JsOverlay
  public final IDBRequest openCursor(JsDate range, String direction) {
    return openCursor(Js.<IDBIndex.OpenCursorRangeUnionType>uncheckedCast(range), direction);
  }

  @JsOverlay
  public final IDBRequest openCursor(JsDate range) {
    return openCursor(Js.<IDBIndex.OpenCursorRangeUnionType>uncheckedCast(range));
  }

  @JsOverlay
  public final IDBRequest openCursor(Object[] range, String direction) {
    return openCursor(Js.<JsArray<Object>>uncheckedCast(range), direction);
  }

  @JsOverlay
  public final IDBRequest openCursor(Object[] range) {
    return openCursor(Js.<JsArray<Object>>uncheckedCast(range));
  }

  public native IDBRequest openCursor(IDBIndex.OpenCursorRangeUnionType range, String direction);

  public native IDBRequest openCursor(IDBIndex.OpenCursorRangeUnionType range);

  @JsOverlay
  public final IDBRequest openCursor(String range, String direction) {
    return openCursor(Js.<IDBIndex.OpenCursorRangeUnionType>uncheckedCast(range), direction);
  }

  @JsOverlay
  public final IDBRequest openCursor(String range) {
    return openCursor(Js.<IDBIndex.OpenCursorRangeUnionType>uncheckedCast(range));
  }

  @JsOverlay
  public final IDBRequest openCursor(double range, String direction) {
    return openCursor(Js.<IDBIndex.OpenCursorRangeUnionType>uncheckedCast(range), direction);
  }

  @JsOverlay
  public final IDBRequest openCursor(double range) {
    return openCursor(Js.<IDBIndex.OpenCursorRangeUnionType>uncheckedCast(range));
  }

  public native IDBRequest openKeyCursor();

  @JsOverlay
  public final IDBRequest openKeyCursor(ArrayBuffer range, String direction) {
    return openKeyCursor(Js.<IDBIndex.OpenKeyCursorRangeUnionType>uncheckedCast(range), direction);
  }

  @JsOverlay
  public final IDBRequest openKeyCursor(ArrayBuffer range) {
    return openKeyCursor(Js.<IDBIndex.OpenKeyCursorRangeUnionType>uncheckedCast(range));
  }

  @JsOverlay
  public final IDBRequest openKeyCursor(ArrayBufferView range, String direction) {
    return openKeyCursor(Js.<IDBIndex.OpenKeyCursorRangeUnionType>uncheckedCast(range), direction);
  }

  @JsOverlay
  public final IDBRequest openKeyCursor(ArrayBufferView range) {
    return openKeyCursor(Js.<IDBIndex.OpenKeyCursorRangeUnionType>uncheckedCast(range));
  }

  @JsOverlay
  public final IDBRequest openKeyCursor(IDBKeyRange range, String direction) {
    return openKeyCursor(Js.<IDBIndex.OpenKeyCursorRangeUnionType>uncheckedCast(range), direction);
  }

  @JsOverlay
  public final IDBRequest openKeyCursor(IDBKeyRange range) {
    return openKeyCursor(Js.<IDBIndex.OpenKeyCursorRangeUnionType>uncheckedCast(range));
  }

  @JsOverlay
  public final IDBRequest openKeyCursor(JsArray<Object> range, String direction) {
    return openKeyCursor(Js.<IDBIndex.OpenKeyCursorRangeUnionType>uncheckedCast(range), direction);
  }

  @JsOverlay
  public final IDBRequest openKeyCursor(JsArray<Object> range) {
    return openKeyCursor(Js.<IDBIndex.OpenKeyCursorRangeUnionType>uncheckedCast(range));
  }

  @JsOverlay
  public final IDBRequest openKeyCursor(JsDate range, String direction) {
    return openKeyCursor(Js.<IDBIndex.OpenKeyCursorRangeUnionType>uncheckedCast(range), direction);
  }

  @JsOverlay
  public final IDBRequest openKeyCursor(JsDate range) {
    return openKeyCursor(Js.<IDBIndex.OpenKeyCursorRangeUnionType>uncheckedCast(range));
  }

  @JsOverlay
  public final IDBRequest openKeyCursor(Object[] range, String direction) {
    return openKeyCursor(Js.<JsArray<Object>>uncheckedCast(range), direction);
  }

  @JsOverlay
  public final IDBRequest openKeyCursor(Object[] range) {
    return openKeyCursor(Js.<JsArray<Object>>uncheckedCast(range));
  }

  public native IDBRequest openKeyCursor(
      IDBIndex.OpenKeyCursorRangeUnionType range, String direction);

  public native IDBRequest openKeyCursor(IDBIndex.OpenKeyCursorRangeUnionType range);

  @JsOverlay
  public final IDBRequest openKeyCursor(String range, String direction) {
    return openKeyCursor(Js.<IDBIndex.OpenKeyCursorRangeUnionType>uncheckedCast(range), direction);
  }

  @JsOverlay
  public final IDBRequest openKeyCursor(String range) {
    return openKeyCursor(Js.<IDBIndex.OpenKeyCursorRangeUnionType>uncheckedCast(range));
  }

  @JsOverlay
  public final IDBRequest openKeyCursor(double range, String direction) {
    return openKeyCursor(Js.<IDBIndex.OpenKeyCursorRangeUnionType>uncheckedCast(range), direction);
  }

  @JsOverlay
  public final IDBRequest openKeyCursor(double range) {
    return openKeyCursor(Js.<IDBIndex.OpenKeyCursorRangeUnionType>uncheckedCast(range));
  }
}
