package elemental2.indexeddb;

import elemental2.core.ArrayBuffer;
import elemental2.core.ArrayBufferView;
import elemental2.core.JsArray;
import elemental2.core.JsDate;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class IDBKeyRange {
  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface BoundLeftUnionType {
    @JsOverlay
    static IDBKeyRange.BoundLeftUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default ArrayBuffer asArrayBuffer() {
      return Js.cast(this);
    }

    @JsOverlay
    default ArrayBufferView asArrayBufferView() {
      return Js.cast(this);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default JsArray<Object> asJsArray() {
      return Js.cast(this);
    }

    @JsOverlay
    default JsDate asJsDate() {
      return Js.cast(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isArrayBuffer() {
      return (Object) this instanceof ArrayBuffer;
    }

    @JsOverlay
    default boolean isArrayBufferView() {
      return (Object) this instanceof ArrayBufferView;
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isJsArray() {
      return (Object) this instanceof JsArray;
    }

    @JsOverlay
    default boolean isJsDate() {
      return (Object) this instanceof JsDate;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface BoundRightUnionType {
    @JsOverlay
    static IDBKeyRange.BoundRightUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default ArrayBuffer asArrayBuffer() {
      return Js.cast(this);
    }

    @JsOverlay
    default ArrayBufferView asArrayBufferView() {
      return Js.cast(this);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default JsArray<Object> asJsArray() {
      return Js.cast(this);
    }

    @JsOverlay
    default JsDate asJsDate() {
      return Js.cast(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isArrayBuffer() {
      return (Object) this instanceof ArrayBuffer;
    }

    @JsOverlay
    default boolean isArrayBufferView() {
      return (Object) this instanceof ArrayBufferView;
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isJsArray() {
      return (Object) this instanceof JsArray;
    }

    @JsOverlay
    default boolean isJsDate() {
      return (Object) this instanceof JsDate;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface IncludesKeyUnionType {
    @JsOverlay
    static IDBKeyRange.IncludesKeyUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default ArrayBuffer asArrayBuffer() {
      return Js.cast(this);
    }

    @JsOverlay
    default ArrayBufferView asArrayBufferView() {
      return Js.cast(this);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default JsArray<Object> asJsArray() {
      return Js.cast(this);
    }

    @JsOverlay
    default JsDate asJsDate() {
      return Js.cast(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isArrayBuffer() {
      return (Object) this instanceof ArrayBuffer;
    }

    @JsOverlay
    default boolean isArrayBufferView() {
      return (Object) this instanceof ArrayBufferView;
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isJsArray() {
      return (Object) this instanceof JsArray;
    }

    @JsOverlay
    default boolean isJsDate() {
      return (Object) this instanceof JsDate;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface LowerBoundBoundUnionType {
    @JsOverlay
    static IDBKeyRange.LowerBoundBoundUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default ArrayBuffer asArrayBuffer() {
      return Js.cast(this);
    }

    @JsOverlay
    default ArrayBufferView asArrayBufferView() {
      return Js.cast(this);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default JsArray<Object> asJsArray() {
      return Js.cast(this);
    }

    @JsOverlay
    default JsDate asJsDate() {
      return Js.cast(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isArrayBuffer() {
      return (Object) this instanceof ArrayBuffer;
    }

    @JsOverlay
    default boolean isArrayBufferView() {
      return (Object) this instanceof ArrayBufferView;
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isJsArray() {
      return (Object) this instanceof JsArray;
    }

    @JsOverlay
    default boolean isJsDate() {
      return (Object) this instanceof JsDate;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface OnlyValueUnionType {
    @JsOverlay
    static IDBKeyRange.OnlyValueUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default ArrayBuffer asArrayBuffer() {
      return Js.cast(this);
    }

    @JsOverlay
    default ArrayBufferView asArrayBufferView() {
      return Js.cast(this);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default JsArray<Object> asJsArray() {
      return Js.cast(this);
    }

    @JsOverlay
    default JsDate asJsDate() {
      return Js.cast(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isArrayBuffer() {
      return (Object) this instanceof ArrayBuffer;
    }

    @JsOverlay
    default boolean isArrayBufferView() {
      return (Object) this instanceof ArrayBufferView;
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isJsArray() {
      return (Object) this instanceof JsArray;
    }

    @JsOverlay
    default boolean isJsDate() {
      return (Object) this instanceof JsDate;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface UpperBoundBoundUnionType {
    @JsOverlay
    static IDBKeyRange.UpperBoundBoundUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default ArrayBuffer asArrayBuffer() {
      return Js.cast(this);
    }

    @JsOverlay
    default ArrayBufferView asArrayBufferView() {
      return Js.cast(this);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default JsArray<Object> asJsArray() {
      return Js.cast(this);
    }

    @JsOverlay
    default JsDate asJsDate() {
      return Js.cast(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isArrayBuffer() {
      return (Object) this instanceof ArrayBuffer;
    }

    @JsOverlay
    default boolean isArrayBufferView() {
      return (Object) this instanceof ArrayBufferView;
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isJsArray() {
      return (Object) this instanceof JsArray;
    }

    @JsOverlay
    default boolean isJsDate() {
      return (Object) this instanceof JsDate;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      ArrayBuffer left, ArrayBuffer right, boolean openLeft, boolean openRight) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft,
        openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(ArrayBuffer left, ArrayBuffer right, boolean openLeft) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(ArrayBuffer left, ArrayBuffer right) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right));
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      ArrayBuffer left, ArrayBufferView right, boolean openLeft, boolean openRight) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft,
        openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(ArrayBuffer left, ArrayBufferView right, boolean openLeft) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(ArrayBuffer left, ArrayBufferView right) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right));
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      ArrayBuffer left,
      IDBKeyRange.BoundRightUnionType right,
      boolean openLeft,
      boolean openRight) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left), right, openLeft, openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      ArrayBuffer left, IDBKeyRange.BoundRightUnionType right, boolean openLeft) {
    return bound(Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left), right, openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(ArrayBuffer left, IDBKeyRange.BoundRightUnionType right) {
    return bound(Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left), right);
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      ArrayBuffer left, JsArray<Object> right, boolean openLeft, boolean openRight) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft,
        openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(ArrayBuffer left, JsArray<Object> right, boolean openLeft) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(ArrayBuffer left, JsArray<Object> right) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right));
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      ArrayBuffer left, JsDate right, boolean openLeft, boolean openRight) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft,
        openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(ArrayBuffer left, JsDate right, boolean openLeft) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(ArrayBuffer left, JsDate right) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right));
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      ArrayBuffer left, Object[] right, boolean openLeft, boolean openRight) {
    return bound(left, Js.<JsArray<Object>>uncheckedCast(right), openLeft, openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(ArrayBuffer left, Object[] right, boolean openLeft) {
    return bound(left, Js.<JsArray<Object>>uncheckedCast(right), openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(ArrayBuffer left, Object[] right) {
    return bound(left, Js.<JsArray<Object>>uncheckedCast(right));
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      ArrayBuffer left, String right, boolean openLeft, boolean openRight) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft,
        openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(ArrayBuffer left, String right, boolean openLeft) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(ArrayBuffer left, String right) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right));
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      ArrayBuffer left, double right, boolean openLeft, boolean openRight) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft,
        openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(ArrayBuffer left, double right, boolean openLeft) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(ArrayBuffer left, double right) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right));
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      ArrayBufferView left, ArrayBuffer right, boolean openLeft, boolean openRight) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft,
        openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(ArrayBufferView left, ArrayBuffer right, boolean openLeft) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(ArrayBufferView left, ArrayBuffer right) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right));
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      ArrayBufferView left, ArrayBufferView right, boolean openLeft, boolean openRight) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft,
        openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      ArrayBufferView left, ArrayBufferView right, boolean openLeft) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(ArrayBufferView left, ArrayBufferView right) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right));
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      ArrayBufferView left,
      IDBKeyRange.BoundRightUnionType right,
      boolean openLeft,
      boolean openRight) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left), right, openLeft, openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      ArrayBufferView left, IDBKeyRange.BoundRightUnionType right, boolean openLeft) {
    return bound(Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left), right, openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      ArrayBufferView left, IDBKeyRange.BoundRightUnionType right) {
    return bound(Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left), right);
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      ArrayBufferView left, JsArray<Object> right, boolean openLeft, boolean openRight) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft,
        openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      ArrayBufferView left, JsArray<Object> right, boolean openLeft) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(ArrayBufferView left, JsArray<Object> right) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right));
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      ArrayBufferView left, JsDate right, boolean openLeft, boolean openRight) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft,
        openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(ArrayBufferView left, JsDate right, boolean openLeft) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(ArrayBufferView left, JsDate right) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right));
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      ArrayBufferView left, Object[] right, boolean openLeft, boolean openRight) {
    return bound(left, Js.<JsArray<Object>>uncheckedCast(right), openLeft, openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(ArrayBufferView left, Object[] right, boolean openLeft) {
    return bound(left, Js.<JsArray<Object>>uncheckedCast(right), openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(ArrayBufferView left, Object[] right) {
    return bound(left, Js.<JsArray<Object>>uncheckedCast(right));
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      ArrayBufferView left, String right, boolean openLeft, boolean openRight) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft,
        openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(ArrayBufferView left, String right, boolean openLeft) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(ArrayBufferView left, String right) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right));
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      ArrayBufferView left, double right, boolean openLeft, boolean openRight) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft,
        openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(ArrayBufferView left, double right, boolean openLeft) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(ArrayBufferView left, double right) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right));
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      IDBKeyRange.BoundLeftUnionType left, ArrayBuffer right, boolean openLeft, boolean openRight) {
    return bound(
        left, Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right), openLeft, openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      IDBKeyRange.BoundLeftUnionType left, ArrayBuffer right, boolean openLeft) {
    return bound(left, Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right), openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(IDBKeyRange.BoundLeftUnionType left, ArrayBuffer right) {
    return bound(left, Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right));
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      IDBKeyRange.BoundLeftUnionType left,
      ArrayBufferView right,
      boolean openLeft,
      boolean openRight) {
    return bound(
        left, Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right), openLeft, openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      IDBKeyRange.BoundLeftUnionType left, ArrayBufferView right, boolean openLeft) {
    return bound(left, Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right), openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      IDBKeyRange.BoundLeftUnionType left, ArrayBufferView right) {
    return bound(left, Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right));
  }

  public static native IDBKeyRange bound(
      IDBKeyRange.BoundLeftUnionType left,
      IDBKeyRange.BoundRightUnionType right,
      boolean openLeft,
      boolean openRight);

  public static native IDBKeyRange bound(
      IDBKeyRange.BoundLeftUnionType left, IDBKeyRange.BoundRightUnionType right, boolean openLeft);

  public static native IDBKeyRange bound(
      IDBKeyRange.BoundLeftUnionType left, IDBKeyRange.BoundRightUnionType right);

  @JsOverlay
  public static final IDBKeyRange bound(
      IDBKeyRange.BoundLeftUnionType left,
      JsArray<Object> right,
      boolean openLeft,
      boolean openRight) {
    return bound(
        left, Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right), openLeft, openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      IDBKeyRange.BoundLeftUnionType left, JsArray<Object> right, boolean openLeft) {
    return bound(left, Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right), openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      IDBKeyRange.BoundLeftUnionType left, JsArray<Object> right) {
    return bound(left, Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right));
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      IDBKeyRange.BoundLeftUnionType left, JsDate right, boolean openLeft, boolean openRight) {
    return bound(
        left, Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right), openLeft, openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      IDBKeyRange.BoundLeftUnionType left, JsDate right, boolean openLeft) {
    return bound(left, Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right), openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(IDBKeyRange.BoundLeftUnionType left, JsDate right) {
    return bound(left, Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right));
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      IDBKeyRange.BoundLeftUnionType left, Object[] right, boolean openLeft, boolean openRight) {
    return bound(left, Js.<JsArray<Object>>uncheckedCast(right), openLeft, openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      IDBKeyRange.BoundLeftUnionType left, Object[] right, boolean openLeft) {
    return bound(left, Js.<JsArray<Object>>uncheckedCast(right), openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(IDBKeyRange.BoundLeftUnionType left, Object[] right) {
    return bound(left, Js.<JsArray<Object>>uncheckedCast(right));
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      IDBKeyRange.BoundLeftUnionType left, String right, boolean openLeft, boolean openRight) {
    return bound(
        left, Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right), openLeft, openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      IDBKeyRange.BoundLeftUnionType left, String right, boolean openLeft) {
    return bound(left, Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right), openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(IDBKeyRange.BoundLeftUnionType left, String right) {
    return bound(left, Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right));
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      IDBKeyRange.BoundLeftUnionType left, double right, boolean openLeft, boolean openRight) {
    return bound(
        left, Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right), openLeft, openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      IDBKeyRange.BoundLeftUnionType left, double right, boolean openLeft) {
    return bound(left, Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right), openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(IDBKeyRange.BoundLeftUnionType left, double right) {
    return bound(left, Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right));
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      JsArray<Object> left, ArrayBuffer right, boolean openLeft, boolean openRight) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft,
        openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(JsArray<Object> left, ArrayBuffer right, boolean openLeft) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(JsArray<Object> left, ArrayBuffer right) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right));
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      JsArray<Object> left, ArrayBufferView right, boolean openLeft, boolean openRight) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft,
        openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      JsArray<Object> left, ArrayBufferView right, boolean openLeft) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(JsArray<Object> left, ArrayBufferView right) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right));
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      JsArray<Object> left,
      IDBKeyRange.BoundRightUnionType right,
      boolean openLeft,
      boolean openRight) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left), right, openLeft, openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      JsArray<Object> left, IDBKeyRange.BoundRightUnionType right, boolean openLeft) {
    return bound(Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left), right, openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      JsArray<Object> left, IDBKeyRange.BoundRightUnionType right) {
    return bound(Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left), right);
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      JsArray<Object> left, JsArray<Object> right, boolean openLeft, boolean openRight) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft,
        openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      JsArray<Object> left, JsArray<Object> right, boolean openLeft) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(JsArray<Object> left, JsArray<Object> right) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right));
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      JsArray<Object> left, JsDate right, boolean openLeft, boolean openRight) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft,
        openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(JsArray<Object> left, JsDate right, boolean openLeft) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(JsArray<Object> left, JsDate right) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right));
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      JsArray<Object> left, String right, boolean openLeft, boolean openRight) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft,
        openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(JsArray<Object> left, String right, boolean openLeft) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(JsArray<Object> left, String right) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right));
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      JsArray<Object> left, double right, boolean openLeft, boolean openRight) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft,
        openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(JsArray<Object> left, double right, boolean openLeft) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(JsArray<Object> left, double right) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right));
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      JsDate left, ArrayBuffer right, boolean openLeft, boolean openRight) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft,
        openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(JsDate left, ArrayBuffer right, boolean openLeft) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(JsDate left, ArrayBuffer right) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right));
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      JsDate left, ArrayBufferView right, boolean openLeft, boolean openRight) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft,
        openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(JsDate left, ArrayBufferView right, boolean openLeft) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(JsDate left, ArrayBufferView right) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right));
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      JsDate left, IDBKeyRange.BoundRightUnionType right, boolean openLeft, boolean openRight) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left), right, openLeft, openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      JsDate left, IDBKeyRange.BoundRightUnionType right, boolean openLeft) {
    return bound(Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left), right, openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(JsDate left, IDBKeyRange.BoundRightUnionType right) {
    return bound(Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left), right);
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      JsDate left, JsArray<Object> right, boolean openLeft, boolean openRight) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft,
        openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(JsDate left, JsArray<Object> right, boolean openLeft) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(JsDate left, JsArray<Object> right) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right));
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      JsDate left, JsDate right, boolean openLeft, boolean openRight) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft,
        openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(JsDate left, JsDate right, boolean openLeft) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(JsDate left, JsDate right) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right));
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      JsDate left, Object[] right, boolean openLeft, boolean openRight) {
    return bound(left, Js.<JsArray<Object>>uncheckedCast(right), openLeft, openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(JsDate left, Object[] right, boolean openLeft) {
    return bound(left, Js.<JsArray<Object>>uncheckedCast(right), openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(JsDate left, Object[] right) {
    return bound(left, Js.<JsArray<Object>>uncheckedCast(right));
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      JsDate left, String right, boolean openLeft, boolean openRight) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft,
        openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(JsDate left, String right, boolean openLeft) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(JsDate left, String right) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right));
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      JsDate left, double right, boolean openLeft, boolean openRight) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft,
        openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(JsDate left, double right, boolean openLeft) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(JsDate left, double right) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right));
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      Object[] left, ArrayBuffer right, boolean openLeft, boolean openRight) {
    return bound(Js.<JsArray<Object>>uncheckedCast(left), right, openLeft, openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(Object[] left, ArrayBuffer right, boolean openLeft) {
    return bound(Js.<JsArray<Object>>uncheckedCast(left), right, openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(Object[] left, ArrayBuffer right) {
    return bound(Js.<JsArray<Object>>uncheckedCast(left), right);
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      Object[] left, ArrayBufferView right, boolean openLeft, boolean openRight) {
    return bound(Js.<JsArray<Object>>uncheckedCast(left), right, openLeft, openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(Object[] left, ArrayBufferView right, boolean openLeft) {
    return bound(Js.<JsArray<Object>>uncheckedCast(left), right, openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(Object[] left, ArrayBufferView right) {
    return bound(Js.<JsArray<Object>>uncheckedCast(left), right);
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      Object[] left, IDBKeyRange.BoundRightUnionType right, boolean openLeft, boolean openRight) {
    return bound(Js.<JsArray<Object>>uncheckedCast(left), right, openLeft, openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      Object[] left, IDBKeyRange.BoundRightUnionType right, boolean openLeft) {
    return bound(Js.<JsArray<Object>>uncheckedCast(left), right, openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(Object[] left, IDBKeyRange.BoundRightUnionType right) {
    return bound(Js.<JsArray<Object>>uncheckedCast(left), right);
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      Object[] left, JsDate right, boolean openLeft, boolean openRight) {
    return bound(Js.<JsArray<Object>>uncheckedCast(left), right, openLeft, openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(Object[] left, JsDate right, boolean openLeft) {
    return bound(Js.<JsArray<Object>>uncheckedCast(left), right, openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(Object[] left, JsDate right) {
    return bound(Js.<JsArray<Object>>uncheckedCast(left), right);
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      Object[] left, Object[] right, boolean openLeft, boolean openRight) {
    return bound(
        Js.<JsArray<Object>>uncheckedCast(left),
        Js.<JsArray<Object>>uncheckedCast(right),
        openLeft,
        openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(Object[] left, Object[] right, boolean openLeft) {
    return bound(
        Js.<JsArray<Object>>uncheckedCast(left),
        Js.<JsArray<Object>>uncheckedCast(right),
        openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(Object[] left, Object[] right) {
    return bound(Js.<JsArray<Object>>uncheckedCast(left), Js.<JsArray<Object>>uncheckedCast(right));
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      Object[] left, String right, boolean openLeft, boolean openRight) {
    return bound(Js.<JsArray<Object>>uncheckedCast(left), right, openLeft, openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(Object[] left, String right, boolean openLeft) {
    return bound(Js.<JsArray<Object>>uncheckedCast(left), right, openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(Object[] left, String right) {
    return bound(Js.<JsArray<Object>>uncheckedCast(left), right);
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      Object[] left, double right, boolean openLeft, boolean openRight) {
    return bound(Js.<JsArray<Object>>uncheckedCast(left), right, openLeft, openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(Object[] left, double right, boolean openLeft) {
    return bound(Js.<JsArray<Object>>uncheckedCast(left), right, openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(Object[] left, double right) {
    return bound(Js.<JsArray<Object>>uncheckedCast(left), right);
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      String left, ArrayBuffer right, boolean openLeft, boolean openRight) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft,
        openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(String left, ArrayBuffer right, boolean openLeft) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(String left, ArrayBuffer right) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right));
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      String left, ArrayBufferView right, boolean openLeft, boolean openRight) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft,
        openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(String left, ArrayBufferView right, boolean openLeft) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(String left, ArrayBufferView right) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right));
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      String left, IDBKeyRange.BoundRightUnionType right, boolean openLeft, boolean openRight) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left), right, openLeft, openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      String left, IDBKeyRange.BoundRightUnionType right, boolean openLeft) {
    return bound(Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left), right, openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(String left, IDBKeyRange.BoundRightUnionType right) {
    return bound(Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left), right);
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      String left, JsArray<Object> right, boolean openLeft, boolean openRight) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft,
        openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(String left, JsArray<Object> right, boolean openLeft) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(String left, JsArray<Object> right) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right));
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      String left, JsDate right, boolean openLeft, boolean openRight) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft,
        openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(String left, JsDate right, boolean openLeft) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(String left, JsDate right) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right));
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      String left, Object[] right, boolean openLeft, boolean openRight) {
    return bound(left, Js.<JsArray<Object>>uncheckedCast(right), openLeft, openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(String left, Object[] right, boolean openLeft) {
    return bound(left, Js.<JsArray<Object>>uncheckedCast(right), openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(String left, Object[] right) {
    return bound(left, Js.<JsArray<Object>>uncheckedCast(right));
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      String left, String right, boolean openLeft, boolean openRight) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft,
        openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(String left, String right, boolean openLeft) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(String left, String right) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right));
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      String left, double right, boolean openLeft, boolean openRight) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft,
        openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(String left, double right, boolean openLeft) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(String left, double right) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right));
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      double left, ArrayBuffer right, boolean openLeft, boolean openRight) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft,
        openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(double left, ArrayBuffer right, boolean openLeft) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(double left, ArrayBuffer right) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right));
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      double left, ArrayBufferView right, boolean openLeft, boolean openRight) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft,
        openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(double left, ArrayBufferView right, boolean openLeft) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(double left, ArrayBufferView right) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right));
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      double left, IDBKeyRange.BoundRightUnionType right, boolean openLeft, boolean openRight) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left), right, openLeft, openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      double left, IDBKeyRange.BoundRightUnionType right, boolean openLeft) {
    return bound(Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left), right, openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(double left, IDBKeyRange.BoundRightUnionType right) {
    return bound(Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left), right);
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      double left, JsArray<Object> right, boolean openLeft, boolean openRight) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft,
        openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(double left, JsArray<Object> right, boolean openLeft) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(double left, JsArray<Object> right) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right));
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      double left, JsDate right, boolean openLeft, boolean openRight) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft,
        openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(double left, JsDate right, boolean openLeft) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(double left, JsDate right) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right));
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      double left, Object[] right, boolean openLeft, boolean openRight) {
    return bound(left, Js.<JsArray<Object>>uncheckedCast(right), openLeft, openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(double left, Object[] right, boolean openLeft) {
    return bound(left, Js.<JsArray<Object>>uncheckedCast(right), openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(double left, Object[] right) {
    return bound(left, Js.<JsArray<Object>>uncheckedCast(right));
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      double left, String right, boolean openLeft, boolean openRight) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft,
        openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(double left, String right, boolean openLeft) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(double left, String right) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right));
  }

  @JsOverlay
  public static final IDBKeyRange bound(
      double left, double right, boolean openLeft, boolean openRight) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft,
        openRight);
  }

  @JsOverlay
  public static final IDBKeyRange bound(double left, double right, boolean openLeft) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right),
        openLeft);
  }

  @JsOverlay
  public static final IDBKeyRange bound(double left, double right) {
    return bound(
        Js.<IDBKeyRange.BoundLeftUnionType>uncheckedCast(left),
        Js.<IDBKeyRange.BoundRightUnionType>uncheckedCast(right));
  }

  @JsOverlay
  public static final IDBKeyRange lowerBound(ArrayBuffer bound, boolean open) {
    return lowerBound(Js.<IDBKeyRange.LowerBoundBoundUnionType>uncheckedCast(bound), open);
  }

  @JsOverlay
  public static final IDBKeyRange lowerBound(ArrayBuffer bound) {
    return lowerBound(Js.<IDBKeyRange.LowerBoundBoundUnionType>uncheckedCast(bound));
  }

  @JsOverlay
  public static final IDBKeyRange lowerBound(ArrayBufferView bound, boolean open) {
    return lowerBound(Js.<IDBKeyRange.LowerBoundBoundUnionType>uncheckedCast(bound), open);
  }

  @JsOverlay
  public static final IDBKeyRange lowerBound(ArrayBufferView bound) {
    return lowerBound(Js.<IDBKeyRange.LowerBoundBoundUnionType>uncheckedCast(bound));
  }

  @JsOverlay
  public static final IDBKeyRange lowerBound(JsArray<Object> bound, boolean open) {
    return lowerBound(Js.<IDBKeyRange.LowerBoundBoundUnionType>uncheckedCast(bound), open);
  }

  @JsOverlay
  public static final IDBKeyRange lowerBound(JsArray<Object> bound) {
    return lowerBound(Js.<IDBKeyRange.LowerBoundBoundUnionType>uncheckedCast(bound));
  }

  @JsOverlay
  public static final IDBKeyRange lowerBound(JsDate bound, boolean open) {
    return lowerBound(Js.<IDBKeyRange.LowerBoundBoundUnionType>uncheckedCast(bound), open);
  }

  @JsOverlay
  public static final IDBKeyRange lowerBound(JsDate bound) {
    return lowerBound(Js.<IDBKeyRange.LowerBoundBoundUnionType>uncheckedCast(bound));
  }

  public static native IDBKeyRange lowerBound(
      IDBKeyRange.LowerBoundBoundUnionType bound, boolean open);

  public static native IDBKeyRange lowerBound(IDBKeyRange.LowerBoundBoundUnionType bound);

  @JsOverlay
  public static final IDBKeyRange lowerBound(Object[] bound, boolean open) {
    return lowerBound(Js.<JsArray<Object>>uncheckedCast(bound), open);
  }

  @JsOverlay
  public static final IDBKeyRange lowerBound(Object[] bound) {
    return lowerBound(Js.<JsArray<Object>>uncheckedCast(bound));
  }

  @JsOverlay
  public static final IDBKeyRange lowerBound(String bound, boolean open) {
    return lowerBound(Js.<IDBKeyRange.LowerBoundBoundUnionType>uncheckedCast(bound), open);
  }

  @JsOverlay
  public static final IDBKeyRange lowerBound(String bound) {
    return lowerBound(Js.<IDBKeyRange.LowerBoundBoundUnionType>uncheckedCast(bound));
  }

  @JsOverlay
  public static final IDBKeyRange lowerBound(double bound, boolean open) {
    return lowerBound(Js.<IDBKeyRange.LowerBoundBoundUnionType>uncheckedCast(bound), open);
  }

  @JsOverlay
  public static final IDBKeyRange lowerBound(double bound) {
    return lowerBound(Js.<IDBKeyRange.LowerBoundBoundUnionType>uncheckedCast(bound));
  }

  @JsOverlay
  public static final IDBKeyRange only(ArrayBuffer value) {
    return only(Js.<IDBKeyRange.OnlyValueUnionType>uncheckedCast(value));
  }

  @JsOverlay
  public static final IDBKeyRange only(ArrayBufferView value) {
    return only(Js.<IDBKeyRange.OnlyValueUnionType>uncheckedCast(value));
  }

  @JsOverlay
  public static final IDBKeyRange only(JsArray<Object> value) {
    return only(Js.<IDBKeyRange.OnlyValueUnionType>uncheckedCast(value));
  }

  @JsOverlay
  public static final IDBKeyRange only(JsDate value) {
    return only(Js.<IDBKeyRange.OnlyValueUnionType>uncheckedCast(value));
  }

  @JsOverlay
  public static final IDBKeyRange only(Object[] value) {
    return only(Js.<JsArray<Object>>uncheckedCast(value));
  }

  public static native IDBKeyRange only(IDBKeyRange.OnlyValueUnionType value);

  @JsOverlay
  public static final IDBKeyRange only(String value) {
    return only(Js.<IDBKeyRange.OnlyValueUnionType>uncheckedCast(value));
  }

  @JsOverlay
  public static final IDBKeyRange only(double value) {
    return only(Js.<IDBKeyRange.OnlyValueUnionType>uncheckedCast(value));
  }

  @JsOverlay
  public static final IDBKeyRange upperBound(ArrayBuffer bound, boolean open) {
    return upperBound(Js.<IDBKeyRange.UpperBoundBoundUnionType>uncheckedCast(bound), open);
  }

  @JsOverlay
  public static final IDBKeyRange upperBound(ArrayBuffer bound) {
    return upperBound(Js.<IDBKeyRange.UpperBoundBoundUnionType>uncheckedCast(bound));
  }

  @JsOverlay
  public static final IDBKeyRange upperBound(ArrayBufferView bound, boolean open) {
    return upperBound(Js.<IDBKeyRange.UpperBoundBoundUnionType>uncheckedCast(bound), open);
  }

  @JsOverlay
  public static final IDBKeyRange upperBound(ArrayBufferView bound) {
    return upperBound(Js.<IDBKeyRange.UpperBoundBoundUnionType>uncheckedCast(bound));
  }

  @JsOverlay
  public static final IDBKeyRange upperBound(JsArray<Object> bound, boolean open) {
    return upperBound(Js.<IDBKeyRange.UpperBoundBoundUnionType>uncheckedCast(bound), open);
  }

  @JsOverlay
  public static final IDBKeyRange upperBound(JsArray<Object> bound) {
    return upperBound(Js.<IDBKeyRange.UpperBoundBoundUnionType>uncheckedCast(bound));
  }

  @JsOverlay
  public static final IDBKeyRange upperBound(JsDate bound, boolean open) {
    return upperBound(Js.<IDBKeyRange.UpperBoundBoundUnionType>uncheckedCast(bound), open);
  }

  @JsOverlay
  public static final IDBKeyRange upperBound(JsDate bound) {
    return upperBound(Js.<IDBKeyRange.UpperBoundBoundUnionType>uncheckedCast(bound));
  }

  @JsOverlay
  public static final IDBKeyRange upperBound(Object[] bound, boolean open) {
    return upperBound(Js.<JsArray<Object>>uncheckedCast(bound), open);
  }

  @JsOverlay
  public static final IDBKeyRange upperBound(Object[] bound) {
    return upperBound(Js.<JsArray<Object>>uncheckedCast(bound));
  }

  @JsOverlay
  public static final IDBKeyRange upperBound(String bound, boolean open) {
    return upperBound(Js.<IDBKeyRange.UpperBoundBoundUnionType>uncheckedCast(bound), open);
  }

  @JsOverlay
  public static final IDBKeyRange upperBound(String bound) {
    return upperBound(Js.<IDBKeyRange.UpperBoundBoundUnionType>uncheckedCast(bound));
  }

  public static native IDBKeyRange upperBound(
      IDBKeyRange.UpperBoundBoundUnionType bound, boolean open);

  public static native IDBKeyRange upperBound(IDBKeyRange.UpperBoundBoundUnionType bound);

  @JsOverlay
  public static final IDBKeyRange upperBound(double bound, boolean open) {
    return upperBound(Js.<IDBKeyRange.UpperBoundBoundUnionType>uncheckedCast(bound), open);
  }

  @JsOverlay
  public static final IDBKeyRange upperBound(double bound) {
    return upperBound(Js.<IDBKeyRange.UpperBoundBoundUnionType>uncheckedCast(bound));
  }

  public Object lower;
  public boolean lowerOpen;
  public Object upper;
  public boolean upperOpen;

  @JsOverlay
  public final boolean includes(ArrayBuffer key) {
    return includes(Js.<IDBKeyRange.IncludesKeyUnionType>uncheckedCast(key));
  }

  @JsOverlay
  public final boolean includes(ArrayBufferView key) {
    return includes(Js.<IDBKeyRange.IncludesKeyUnionType>uncheckedCast(key));
  }

  public native boolean includes(IDBKeyRange.IncludesKeyUnionType key);

  @JsOverlay
  public final boolean includes(JsArray<Object> key) {
    return includes(Js.<IDBKeyRange.IncludesKeyUnionType>uncheckedCast(key));
  }

  @JsOverlay
  public final boolean includes(JsDate key) {
    return includes(Js.<IDBKeyRange.IncludesKeyUnionType>uncheckedCast(key));
  }

  @JsOverlay
  public final boolean includes(Object[] key) {
    return includes(Js.<JsArray<Object>>uncheckedCast(key));
  }

  @JsOverlay
  public final boolean includes(String key) {
    return includes(Js.<IDBKeyRange.IncludesKeyUnionType>uncheckedCast(key));
  }

  @JsOverlay
  public final boolean includes(double key) {
    return includes(Js.<IDBKeyRange.IncludesKeyUnionType>uncheckedCast(key));
  }
}
