package elemental2.media;

import elemental2.core.ArrayBuffer;
import elemental2.dom.EventInit;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;
import jsinterop.base.JsPropertyMap;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public interface MediaEncryptedEventInit extends EventInit {
  @JsOverlay
  static MediaEncryptedEventInit create() {
    return Js.uncheckedCast(JsPropertyMap.of());
  }

  @JsProperty
  ArrayBuffer getInitData();

  @JsProperty
  String getInitDataType();

  @JsProperty
  void setInitData(ArrayBuffer initData);

  @JsProperty
  void setInitDataType(String initDataType);
}
