package elemental2.media;

import elemental2.core.Float32Array;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class AudioBuffer {
  public double duration;
  @Deprecated public AudioGain gain;
  public int length;
  public int numberOfChannels;
  public double sampleRate;

  public native Object copyFromChannel(
      Float32Array destination, int channelNumber, int startInChannel);

  public native Object copyFromChannel(Float32Array destination, int channelNumber);

  public native Object copyToChannel(Float32Array source, int channelNumber, int startInChannel);

  public native Object copyToChannel(Float32Array source, int channelNumber);

  public native Float32Array getChannelData(int channel);
}
