package elemental2.media;

import elemental2.core.Float32Array;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class AudioParam {
  public double defaultValue;
  @Deprecated public double maxValue;
  @Deprecated public double minValue;
  @Deprecated public double units;
  public double value;

  public native AudioParam cancelScheduledValues(double startTime);

  public native AudioParam exponentialRampToValueAtTime(double value, double endTime);

  public native AudioParam linearRampToValueAtTime(double value, double endTime);

  public native AudioParam setTargetAtTime(double target, double startTime, double timeConstant);

  @Deprecated
  public native AudioParam setTargetValueAtTime(
      double target, double startTime, double timeConstant);

  public native AudioParam setValueAtTime(double value, double startTime);

  public native AudioParam setValueCurveAtTime(
      Float32Array values, double startTime, double duration);
}
