package elemental2.media;

import elemental2.core.JsArray;
import elemental2.dom.Navigator;
import elemental2.promise.Promise;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;

@JsType(isNative = true, name = "Navigator", namespace = JsPackage.GLOBAL)
public class MediaNavigator extends Navigator {
  @JsOverlay
  public static MediaNavigator of(Navigator o) {
    return Js.cast(o);
  }

  public native Promise<MediaKeySystemAccess> requestMediaKeySystemAccess(
      String keySystem, JsArray<MediaKeySystemConfiguration> supportedConfigurations);

  @JsOverlay
  public final Promise<MediaKeySystemAccess> requestMediaKeySystemAccess(
      String keySystem, MediaKeySystemConfiguration[] supportedConfigurations) {
    return requestMediaKeySystemAccess(
        keySystem, Js.<JsArray<MediaKeySystemConfiguration>>uncheckedCast(supportedConfigurations));
  }
}
