package elemental2.svg;

import elemental2.dom.CSSValue;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class SVGMarkerElement extends SVGElement
    implements SVGExternalResourcesRequired, SVGFitToViewBox, SVGLangSpace, SVGStylable {
  @JsOverlay
  public static final double SVG_MARKERUNITS_STROKEWIDTH =
      SVGMarkerElement__Constants.SVG_MARKERUNITS_STROKEWIDTH;

  @JsOverlay
  public static final double SVG_MARKERUNITS_UNKNOWN =
      SVGMarkerElement__Constants.SVG_MARKERUNITS_UNKNOWN;

  @JsOverlay
  public static final double SVG_MARKERUNITS_USERSPACEONUSE =
      SVGMarkerElement__Constants.SVG_MARKERUNITS_USERSPACEONUSE;

  @JsOverlay
  public static final double SVG_MARKER_ORIENT_ANGLE =
      SVGMarkerElement__Constants.SVG_MARKER_ORIENT_ANGLE;

  @JsOverlay
  public static final double SVG_MARKER_ORIENT_AUTO =
      SVGMarkerElement__Constants.SVG_MARKER_ORIENT_AUTO;

  @JsOverlay
  public static final double SVG_MARKER_ORIENT_UNKNOWN =
      SVGMarkerElement__Constants.SVG_MARKER_ORIENT_UNKNOWN;

  public SVGAnimatedString className;
  public SVGAnimatedBoolean externalResourcesRequired;
  public SVGAnimatedLength markerHeight;
  public SVGAnimatedEnumeration markerUnits;
  public SVGAnimatedLength markerWidth;
  public SVGAnimatedAngle orientAngle;
  public SVGAnimatedEnumeration orientType;
  public SVGAnimatedPreserveAspectRatio preserveAspectRatio;
  public SVGAnimatedLength refX;
  public SVGAnimatedLength refY;
  public SVGStylable.GetStyleUnionType style;
  public SVGAnimatedRect viewBox;
  public String xmllang;
  public String xmlspace;

  @JsProperty
  public native SVGAnimatedString getClassName();

  @JsProperty
  public native SVGAnimatedBoolean getExternalResourcesRequired();

  public native CSSValue getPresentationAttribute();

  public native CSSValue getPresentationAttribute(String name);

  @JsProperty
  public native SVGAnimatedPreserveAspectRatio getPreserveAspectRatio();

  @JsProperty
  public native SVGStylable.GetStyleUnionType getStyle();

  @JsProperty
  public native SVGAnimatedRect getViewBox();

  @JsProperty
  public native String getXmllang();

  @JsProperty
  public native String getXmlspace();

  @JsProperty
  public native void setClassName(SVGAnimatedString className);

  @JsProperty
  public native void setExternalResourcesRequired(SVGAnimatedBoolean externalResourcesRequired);

  public native void setOrientToAngle();

  public native void setOrientToAngle(SVGAngle angle);

  public native Object setOrientToAuto();

  @JsProperty
  public native void setPreserveAspectRatio(SVGAnimatedPreserveAspectRatio preserveAspectRatio);

  @JsProperty
  public native void setStyle(SVGStylable.GetStyleUnionType style);

  @JsProperty
  public native void setViewBox(SVGAnimatedRect viewBox);

  @JsProperty
  public native void setXmllang(String xmllang);

  @JsProperty
  public native void setXmlspace(String xmlspace);
}
