package elemental2.svg;

import elemental2.dom.CSSValue;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class SVGDefsElement extends SVGElement
    implements SVGExternalResourcesRequired, SVGLangSpace, SVGStylable, SVGTests, SVGTransformable {
  public SVGAnimatedString className;
  public SVGAnimatedBoolean externalResourcesRequired;
  public SVGElement farthestViewportElement;
  public SVGElement nearestViewportElement;
  public SVGStringList requiredExtensions;
  public SVGStringList requiredFeatures;
  public SVGStringList systemLanguage;
  public SVGAnimatedTransformList transform;
  public String xmllang;
  public String xmlspace;

  public native SVGRect getBBox();

  public native SVGMatrix getCTM();

  @JsProperty
  public native SVGAnimatedString getClassName();

  @JsProperty
  public native SVGAnimatedBoolean getExternalResourcesRequired();

  @JsProperty
  public native SVGElement getFarthestViewportElement();

  @JsProperty
  public native SVGElement getNearestViewportElement();

  public native CSSValue getPresentationAttribute();

  public native CSSValue getPresentationAttribute(String name);

  @JsProperty
  public native SVGStringList getRequiredExtensions();

  @JsProperty
  public native SVGStringList getRequiredFeatures();

  public native SVGMatrix getScreenCTM();

  @JsProperty
  public native SVGStringList getSystemLanguage();

  @JsProperty
  public native SVGAnimatedTransformList getTransform();

  public native SVGMatrix getTransformToElement();

  public native SVGMatrix getTransformToElement(SVGElement element);

  @JsProperty
  public native String getXmllang();

  @JsProperty
  public native String getXmlspace();

  public native boolean hasExtension();

  public native boolean hasExtension(String extension);

  @JsProperty
  public native void setClassName(SVGAnimatedString className);

  @JsProperty
  public native void setExternalResourcesRequired(SVGAnimatedBoolean externalResourcesRequired);

  @JsProperty
  public native void setFarthestViewportElement(SVGElement farthestViewportElement);

  @JsProperty
  public native void setNearestViewportElement(SVGElement nearestViewportElement);

  @JsProperty
  public native void setRequiredExtensions(SVGStringList requiredExtensions);

  @JsProperty
  public native void setRequiredFeatures(SVGStringList requiredFeatures);

  @JsProperty
  public native void setSystemLanguage(SVGStringList systemLanguage);

  @JsProperty
  public native void setTransform(SVGAnimatedTransformList transform);

  @JsProperty
  public native void setXmllang(String xmllang);

  @JsProperty
  public native void setXmlspace(String xmlspace);
}
