package elemental2.svg;

import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class SVGViewElement extends SVGElement
    implements SVGExternalResourcesRequired, SVGFitToViewBox, SVGZoomAndPan {
  @JsOverlay
  public static final double SVG_ZOOMANDPAN_DISABLE =
      SVGViewElement__Constants.SVG_ZOOMANDPAN_DISABLE;

  @JsOverlay
  public static final double SVG_ZOOMANDPAN_MAGNIFY =
      SVGViewElement__Constants.SVG_ZOOMANDPAN_MAGNIFY;

  @JsOverlay
  public static final double SVG_ZOOMANDPAN_UNKNOWN =
      SVGViewElement__Constants.SVG_ZOOMANDPAN_UNKNOWN;

  public SVGAnimatedBoolean externalResourcesRequired;
  public SVGAnimatedPreserveAspectRatio preserveAspectRatio;
  public SVGAnimatedRect viewBox;
  public SVGStringList viewTarget;
  public double zoomAndPan;

  @JsProperty
  public native SVGAnimatedBoolean getExternalResourcesRequired();

  @JsProperty
  public native SVGAnimatedPreserveAspectRatio getPreserveAspectRatio();

  @JsProperty
  public native SVGAnimatedRect getViewBox();

  @JsProperty
  public native int getZoomAndPan();

  @JsProperty
  public native void setExternalResourcesRequired(SVGAnimatedBoolean externalResourcesRequired);

  @JsProperty
  public native void setPreserveAspectRatio(SVGAnimatedPreserveAspectRatio preserveAspectRatio);

  @JsProperty
  public native void setViewBox(SVGAnimatedRect viewBox);

  @JsProperty
  public native void setZoomAndPan(int zoomAndPan);
}
