package elemental2.svg;

import elemental2.dom.CSSValue;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class SVGFilterElement extends SVGElement
    implements SVGExternalResourcesRequired, SVGLangSpace, SVGStylable, SVGURIReference {
  public SVGAnimatedString className;
  public SVGAnimatedBoolean externalResourcesRequired;
  public SVGAnimatedInteger filterResX;
  public SVGAnimatedInteger filterResY;
  public SVGAnimatedEnumeration filterUnits;
  public SVGAnimatedLength height;
  public SVGAnimatedString href;
  public SVGAnimatedEnumeration primitiveUnits;
  public SVGAnimatedLength width;
  public SVGAnimatedLength x;
  public String xmllang;
  public String xmlspace;
  public SVGAnimatedLength y;

  @JsProperty
  public native SVGAnimatedString getClassName();

  @JsProperty
  public native SVGAnimatedBoolean getExternalResourcesRequired();

  @JsProperty
  public native SVGAnimatedString getHref();

  public native CSSValue getPresentationAttribute();

  public native CSSValue getPresentationAttribute(String name);

  @JsProperty
  public native String getXmllang();

  @JsProperty
  public native String getXmlspace();

  @JsProperty
  public native void setClassName(SVGAnimatedString className);

  @JsProperty
  public native void setExternalResourcesRequired(SVGAnimatedBoolean externalResourcesRequired);

  public native void setFilterRes();

  public native void setFilterRes(double filterResX, double filterResY);

  public native void setFilterRes(double filterResX);

  @JsProperty
  public native void setHref(SVGAnimatedString href);

  @JsProperty
  public native void setXmllang(String xmllang);

  @JsProperty
  public native void setXmlspace(String xmlspace);
}
