package elemental2.svg;

import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class SVGViewSpec implements SVGFitToViewBox, SVGZoomAndPan {
  @JsOverlay
  public static final double SVG_ZOOMANDPAN_DISABLE = SVGViewSpec__Constants.SVG_ZOOMANDPAN_DISABLE;

  @JsOverlay
  public static final double SVG_ZOOMANDPAN_MAGNIFY = SVGViewSpec__Constants.SVG_ZOOMANDPAN_MAGNIFY;

  @JsOverlay
  public static final double SVG_ZOOMANDPAN_UNKNOWN = SVGViewSpec__Constants.SVG_ZOOMANDPAN_UNKNOWN;

  public SVGAnimatedPreserveAspectRatio preserveAspectRatio;
  public String preserveAspectRatioString;
  public SVGTransformList transform;
  public String transformString;
  public SVGAnimatedRect viewBox;
  public String viewBoxString;
  public SVGElement viewTarget;
  public String viewTargetString;
  public double zoomAndPan;

  @JsProperty
  public native SVGAnimatedPreserveAspectRatio getPreserveAspectRatio();

  @JsProperty
  public native SVGAnimatedRect getViewBox();

  @JsProperty
  public native int getZoomAndPan();

  @JsProperty
  public native void setPreserveAspectRatio(SVGAnimatedPreserveAspectRatio preserveAspectRatio);

  @JsProperty
  public native void setViewBox(SVGAnimatedRect viewBox);

  @JsProperty
  public native void setZoomAndPan(int zoomAndPan);
}
