package elemental2.svg;

import elemental2.dom.CSSValue;
import elemental2.dom.Element;
import elemental2.dom.NodeList;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class SVGSVGElement extends SVGElement
    implements SVGExternalResourcesRequired,
        SVGFitToViewBox,
        SVGLangSpace,
        SVGLocatable,
        SVGStylable,
        SVGTests,
        SVGZoomAndPan {
  @JsOverlay
  public static final double SVG_ZOOMANDPAN_DISABLE =
      SVGSVGElement__Constants.SVG_ZOOMANDPAN_DISABLE;

  @JsOverlay
  public static final double SVG_ZOOMANDPAN_MAGNIFY =
      SVGSVGElement__Constants.SVG_ZOOMANDPAN_MAGNIFY;

  @JsOverlay
  public static final double SVG_ZOOMANDPAN_UNKNOWN =
      SVGSVGElement__Constants.SVG_ZOOMANDPAN_UNKNOWN;

  public String contentScriptType;
  public String contentStyleType;
  public double currentScale;
  public SVGPoint currentTranslate;
  public SVGAnimatedBoolean externalResourcesRequired;
  public SVGElement farthestViewportElement;
  public SVGAnimatedLength height;
  public SVGElement nearestViewportElement;
  public double pixelUnitToMillimeterX;
  public double pixelUnitToMillimeterY;
  public SVGAnimatedPreserveAspectRatio preserveAspectRatio;
  public SVGStringList requiredExtensions;
  public SVGStringList requiredFeatures;
  public double screenPixelToMillimeterX;
  public double screenPixelToMillimeterY;
  public SVGStringList systemLanguage;
  public boolean useCurrentView;
  public SVGAnimatedRect viewBox;
  public SVGRect viewport;
  public SVGAnimatedLength width;
  public SVGAnimatedLength x;
  public String xmllang;
  public String xmlspace;
  public SVGAnimatedLength y;
  public double zoomAndPan;

  public native boolean animationsPaused();

  public native boolean checkEnclosure();

  public native boolean checkEnclosure(SVGElement element, SVGRect rect);

  public native boolean checkEnclosure(SVGElement element);

  public native boolean checkIntersection();

  public native boolean checkIntersection(SVGElement element, SVGRect rect);

  public native boolean checkIntersection(SVGElement element);

  public native SVGAngle createSVGAngle();

  public native SVGLength createSVGLength();

  public native SVGMatrix createSVGMatrix();

  public native SVGNumber createSVGNumber();

  public native SVGPoint createSVGPoint();

  public native SVGRect createSVGRect();

  public native SVGTransform createSVGTransform();

  public native SVGTransform createSVGTransformFromMatrix();

  public native SVGTransform createSVGTransformFromMatrix(SVGMatrix matrix);

  public native Object deselectAll();

  public native Object forceRedraw();

  public native SVGRect getBBox();

  public native SVGMatrix getCTM();

  @JsProperty
  public native SVGAnimatedString getClassName();

  public native double getCurrentTime();

  public native Element getElementById();

  public native Element getElementById(String elementId);

  public native NodeList<Object> getEnclosureList();

  public native NodeList<Object> getEnclosureList(SVGRect rect, SVGElement referenceElement);

  public native NodeList<Object> getEnclosureList(SVGRect rect);

  @JsProperty
  public native SVGAnimatedBoolean getExternalResourcesRequired();

  @JsProperty
  public native SVGElement getFarthestViewportElement();

  public native NodeList<Object> getIntersectionList();

  public native NodeList<Object> getIntersectionList(SVGRect rect, SVGElement referenceElement);

  public native NodeList<Object> getIntersectionList(SVGRect rect);

  @JsProperty
  public native SVGElement getNearestViewportElement();

  public native CSSValue getPresentationAttribute();

  public native CSSValue getPresentationAttribute(String name);

  @JsProperty
  public native SVGAnimatedPreserveAspectRatio getPreserveAspectRatio();

  @JsProperty
  public native SVGStringList getRequiredExtensions();

  @JsProperty
  public native SVGStringList getRequiredFeatures();

  public native SVGMatrix getScreenCTM();

  @JsProperty
  public native SVGStringList getSystemLanguage();

  public native SVGMatrix getTransformToElement();

  public native SVGMatrix getTransformToElement(SVGElement element);

  @JsProperty
  public native SVGAnimatedRect getViewBox();

  @JsProperty
  public native String getXmllang();

  @JsProperty
  public native String getXmlspace();

  @JsProperty
  public native int getZoomAndPan();

  public native boolean hasExtension();

  public native boolean hasExtension(String extension);

  public native Object pauseAnimations();

  @JsProperty
  public native void setClassName(SVGAnimatedString className);

  public native void setCurrentTime();

  public native void setCurrentTime(double seconds);

  @JsProperty
  public native void setExternalResourcesRequired(SVGAnimatedBoolean externalResourcesRequired);

  @JsProperty
  public native void setFarthestViewportElement(SVGElement farthestViewportElement);

  @JsProperty
  public native void setNearestViewportElement(SVGElement nearestViewportElement);

  @JsProperty
  public native void setPreserveAspectRatio(SVGAnimatedPreserveAspectRatio preserveAspectRatio);

  @JsProperty
  public native void setRequiredExtensions(SVGStringList requiredExtensions);

  @JsProperty
  public native void setRequiredFeatures(SVGStringList requiredFeatures);

  @JsProperty
  public native void setSystemLanguage(SVGStringList systemLanguage);

  @JsProperty
  public native void setViewBox(SVGAnimatedRect viewBox);

  @JsProperty
  public native void setXmllang(String xmllang);

  @JsProperty
  public native void setXmlspace(String xmlspace);

  @JsProperty
  public native void setZoomAndPan(int zoomAndPan);

  public native int suspendRedraw();

  public native int suspendRedraw(int maxWaitMilliseconds);

  public native Object unpauseAnimations();

  public native void unsuspendRedraw();

  public native void unsuspendRedraw(int suspendHandleId);

  public native Object unsuspendRedrawAll();
}
