package elemental2.svg;

import elemental2.dom.CSSValue;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class SVGGradientElement extends SVGElement
    implements SVGExternalResourcesRequired, SVGStylable, SVGURIReference {
  @JsOverlay
  public static final double SVG_SPREADMETHOD_PAD =
      SVGGradientElement__Constants.SVG_SPREADMETHOD_PAD;

  @JsOverlay
  public static final double SVG_SPREADMETHOD_REFLECT =
      SVGGradientElement__Constants.SVG_SPREADMETHOD_REFLECT;

  @JsOverlay
  public static final double SVG_SPREADMETHOD_REPEAT =
      SVGGradientElement__Constants.SVG_SPREADMETHOD_REPEAT;

  @JsOverlay
  public static final double SVG_SPREADMETHOD_UNKNOWN =
      SVGGradientElement__Constants.SVG_SPREADMETHOD_UNKNOWN;

  public SVGAnimatedBoolean externalResourcesRequired;
  public SVGAnimatedTransformList gradientTransform;
  public SVGAnimatedEnumeration gradientUnits;
  public SVGAnimatedString href;
  public SVGAnimatedEnumeration spreadMethod;

  @JsProperty
  public native SVGAnimatedString getClassName();

  @JsProperty
  public native SVGAnimatedBoolean getExternalResourcesRequired();

  @JsProperty
  public native SVGAnimatedString getHref();

  public native CSSValue getPresentationAttribute();

  public native CSSValue getPresentationAttribute(String name);

  @JsProperty
  public native void setClassName(SVGAnimatedString className);

  @JsProperty
  public native void setExternalResourcesRequired(SVGAnimatedBoolean externalResourcesRequired);

  @JsProperty
  public native void setHref(SVGAnimatedString href);
}
