package elemental2.webassembly;

import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;
import jsinterop.base.JsPropertyMap;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public interface TableDescriptor {
  @JsOverlay
  static TableDescriptor create() {
    return Js.uncheckedCast(JsPropertyMap.of());
  }

  @JsProperty
  String getElement();

  @JsProperty
  int getInitial();

  @JsProperty
  int getMaximum();

  @JsProperty
  void setElement(String element);

  @JsProperty
  void setInitial(int initial);

  @JsProperty
  void setMaximum(int maximum);
}
