/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "uz" locale.
 */
public class LocalizedNamesImpl_uz extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "UZ",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "AX",
        "AL",
        "US",
        "AS",
        "AD",
        "AI",
        "AO",
        "AQ",
        "AG",
        "VI",
        "UM",
        "AR",
        "AM",
        "AW",
        "AU",
        "AT",
        "BS",
        "BH",
        "BD",
        "BB",
        "BY",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "AE",
        "UN",
        "BG",
        "BO",
        "BQ",
        "BA",
        "BW",
        "BR",
        "IO",
        "VG",
        "BN",
        "BF",
        "BI",
        "BT",
        "BV",
        "GB",
        "TD",
        "ME",
        "CZ",
        "CL",
        "DK",
        "DG",
        "DM",
        "DO",
        "ET",
        "EC",
        "GQ",
        "ER",
        "IR",
        "EE",
        "PS",
        "FO",
        "FJ",
        "PH",
        "FI",
        "FK",
        "FR",
        "GF",
        "TF",
        "PF",
        "GA",
        "HT",
        "GM",
        "GH",
        "GY",
        "DE",
        "GG",
        "GI",
        "HN",
        "HK",
        "GD",
        "GL",
        "GR",
        "GE",
        "GU",
        "GP",
        "GT",
        "GN",
        "GW",
        "EH",
        "IN",
        "ID",
        "JO",
        "IE",
        "IQ",
        "IS",
        "ES",
        "IL",
        "IT",
        "ZA",
        "GS",
        "KR",
        "SS",
        "DZ",
        "JE",
        "DJ",
        "CV",
        "KH",
        "CM",
        "CA",
        "IC",
        "KY",
        "KE",
        "CY",
        "KI",
        "CP",
        "CC",
        "CO",
        "KM",
        "CG",
        "CD",
        "XK",
        "CR",
        "CI",
        "CU",
        "CK",
        "CW",
        "LA",
        "LV",
        "LS",
        "LR",
        "LT",
        "LB",
        "LY",
        "LI",
        "LU",
        "MG",
        "MO",
        "MK",
        "MW",
        "MY",
        "MV",
        "ML",
        "MT",
        "CF",
        "MA",
        "MH",
        "MQ",
        "MU",
        "MR",
        "YT",
        "MX",
        "IM",
        "AC",
        "FM",
        "EG",
        "MD",
        "MC",
        "MN",
        "MS",
        "MZ",
        "SH",
        "MM",
        "NA",
        "NR",
        "NP",
        "NL",
        "NE",
        "NG",
        "NI",
        "NU",
        "NF",
        "NO",
        "AZ",
        "UZ",
        "PW",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PK",
        "PL",
        "PT",
        "PR",
        "QA",
        "KG",
        "KZ",
        "KW",
        "RE",
        "CX",
        "RU",
        "RW",
        "RO",
        "SV",
        "WS",
        "SM",
        "ST",
        "SA",
        "BL",
        "SN",
        "PM",
        "KN",
        "LC",
        "MF",
        "VC",
        "RS",
        "EA",
        "SC",
        "KP",
        "MP",
        "SJ",
        "LK",
        "SE",
        "CH",
        "SG",
        "SX",
        "SK",
        "SI",
        "SB",
        "SO",
        "SD",
        "SR",
        "SY",
        "SZ",
        "SL",
        "TH",
        "TZ",
        "QO",
        "TW",
        "TL",
        "TG",
        "TJ",
        "TK",
        "TO",
        "TT",
        "TA",
        "TN",
        "TR",
        "TM",
        "TC",
        "TV",
        "UG",
        "UA",
        "OM",
        "WF",
        "UY",
        "VU",
        "VA",
        "VE",
        "HU",
        "VN",
        "XA",
        "XB",
        "HM",
        "CN",
        "HR",
        "YE",
        "JM",
        "NC",
        "NZ",
        "JP",
        "EU",
        "EZ",
        "ZM",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Dunyo");
    namesMap.put("002", "Afrika");
    namesMap.put("003", "Shimoliy Amerika");
    namesMap.put("005", "Janubiy Amerika");
    namesMap.put("009", "Okeaniya");
    namesMap.put("011", "G‘arbiy Afrika");
    namesMap.put("013", "Markaziy Amerika");
    namesMap.put("014", "Sharqiy Afrika");
    namesMap.put("015", "Shimoliy Afrika");
    namesMap.put("017", "Markaziy Afrika");
    namesMap.put("018", "Janubiy Afrika");
    namesMap.put("019", "Amerika");
    namesMap.put("021", "Shimoliy Amerika – AQSH va Kanada");
    namesMap.put("029", "Karib havzasi");
    namesMap.put("030", "Sharqiy Osiyo");
    namesMap.put("034", "Janubiy Osiyo");
    namesMap.put("035", "Janubi-sharqiy Osiyo");
    namesMap.put("039", "Janubiy Yevropa");
    namesMap.put("053", "Avstralaziya");
    namesMap.put("054", "Melaneziya");
    namesMap.put("057", "Mikroneziya mintaqasi");
    namesMap.put("061", "Polineziya");
    namesMap.put("142", "Osiyo");
    namesMap.put("143", "Markaziy Osiyo");
    namesMap.put("145", "G‘arbiy Osiyo");
    namesMap.put("150", "Yevropa");
    namesMap.put("151", "Sharqiy Yevropa");
    namesMap.put("154", "Shimoliy Yevropa");
    namesMap.put("155", "G‘arbiy Yevropa");
    namesMap.put("202", "Sahro janubidagi Afrika");
    namesMap.put("419", "Lotin Amerikasi");
    namesMap.put("AC", "Me’roj oroli");
    namesMap.put("AE", "Birlashgan Arab Amirliklari");
    namesMap.put("AF", "Afgʻoniston");
    namesMap.put("AG", "Antigua va Barbuda");
    namesMap.put("AI", "Angilya");
    namesMap.put("AL", "Albaniya");
    namesMap.put("AM", "Armaniston");
    namesMap.put("AQ", "Antarktida");
    namesMap.put("AS", "Amerika Samoasi");
    namesMap.put("AT", "Avstriya");
    namesMap.put("AU", "Avstraliya");
    namesMap.put("AX", "Aland orollari");
    namesMap.put("AZ", "Ozarbayjon");
    namesMap.put("BA", "Bosniya va Gertsegovina");
    namesMap.put("BE", "Belgiya");
    namesMap.put("BF", "Burkina-Faso");
    namesMap.put("BG", "Bolgariya");
    namesMap.put("BH", "Bahrayn");
    namesMap.put("BL", "Sen-Bartelemi");
    namesMap.put("BM", "Bermuda orollari");
    namesMap.put("BN", "Bruney");
    namesMap.put("BO", "Boliviya");
    namesMap.put("BQ", "Boneyr, Sint-Estatius va Saba");
    namesMap.put("BR", "Braziliya");
    namesMap.put("BS", "Bagama orollari");
    namesMap.put("BT", "Butan");
    namesMap.put("BV", "Buve oroli");
    namesMap.put("BW", "Botsvana");
    namesMap.put("BZ", "Beliz");
    namesMap.put("CA", "Kanada");
    namesMap.put("CC", "Kokos (Kiling) orollari");
    namesMap.put("CD", "Kongo – Kinshasa");
    namesMap.put("CF", "Markaziy Afrika Respublikasi");
    namesMap.put("CG", "Kongo – Brazzavil");
    namesMap.put("CH", "Shveytsariya");
    namesMap.put("CI", "Kot-d’Ivuar");
    namesMap.put("CK", "Kuk orollari");
    namesMap.put("CL", "Chili");
    namesMap.put("CM", "Kamerun");
    namesMap.put("CN", "Xitoy");
    namesMap.put("CO", "Kolumbiya");
    namesMap.put("CP", "Klipperton oroli");
    namesMap.put("CR", "Kosta-Rika");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "Kabo-Verde");
    namesMap.put("CW", "Kyurasao");
    namesMap.put("CX", "Rojdestvo oroli");
    namesMap.put("CY", "Kipr");
    namesMap.put("CZ", "Chexiya");
    namesMap.put("DE", "Germaniya");
    namesMap.put("DG", "Diyego-Garsiya");
    namesMap.put("DJ", "Jibuti");
    namesMap.put("DK", "Daniya");
    namesMap.put("DM", "Dominika");
    namesMap.put("DO", "Dominikan Respublikasi");
    namesMap.put("DZ", "Jazoir");
    namesMap.put("EA", "Seuta va Melilya");
    namesMap.put("EC", "Ekvador");
    namesMap.put("EE", "Estoniya");
    namesMap.put("EG", "Misr");
    namesMap.put("EH", "G‘arbiy Sahroi Kabir");
    namesMap.put("ER", "Eritreya");
    namesMap.put("ES", "Ispaniya");
    namesMap.put("ET", "Efiopiya");
    namesMap.put("EU", "Yevropa Ittifoqi");
    namesMap.put("EZ", "yevrozona");
    namesMap.put("FI", "Finlandiya");
    namesMap.put("FK", "Folklend orollari");
    namesMap.put("FM", "Mikroneziya");
    namesMap.put("FO", "Farer orollari");
    namesMap.put("FR", "Fransiya");
    namesMap.put("GB", "Buyuk Britaniya");
    namesMap.put("GE", "Gruziya");
    namesMap.put("GF", "Fransuz Gvianasi");
    namesMap.put("GG", "Gernsi");
    namesMap.put("GH", "Gana");
    namesMap.put("GL", "Grenlandiya");
    namesMap.put("GM", "Gambiya");
    namesMap.put("GN", "Gvineya");
    namesMap.put("GP", "Gvadelupe");
    namesMap.put("GQ", "Ekvatorial Gvineya");
    namesMap.put("GR", "Gretsiya");
    namesMap.put("GS", "Janubiy Georgiya va Janubiy Sendvich orollari");
    namesMap.put("GT", "Gvatemala");
    namesMap.put("GW", "Gvineya-Bisau");
    namesMap.put("GY", "Gayana");
    namesMap.put("HK", "Gonkong (Xitoy MMH)");
    namesMap.put("HM", "Xerd va Makdonald orollari");
    namesMap.put("HN", "Gonduras");
    namesMap.put("HR", "Xorvatiya");
    namesMap.put("HT", "Gaiti");
    namesMap.put("HU", "Vengriya");
    namesMap.put("IC", "Kanar orollari");
    namesMap.put("ID", "Indoneziya");
    namesMap.put("IE", "Irlandiya");
    namesMap.put("IL", "Isroil");
    namesMap.put("IM", "Men oroli");
    namesMap.put("IN", "Hindiston");
    namesMap.put("IO", "Britaniyaning Hind okeanidagi hududi");
    namesMap.put("IQ", "Iroq");
    namesMap.put("IR", "Eron");
    namesMap.put("IS", "Islandiya");
    namesMap.put("IT", "Italiya");
    namesMap.put("JE", "Jersi");
    namesMap.put("JM", "Yamayka");
    namesMap.put("JO", "Iordaniya");
    namesMap.put("JP", "Yaponiya");
    namesMap.put("KE", "Keniya");
    namesMap.put("KG", "Qirgʻiziston");
    namesMap.put("KH", "Kambodja");
    namesMap.put("KM", "Komor orollari");
    namesMap.put("KN", "Sent-Kits va Nevis");
    namesMap.put("KP", "Shimoliy Koreya");
    namesMap.put("KR", "Janubiy Koreya");
    namesMap.put("KW", "Quvayt");
    namesMap.put("KY", "Kayman orollari");
    namesMap.put("KZ", "Qozogʻiston");
    namesMap.put("LB", "Livan");
    namesMap.put("LC", "Sent-Lyusiya");
    namesMap.put("LI", "Lixtenshteyn");
    namesMap.put("LK", "Shri-Lanka");
    namesMap.put("LR", "Liberiya");
    namesMap.put("LS", "Lesoto");
    namesMap.put("LT", "Litva");
    namesMap.put("LU", "Lyuksemburg");
    namesMap.put("LV", "Latviya");
    namesMap.put("LY", "Liviya");
    namesMap.put("MA", "Marokash");
    namesMap.put("MC", "Monako");
    namesMap.put("ME", "Chernogoriya");
    namesMap.put("MF", "Sent-Martin");
    namesMap.put("MG", "Madagaskar");
    namesMap.put("MH", "Marshall orollari");
    namesMap.put("MK", "Makedoniya");
    namesMap.put("MM", "Myanma (Birma)");
    namesMap.put("MN", "Mongoliya");
    namesMap.put("MO", "Makao (Xitoy MMH)");
    namesMap.put("MP", "Shimoliy Mariana orollari");
    namesMap.put("MQ", "Martinika");
    namesMap.put("MR", "Mavritaniya");
    namesMap.put("MU", "Mavrikiy");
    namesMap.put("MV", "Maldiv orollari");
    namesMap.put("MW", "Malavi");
    namesMap.put("MX", "Meksika");
    namesMap.put("MY", "Malayziya");
    namesMap.put("MZ", "Mozambik");
    namesMap.put("NA", "Namibiya");
    namesMap.put("NC", "Yangi Kaledoniya");
    namesMap.put("NF", "Norfolk oroli");
    namesMap.put("NG", "Nigeriya");
    namesMap.put("NI", "Nikaragua");
    namesMap.put("NL", "Niderlandiya");
    namesMap.put("NO", "Norvegiya");
    namesMap.put("NZ", "Yangi Zelandiya");
    namesMap.put("OM", "Ummon");
    namesMap.put("PF", "Fransuz Polineziyasi");
    namesMap.put("PG", "Papua – Yangi Gvineya");
    namesMap.put("PH", "Filippin");
    namesMap.put("PK", "Pokiston");
    namesMap.put("PL", "Polsha");
    namesMap.put("PM", "Sen-Pyer va Mikelon");
    namesMap.put("PN", "Pitkern orollari");
    namesMap.put("PR", "Puerto-Riko");
    namesMap.put("PS", "Falastin hududlari");
    namesMap.put("PT", "Portugaliya");
    namesMap.put("PY", "Paragvay");
    namesMap.put("QO", "Tashqi Okeaniya");
    namesMap.put("RE", "Reyunion");
    namesMap.put("RO", "Ruminiya");
    namesMap.put("RS", "Serbiya");
    namesMap.put("RU", "Rossiya");
    namesMap.put("RW", "Ruanda");
    namesMap.put("SA", "Saudiya Arabistoni");
    namesMap.put("SB", "Solomon orollari");
    namesMap.put("SC", "Seyshel orollari");
    namesMap.put("SE", "Shvetsiya");
    namesMap.put("SG", "Singapur");
    namesMap.put("SH", "Muqaddas Yelena oroli");
    namesMap.put("SI", "Sloveniya");
    namesMap.put("SJ", "Shpitsbergen va Yan-Mayen");
    namesMap.put("SK", "Slovakiya");
    namesMap.put("SL", "Syerra-Leone");
    namesMap.put("SM", "San-Marino");
    namesMap.put("SO", "Somali");
    namesMap.put("SR", "Surinam");
    namesMap.put("SS", "Janubiy Sudan");
    namesMap.put("ST", "San-Tome va Prinsipi");
    namesMap.put("SV", "Salvador");
    namesMap.put("SX", "Sint-Marten");
    namesMap.put("SY", "Suriya");
    namesMap.put("SZ", "Svazilend");
    namesMap.put("TA", "Tristan-da-Kunya");
    namesMap.put("TC", "Turks va Kaykos orollari");
    namesMap.put("TF", "Fransuz Janubiy hududlari");
    namesMap.put("TH", "Tailand");
    namesMap.put("TJ", "Tojikiston");
    namesMap.put("TM", "Turkmaniston");
    namesMap.put("TN", "Tunis");
    namesMap.put("TR", "Turkiya");
    namesMap.put("TT", "Trinidad va Tobago");
    namesMap.put("TW", "Tayvan");
    namesMap.put("TZ", "Tanzaniya");
    namesMap.put("UA", "Ukraina");
    namesMap.put("UM", "AQSH yondosh orollari");
    namesMap.put("UN", "Birlashgan Millatlar Tashkiloti");
    namesMap.put("US", "Amerika Qo‘shma Shtatlari");
    namesMap.put("UY", "Urugvay");
    namesMap.put("UZ", "Oʻzbekiston");
    namesMap.put("VA", "Vatikan");
    namesMap.put("VC", "Sent-Vinsent va Grenadin");
    namesMap.put("VE", "Venesuela");
    namesMap.put("VG", "Britaniya Virgin orollari");
    namesMap.put("VI", "AQSH Virgin orollari");
    namesMap.put("VN", "Vyetnam");
    namesMap.put("WF", "Uollis va Futuna");
    namesMap.put("YE", "Yaman");
    namesMap.put("YT", "Mayotta");
    namesMap.put("ZA", "Janubiy Afrika Respublikasi");
    namesMap.put("ZM", "Zambiya");
    namesMap.put("ZW", "Zimbabve");
    namesMap.put("ZZ", "Noma’lum mintaqa");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Dunyo",
        "002": "Afrika",
        "003": "Shimoliy Amerika",
        "005": "Janubiy Amerika",
        "009": "Okeaniya",
        "011": "G‘arbiy Afrika",
        "013": "Markaziy Amerika",
        "014": "Sharqiy Afrika",
        "015": "Shimoliy Afrika",
        "017": "Markaziy Afrika",
        "018": "Janubiy Afrika",
        "019": "Amerika",
        "021": "Shimoliy Amerika – AQSH va Kanada",
        "029": "Karib havzasi",
        "030": "Sharqiy Osiyo",
        "034": "Janubiy Osiyo",
        "035": "Janubi-sharqiy Osiyo",
        "039": "Janubiy Yevropa",
        "053": "Avstralaziya",
        "054": "Melaneziya",
        "057": "Mikroneziya mintaqasi",
        "061": "Polineziya",
        "142": "Osiyo",
        "143": "Markaziy Osiyo",
        "145": "G‘arbiy Osiyo",
        "150": "Yevropa",
        "151": "Sharqiy Yevropa",
        "154": "Shimoliy Yevropa",
        "155": "G‘arbiy Yevropa",
        "202": "Sahro janubidagi Afrika",
        "419": "Lotin Amerikasi",
        "AC": "Me’roj oroli",
        "AE": "Birlashgan Arab Amirliklari",
        "AF": "Afgʻoniston",
        "AG": "Antigua va Barbuda",
        "AI": "Angilya",
        "AL": "Albaniya",
        "AM": "Armaniston",
        "AQ": "Antarktida",
        "AS": "Amerika Samoasi",
        "AT": "Avstriya",
        "AU": "Avstraliya",
        "AX": "Aland orollari",
        "AZ": "Ozarbayjon",
        "BA": "Bosniya va Gertsegovina",
        "BE": "Belgiya",
        "BF": "Burkina-Faso",
        "BG": "Bolgariya",
        "BH": "Bahrayn",
        "BL": "Sen-Bartelemi",
        "BM": "Bermuda orollari",
        "BN": "Bruney",
        "BO": "Boliviya",
        "BQ": "Boneyr, Sint-Estatius va Saba",
        "BR": "Braziliya",
        "BS": "Bagama orollari",
        "BT": "Butan",
        "BV": "Buve oroli",
        "BW": "Botsvana",
        "BZ": "Beliz",
        "CA": "Kanada",
        "CC": "Kokos (Kiling) orollari",
        "CD": "Kongo – Kinshasa",
        "CF": "Markaziy Afrika Respublikasi",
        "CG": "Kongo – Brazzavil",
        "CH": "Shveytsariya",
        "CI": "Kot-d’Ivuar",
        "CK": "Kuk orollari",
        "CL": "Chili",
        "CM": "Kamerun",
        "CN": "Xitoy",
        "CO": "Kolumbiya",
        "CP": "Klipperton oroli",
        "CR": "Kosta-Rika",
        "CU": "Kuba",
        "CV": "Kabo-Verde",
        "CW": "Kyurasao",
        "CX": "Rojdestvo oroli",
        "CY": "Kipr",
        "CZ": "Chexiya",
        "DE": "Germaniya",
        "DG": "Diyego-Garsiya",
        "DJ": "Jibuti",
        "DK": "Daniya",
        "DM": "Dominika",
        "DO": "Dominikan Respublikasi",
        "DZ": "Jazoir",
        "EA": "Seuta va Melilya",
        "EC": "Ekvador",
        "EE": "Estoniya",
        "EG": "Misr",
        "EH": "G‘arbiy Sahroi Kabir",
        "ER": "Eritreya",
        "ES": "Ispaniya",
        "ET": "Efiopiya",
        "EU": "Yevropa Ittifoqi",
        "EZ": "yevrozona",
        "FI": "Finlandiya",
        "FK": "Folklend orollari",
        "FM": "Mikroneziya",
        "FO": "Farer orollari",
        "FR": "Fransiya",
        "GB": "Buyuk Britaniya",
        "GE": "Gruziya",
        "GF": "Fransuz Gvianasi",
        "GG": "Gernsi",
        "GH": "Gana",
        "GL": "Grenlandiya",
        "GM": "Gambiya",
        "GN": "Gvineya",
        "GP": "Gvadelupe",
        "GQ": "Ekvatorial Gvineya",
        "GR": "Gretsiya",
        "GS": "Janubiy Georgiya va Janubiy Sendvich orollari",
        "GT": "Gvatemala",
        "GW": "Gvineya-Bisau",
        "GY": "Gayana",
        "HK": "Gonkong (Xitoy MMH)",
        "HM": "Xerd va Makdonald orollari",
        "HN": "Gonduras",
        "HR": "Xorvatiya",
        "HT": "Gaiti",
        "HU": "Vengriya",
        "IC": "Kanar orollari",
        "ID": "Indoneziya",
        "IE": "Irlandiya",
        "IL": "Isroil",
        "IM": "Men oroli",
        "IN": "Hindiston",
        "IO": "Britaniyaning Hind okeanidagi hududi",
        "IQ": "Iroq",
        "IR": "Eron",
        "IS": "Islandiya",
        "IT": "Italiya",
        "JE": "Jersi",
        "JM": "Yamayka",
        "JO": "Iordaniya",
        "JP": "Yaponiya",
        "KE": "Keniya",
        "KG": "Qirgʻiziston",
        "KH": "Kambodja",
        "KM": "Komor orollari",
        "KN": "Sent-Kits va Nevis",
        "KP": "Shimoliy Koreya",
        "KR": "Janubiy Koreya",
        "KW": "Quvayt",
        "KY": "Kayman orollari",
        "KZ": "Qozogʻiston",
        "LB": "Livan",
        "LC": "Sent-Lyusiya",
        "LI": "Lixtenshteyn",
        "LK": "Shri-Lanka",
        "LR": "Liberiya",
        "LS": "Lesoto",
        "LT": "Litva",
        "LU": "Lyuksemburg",
        "LV": "Latviya",
        "LY": "Liviya",
        "MA": "Marokash",
        "MC": "Monako",
        "ME": "Chernogoriya",
        "MF": "Sent-Martin",
        "MG": "Madagaskar",
        "MH": "Marshall orollari",
        "MK": "Makedoniya",
        "MM": "Myanma (Birma)",
        "MN": "Mongoliya",
        "MO": "Makao (Xitoy MMH)",
        "MP": "Shimoliy Mariana orollari",
        "MQ": "Martinika",
        "MR": "Mavritaniya",
        "MU": "Mavrikiy",
        "MV": "Maldiv orollari",
        "MW": "Malavi",
        "MX": "Meksika",
        "MY": "Malayziya",
        "MZ": "Mozambik",
        "NA": "Namibiya",
        "NC": "Yangi Kaledoniya",
        "NF": "Norfolk oroli",
        "NG": "Nigeriya",
        "NI": "Nikaragua",
        "NL": "Niderlandiya",
        "NO": "Norvegiya",
        "NZ": "Yangi Zelandiya",
        "OM": "Ummon",
        "PF": "Fransuz Polineziyasi",
        "PG": "Papua – Yangi Gvineya",
        "PH": "Filippin",
        "PK": "Pokiston",
        "PL": "Polsha",
        "PM": "Sen-Pyer va Mikelon",
        "PN": "Pitkern orollari",
        "PR": "Puerto-Riko",
        "PS": "Falastin hududlari",
        "PT": "Portugaliya",
        "PY": "Paragvay",
        "QO": "Tashqi Okeaniya",
        "RE": "Reyunion",
        "RO": "Ruminiya",
        "RS": "Serbiya",
        "RU": "Rossiya",
        "RW": "Ruanda",
        "SA": "Saudiya Arabistoni",
        "SB": "Solomon orollari",
        "SC": "Seyshel orollari",
        "SE": "Shvetsiya",
        "SG": "Singapur",
        "SH": "Muqaddas Yelena oroli",
        "SI": "Sloveniya",
        "SJ": "Shpitsbergen va Yan-Mayen",
        "SK": "Slovakiya",
        "SL": "Syerra-Leone",
        "SM": "San-Marino",
        "SO": "Somali",
        "SR": "Surinam",
        "SS": "Janubiy Sudan",
        "ST": "San-Tome va Prinsipi",
        "SV": "Salvador",
        "SX": "Sint-Marten",
        "SY": "Suriya",
        "SZ": "Svazilend",
        "TA": "Tristan-da-Kunya",
        "TC": "Turks va Kaykos orollari",
        "TF": "Fransuz Janubiy hududlari",
        "TH": "Tailand",
        "TJ": "Tojikiston",
        "TM": "Turkmaniston",
        "TN": "Tunis",
        "TR": "Turkiya",
        "TT": "Trinidad va Tobago",
        "TW": "Tayvan",
        "TZ": "Tanzaniya",
        "UA": "Ukraina",
        "UM": "AQSH yondosh orollari",
        "UN": "Birlashgan Millatlar Tashkiloti",
        "US": "Amerika Qo‘shma Shtatlari",
        "UY": "Urugvay",
        "UZ": "Oʻzbekiston",
        "VA": "Vatikan",
        "VC": "Sent-Vinsent va Grenadin",
        "VE": "Venesuela",
        "VG": "Britaniya Virgin orollari",
        "VI": "AQSH Virgin orollari",
        "VN": "Vyetnam",
        "WF": "Uollis va Futuna",
        "YE": "Yaman",
        "YT": "Mayotta",
        "ZA": "Janubiy Afrika Respublikasi",
        "ZM": "Zambiya",
        "ZW": "Zimbabve",
        "ZZ": "Noma’lum mintaqa"
    };
  }-*/;
}
