/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "uk" locale.
 */
public class LocalizedNamesImpl_uk extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "UA",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "XA",
        "XB",
        "AU",
        "AT",
        "AZ",
        "AX",
        "AL",
        "DZ",
        "AS",
        "AI",
        "AO",
        "AD",
        "AQ",
        "AG",
        "AR",
        "AW",
        "AF",
        "BS",
        "BD",
        "BB",
        "BH",
        "BZ",
        "BE",
        "BJ",
        "BM",
        "BY",
        "BG",
        "BO",
        "BA",
        "BW",
        "BR",
        "IO",
        "VG",
        "BN",
        "BF",
        "BI",
        "BT",
        "VU",
        "VA",
        "GB",
        "VE",
        "QO",
        "UM",
        "VI",
        "AM",
        "VN",
        "GA",
        "HT",
        "GY",
        "GM",
        "GH",
        "GP",
        "GT",
        "GN",
        "GW",
        "GG",
        "GI",
        "HN",
        "HK",
        "GD",
        "GL",
        "GR",
        "GE",
        "GU",
        "DK",
        "JE",
        "DJ",
        "DG",
        "DM",
        "DO",
        "EC",
        "GQ",
        "ER",
        "EE",
        "ET",
        "EZ",
        "EU",
        "EG",
        "YE",
        "ZM",
        "EH",
        "ZW",
        "IL",
        "IN",
        "ID",
        "IQ",
        "IR",
        "IE",
        "IS",
        "ES",
        "IT",
        "JO",
        "CV",
        "KZ",
        "KY",
        "KH",
        "CM",
        "CA",
        "IC",
        "QA",
        "KE",
        "KG",
        "CN",
        "CY",
        "KI",
        "CC",
        "CO",
        "KM",
        "CG",
        "CD",
        "XK",
        "CR",
        "CI",
        "CU",
        "KW",
        "CW",
        "LA",
        "LV",
        "LS",
        "LT",
        "LR",
        "LB",
        "LY",
        "LI",
        "LU",
        "MR",
        "MU",
        "MG",
        "YT",
        "MO",
        "MK",
        "MW",
        "MY",
        "ML",
        "MV",
        "MT",
        "MA",
        "MQ",
        "MH",
        "MX",
        "FM",
        "MZ",
        "MD",
        "MC",
        "MN",
        "MS",
        "MM",
        "NA",
        "NR",
        "NP",
        "NE",
        "NG",
        "NL",
        "BQ",
        "NI",
        "DE",
        "NU",
        "NZ",
        "NC",
        "NO",
        "AE",
        "OM",
        "UN",
        "BV",
        "AC",
        "CP",
        "IM",
        "NF",
        "CX",
        "SH",
        "HM",
        "CK",
        "PN",
        "TC",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "GS",
        "KR",
        "SS",
        "ZA",
        "KP",
        "MP",
        "PL",
        "PT",
        "PR",
        "RE",
        "RU",
        "RW",
        "RO",
        "SV",
        "WS",
        "SM",
        "ST",
        "SA",
        "SZ",
        "SC",
        "BL",
        "SN",
        "MF",
        "PM",
        "VC",
        "KN",
        "LC",
        "RS",
        "EA",
        "SY",
        "SG",
        "SX",
        "SK",
        "SI",
        "SB",
        "SO",
        "US",
        "SD",
        "SR",
        "SL",
        "TJ",
        "TH",
        "TW",
        "TZ",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TV",
        "TN",
        "TR",
        "TM",
        "UG",
        "HU",
        "UZ",
        "UA",
        "WF",
        "UY",
        "FO",
        "FJ",
        "PH",
        "FI",
        "FK",
        "FR",
        "GF",
        "PF",
        "TF",
        "HR",
        "CF",
        "TD",
        "CZ",
        "CL",
        "ME",
        "CH",
        "SE",
        "SJ",
        "LK",
        "JM",
        "JP",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Світ");
    namesMap.put("002", "Африка");
    namesMap.put("003", "Північна Америка");
    namesMap.put("005", "Південна Америка");
    namesMap.put("009", "Океанія");
    namesMap.put("011", "Західна Африка");
    namesMap.put("013", "Центральна Америка");
    namesMap.put("014", "Східна Африка");
    namesMap.put("015", "Північна Африка");
    namesMap.put("017", "Центральна Африка");
    namesMap.put("018", "Південний регіон Африки");
    namesMap.put("019", "Америка");
    namesMap.put("021", "Північна Америка (регіон)");
    namesMap.put("029", "Карибський басейн");
    namesMap.put("030", "Східна Азія");
    namesMap.put("034", "Південна Азія");
    namesMap.put("035", "Південно-Східна Азія");
    namesMap.put("039", "Південна Європа");
    namesMap.put("053", "Австралазія");
    namesMap.put("054", "Меланезія");
    namesMap.put("057", "Мікронезійський регіон");
    namesMap.put("061", "Полінезія");
    namesMap.put("142", "Азія");
    namesMap.put("143", "Центральна Азія");
    namesMap.put("145", "Західна Азія");
    namesMap.put("150", "Європа");
    namesMap.put("151", "Східна Європа");
    namesMap.put("154", "Північна Європа");
    namesMap.put("155", "Західна Європа");
    namesMap.put("202", "Африка на південь від Сахари");
    namesMap.put("419", "Латинська Америка");
    namesMap.put("AC", "Острів Вознесіння");
    namesMap.put("AD", "Андорра");
    namesMap.put("AE", "Обʼєднані Арабські Емірати");
    namesMap.put("AF", "Афганістан");
    namesMap.put("AG", "Антиґуа і Барбуда");
    namesMap.put("AI", "Анґілья");
    namesMap.put("AL", "Албанія");
    namesMap.put("AM", "Вірменія");
    namesMap.put("AO", "Ангола");
    namesMap.put("AQ", "Антарктика");
    namesMap.put("AR", "Аргентина");
    namesMap.put("AS", "Американське Самоа");
    namesMap.put("AT", "Австрія");
    namesMap.put("AU", "Австралія");
    namesMap.put("AW", "Аруба");
    namesMap.put("AX", "Аландські Острови");
    namesMap.put("AZ", "Азербайджан");
    namesMap.put("BA", "Боснія і Герцеґовина");
    namesMap.put("BB", "Барбадос");
    namesMap.put("BD", "Бангладеш");
    namesMap.put("BE", "Бельґія");
    namesMap.put("BF", "Буркіна-Фасо");
    namesMap.put("BG", "Болгарія");
    namesMap.put("BH", "Бахрейн");
    namesMap.put("BI", "Бурунді");
    namesMap.put("BJ", "Бенін");
    namesMap.put("BL", "Сен-Бартельмі");
    namesMap.put("BM", "Бермудські Острови");
    namesMap.put("BN", "Бруней");
    namesMap.put("BO", "Болівія");
    namesMap.put("BQ", "Нідерландські Карибські острови");
    namesMap.put("BR", "Бразілія");
    namesMap.put("BS", "Багамські Острови");
    namesMap.put("BT", "Бутан");
    namesMap.put("BV", "Острів Буве");
    namesMap.put("BW", "Ботсвана");
    namesMap.put("BY", "Білорусь");
    namesMap.put("BZ", "Беліз");
    namesMap.put("CA", "Канада");
    namesMap.put("CC", "Кокосові (Кілінґ) Острови");
    namesMap.put("CD", "Конго – Кіншаса");
    namesMap.put("CF", "Центральноафриканська Республіка");
    namesMap.put("CG", "Конго – Браззавіль");
    namesMap.put("CH", "Швейцарія");
    namesMap.put("CI", "Кот-дʼІвуар");
    namesMap.put("CK", "Острови Кука");
    namesMap.put("CL", "Чілі");
    namesMap.put("CM", "Камерун");
    namesMap.put("CN", "Китай");
    namesMap.put("CO", "Колумбія");
    namesMap.put("CP", "Острів Кліппертон");
    namesMap.put("CR", "Коста-Ріка");
    namesMap.put("CU", "Куба");
    namesMap.put("CV", "Кабо-Верде");
    namesMap.put("CW", "Кюрасао");
    namesMap.put("CX", "Острів Різдва");
    namesMap.put("CY", "Кіпр");
    namesMap.put("CZ", "Чехія");
    namesMap.put("DE", "Німеччина");
    namesMap.put("DG", "Дієго-Гарсія");
    namesMap.put("DJ", "Джибуті");
    namesMap.put("DK", "Данія");
    namesMap.put("DM", "Домініка");
    namesMap.put("DO", "Домініканська Республіка");
    namesMap.put("DZ", "Алжир");
    namesMap.put("EA", "Сеута і Мелілья");
    namesMap.put("EC", "Еквадор");
    namesMap.put("EE", "Естонія");
    namesMap.put("EG", "Єгипет");
    namesMap.put("EH", "Західна Сахара");
    namesMap.put("ER", "Еритрея");
    namesMap.put("ES", "Іспанія");
    namesMap.put("ET", "Ефіопія");
    namesMap.put("EU", "Європейський Союз");
    namesMap.put("EZ", "Єврозона");
    namesMap.put("FI", "Фінляндія");
    namesMap.put("FJ", "Фіджі");
    namesMap.put("FK", "Фолклендські Острови");
    namesMap.put("FM", "Мікронезія");
    namesMap.put("FO", "Фарерські Острови");
    namesMap.put("FR", "Франція");
    namesMap.put("GA", "Габон");
    namesMap.put("GB", "Велика Британія");
    namesMap.put("GD", "Ґренада");
    namesMap.put("GE", "Грузія");
    namesMap.put("GF", "Французька Ґвіана");
    namesMap.put("GG", "Ґернсі");
    namesMap.put("GH", "Гана");
    namesMap.put("GI", "Ґібралтар");
    namesMap.put("GL", "Ґренландія");
    namesMap.put("GM", "Гамбія");
    namesMap.put("GN", "Гвінея");
    namesMap.put("GP", "Ґваделупа");
    namesMap.put("GQ", "Екваторіальна Гвінея");
    namesMap.put("GR", "Греція");
    namesMap.put("GS", "Південна Джорджія та Південні Сандвічеві Острови");
    namesMap.put("GT", "Ґватемала");
    namesMap.put("GU", "Ґуам");
    namesMap.put("GW", "Гвінея-Бісау");
    namesMap.put("GY", "Ґайана");
    namesMap.put("HK", "Гонконг, О.А.Р. Китаю");
    namesMap.put("HM", "Острови Герд і Макдоналд");
    namesMap.put("HN", "Гондурас");
    namesMap.put("HR", "Хорватія");
    namesMap.put("HT", "Гаїті");
    namesMap.put("HU", "Угорщина");
    namesMap.put("IC", "Канарські Острови");
    namesMap.put("ID", "Індонезія");
    namesMap.put("IE", "Ірландія");
    namesMap.put("IL", "Ізраїль");
    namesMap.put("IM", "Острів Мен");
    namesMap.put("IN", "Індія");
    namesMap.put("IO", "Британська територія в Індійському Океані");
    namesMap.put("IQ", "Ірак");
    namesMap.put("IR", "Іран");
    namesMap.put("IS", "Ісландія");
    namesMap.put("IT", "Італія");
    namesMap.put("JE", "Джерсі");
    namesMap.put("JM", "Ямайка");
    namesMap.put("JO", "Йорданія");
    namesMap.put("JP", "Японія");
    namesMap.put("KE", "Кенія");
    namesMap.put("KG", "Киргизстан");
    namesMap.put("KH", "Камбоджа");
    namesMap.put("KI", "Кірібаті");
    namesMap.put("KM", "Комори");
    namesMap.put("KN", "Сент-Кітс і Невіс");
    namesMap.put("KP", "Північна Корея");
    namesMap.put("KR", "Південна Корея");
    namesMap.put("KW", "Кувейт");
    namesMap.put("KY", "Кайманові Острови");
    namesMap.put("KZ", "Казахстан");
    namesMap.put("LA", "Лаос");
    namesMap.put("LB", "Ліван");
    namesMap.put("LC", "Сент-Люсія");
    namesMap.put("LI", "Ліхтенштейн");
    namesMap.put("LK", "Шрі-Ланка");
    namesMap.put("LR", "Ліберія");
    namesMap.put("LS", "Лесото");
    namesMap.put("LT", "Литва");
    namesMap.put("LU", "Люксембурґ");
    namesMap.put("LV", "Латвія");
    namesMap.put("LY", "Лівія");
    namesMap.put("MA", "Марокко");
    namesMap.put("MC", "Монако");
    namesMap.put("MD", "Молдова");
    namesMap.put("ME", "Чорногорія");
    namesMap.put("MF", "Сен-Мартен");
    namesMap.put("MG", "Мадагаскар");
    namesMap.put("MH", "Маршаллові Острови");
    namesMap.put("MK", "Македонія");
    namesMap.put("ML", "Малі");
    namesMap.put("MM", "Мʼянма (Бірма)");
    namesMap.put("MN", "Монголія");
    namesMap.put("MO", "Макао, О.А.Р Китаю");
    namesMap.put("MP", "Північні Маріанські Острови");
    namesMap.put("MQ", "Мартініка");
    namesMap.put("MR", "Мавританія");
    namesMap.put("MS", "Монтсеррат");
    namesMap.put("MT", "Мальта");
    namesMap.put("MU", "Маврікій");
    namesMap.put("MV", "Мальдіви");
    namesMap.put("MW", "Малаві");
    namesMap.put("MX", "Мексика");
    namesMap.put("MY", "Малайзія");
    namesMap.put("MZ", "Мозамбік");
    namesMap.put("NA", "Намібія");
    namesMap.put("NC", "Нова Каледонія");
    namesMap.put("NE", "Нігер");
    namesMap.put("NF", "Острів Норфолк");
    namesMap.put("NG", "Нігерія");
    namesMap.put("NI", "Нікараґуа");
    namesMap.put("NL", "Нідерланди");
    namesMap.put("NO", "Норвеґія");
    namesMap.put("NP", "Непал");
    namesMap.put("NR", "Науру");
    namesMap.put("NU", "Ніуе");
    namesMap.put("NZ", "Нова Зеландія");
    namesMap.put("OM", "Оман");
    namesMap.put("PA", "Панама");
    namesMap.put("PE", "Перу");
    namesMap.put("PF", "Французька Полінезія");
    namesMap.put("PG", "Папуа-Нова Ґвінея");
    namesMap.put("PH", "Філіппіни");
    namesMap.put("PK", "Пакистан");
    namesMap.put("PL", "Польща");
    namesMap.put("PM", "Сен-Пʼєр і Мікелон");
    namesMap.put("PN", "Острови Піткерн");
    namesMap.put("PR", "Пуерто-Ріко");
    namesMap.put("PS", "Палестинські території");
    namesMap.put("PT", "Портуґалія");
    namesMap.put("PW", "Палау");
    namesMap.put("PY", "Параґвай");
    namesMap.put("QA", "Катар");
    namesMap.put("QO", "Віддалена Океанія");
    namesMap.put("RE", "Реюньйон");
    namesMap.put("RO", "Румунія");
    namesMap.put("RS", "Сербія");
    namesMap.put("RU", "Росія");
    namesMap.put("RW", "Руанда");
    namesMap.put("SA", "Саудівська Аравія");
    namesMap.put("SB", "Соломонові Острови");
    namesMap.put("SC", "Сейшельські Острови");
    namesMap.put("SD", "Судан");
    namesMap.put("SE", "Швеція");
    namesMap.put("SG", "Сінгапур");
    namesMap.put("SH", "Острів Святої Єлени");
    namesMap.put("SI", "Словенія");
    namesMap.put("SJ", "Шпіцберген та Ян-Маєн");
    namesMap.put("SK", "Словаччина");
    namesMap.put("SL", "Сьєрра-Леоне");
    namesMap.put("SM", "Сан-Маріно");
    namesMap.put("SN", "Сенегал");
    namesMap.put("SO", "Сомалі");
    namesMap.put("SR", "Сурінам");
    namesMap.put("SS", "Південний Судан");
    namesMap.put("ST", "Сан-Томе і Прінсіпі");
    namesMap.put("SV", "Сальвадор");
    namesMap.put("SX", "Сінт-Мартен");
    namesMap.put("SY", "Сирія");
    namesMap.put("SZ", "Свазіленд");
    namesMap.put("TA", "Трістан-да-Кунья");
    namesMap.put("TC", "Острови Теркс і Кайкос");
    namesMap.put("TD", "Чад");
    namesMap.put("TF", "Французькі Південні Території");
    namesMap.put("TG", "Того");
    namesMap.put("TH", "Таїланд");
    namesMap.put("TJ", "Таджикистан");
    namesMap.put("TK", "Токелау");
    namesMap.put("TL", "Тімор-Лешті");
    namesMap.put("TM", "Туркменістан");
    namesMap.put("TN", "Туніс");
    namesMap.put("TO", "Тонґа");
    namesMap.put("TR", "Туреччина");
    namesMap.put("TT", "Трінідад і Тобаґо");
    namesMap.put("TV", "Тувалу");
    namesMap.put("TW", "Тайвань");
    namesMap.put("TZ", "Танзанія");
    namesMap.put("UA", "Україна");
    namesMap.put("UG", "Уганда");
    namesMap.put("UM", "Віддалені острови США");
    namesMap.put("UN", "Організація Об’єднаних Націй");
    namesMap.put("US", "Сполучені Штати");
    namesMap.put("UY", "Уруґвай");
    namesMap.put("UZ", "Узбекистан");
    namesMap.put("VA", "Ватикан");
    namesMap.put("VC", "Сент-Вінсент і Ґренадіни");
    namesMap.put("VE", "Венесуела");
    namesMap.put("VG", "Британські Віргінські острови");
    namesMap.put("VI", "Віргінські острови, США");
    namesMap.put("VN", "Вʼєтнам");
    namesMap.put("VU", "Вануату");
    namesMap.put("WF", "Уолліс і Футуна");
    namesMap.put("WS", "Самоа");
    namesMap.put("XK", "Косово");
    namesMap.put("YE", "Ємен");
    namesMap.put("YT", "Майотта");
    namesMap.put("ZA", "Південно-Африканська Республіка");
    namesMap.put("ZM", "Замбія");
    namesMap.put("ZW", "Зімбабве");
    namesMap.put("ZZ", "Невідомий регіон");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Світ",
        "002": "Африка",
        "003": "Північна Америка",
        "005": "Південна Америка",
        "009": "Океанія",
        "011": "Західна Африка",
        "013": "Центральна Америка",
        "014": "Східна Африка",
        "015": "Північна Африка",
        "017": "Центральна Африка",
        "018": "Південний регіон Африки",
        "019": "Америка",
        "021": "Північна Америка (регіон)",
        "029": "Карибський басейн",
        "030": "Східна Азія",
        "034": "Південна Азія",
        "035": "Південно-Східна Азія",
        "039": "Південна Європа",
        "053": "Австралазія",
        "054": "Меланезія",
        "057": "Мікронезійський регіон",
        "061": "Полінезія",
        "142": "Азія",
        "143": "Центральна Азія",
        "145": "Західна Азія",
        "150": "Європа",
        "151": "Східна Європа",
        "154": "Північна Європа",
        "155": "Західна Європа",
        "202": "Африка на південь від Сахари",
        "419": "Латинська Америка",
        "AC": "Острів Вознесіння",
        "AD": "Андорра",
        "AE": "Обʼєднані Арабські Емірати",
        "AF": "Афганістан",
        "AG": "Антиґуа і Барбуда",
        "AI": "Анґілья",
        "AL": "Албанія",
        "AM": "Вірменія",
        "AO": "Ангола",
        "AQ": "Антарктика",
        "AR": "Аргентина",
        "AS": "Американське Самоа",
        "AT": "Австрія",
        "AU": "Австралія",
        "AW": "Аруба",
        "AX": "Аландські Острови",
        "AZ": "Азербайджан",
        "BA": "Боснія і Герцеґовина",
        "BB": "Барбадос",
        "BD": "Бангладеш",
        "BE": "Бельґія",
        "BF": "Буркіна-Фасо",
        "BG": "Болгарія",
        "BH": "Бахрейн",
        "BI": "Бурунді",
        "BJ": "Бенін",
        "BL": "Сен-Бартельмі",
        "BM": "Бермудські Острови",
        "BN": "Бруней",
        "BO": "Болівія",
        "BQ": "Нідерландські Карибські острови",
        "BR": "Бразілія",
        "BS": "Багамські Острови",
        "BT": "Бутан",
        "BV": "Острів Буве",
        "BW": "Ботсвана",
        "BY": "Білорусь",
        "BZ": "Беліз",
        "CA": "Канада",
        "CC": "Кокосові (Кілінґ) Острови",
        "CD": "Конго – Кіншаса",
        "CF": "Центральноафриканська Республіка",
        "CG": "Конго – Браззавіль",
        "CH": "Швейцарія",
        "CI": "Кот-дʼІвуар",
        "CK": "Острови Кука",
        "CL": "Чілі",
        "CM": "Камерун",
        "CN": "Китай",
        "CO": "Колумбія",
        "CP": "Острів Кліппертон",
        "CR": "Коста-Ріка",
        "CU": "Куба",
        "CV": "Кабо-Верде",
        "CW": "Кюрасао",
        "CX": "Острів Різдва",
        "CY": "Кіпр",
        "CZ": "Чехія",
        "DE": "Німеччина",
        "DG": "Дієго-Гарсія",
        "DJ": "Джибуті",
        "DK": "Данія",
        "DM": "Домініка",
        "DO": "Домініканська Республіка",
        "DZ": "Алжир",
        "EA": "Сеута і Мелілья",
        "EC": "Еквадор",
        "EE": "Естонія",
        "EG": "Єгипет",
        "EH": "Західна Сахара",
        "ER": "Еритрея",
        "ES": "Іспанія",
        "ET": "Ефіопія",
        "EU": "Європейський Союз",
        "EZ": "Єврозона",
        "FI": "Фінляндія",
        "FJ": "Фіджі",
        "FK": "Фолклендські Острови",
        "FM": "Мікронезія",
        "FO": "Фарерські Острови",
        "FR": "Франція",
        "GA": "Габон",
        "GB": "Велика Британія",
        "GD": "Ґренада",
        "GE": "Грузія",
        "GF": "Французька Ґвіана",
        "GG": "Ґернсі",
        "GH": "Гана",
        "GI": "Ґібралтар",
        "GL": "Ґренландія",
        "GM": "Гамбія",
        "GN": "Гвінея",
        "GP": "Ґваделупа",
        "GQ": "Екваторіальна Гвінея",
        "GR": "Греція",
        "GS": "Південна Джорджія та Південні Сандвічеві Острови",
        "GT": "Ґватемала",
        "GU": "Ґуам",
        "GW": "Гвінея-Бісау",
        "GY": "Ґайана",
        "HK": "Гонконг, О.А.Р. Китаю",
        "HM": "Острови Герд і Макдоналд",
        "HN": "Гондурас",
        "HR": "Хорватія",
        "HT": "Гаїті",
        "HU": "Угорщина",
        "IC": "Канарські Острови",
        "ID": "Індонезія",
        "IE": "Ірландія",
        "IL": "Ізраїль",
        "IM": "Острів Мен",
        "IN": "Індія",
        "IO": "Британська територія в Індійському Океані",
        "IQ": "Ірак",
        "IR": "Іран",
        "IS": "Ісландія",
        "IT": "Італія",
        "JE": "Джерсі",
        "JM": "Ямайка",
        "JO": "Йорданія",
        "JP": "Японія",
        "KE": "Кенія",
        "KG": "Киргизстан",
        "KH": "Камбоджа",
        "KI": "Кірібаті",
        "KM": "Комори",
        "KN": "Сент-Кітс і Невіс",
        "KP": "Північна Корея",
        "KR": "Південна Корея",
        "KW": "Кувейт",
        "KY": "Кайманові Острови",
        "KZ": "Казахстан",
        "LA": "Лаос",
        "LB": "Ліван",
        "LC": "Сент-Люсія",
        "LI": "Ліхтенштейн",
        "LK": "Шрі-Ланка",
        "LR": "Ліберія",
        "LS": "Лесото",
        "LT": "Литва",
        "LU": "Люксембурґ",
        "LV": "Латвія",
        "LY": "Лівія",
        "MA": "Марокко",
        "MC": "Монако",
        "MD": "Молдова",
        "ME": "Чорногорія",
        "MF": "Сен-Мартен",
        "MG": "Мадагаскар",
        "MH": "Маршаллові Острови",
        "MK": "Македонія",
        "ML": "Малі",
        "MM": "Мʼянма (Бірма)",
        "MN": "Монголія",
        "MO": "Макао, О.А.Р Китаю",
        "MP": "Північні Маріанські Острови",
        "MQ": "Мартініка",
        "MR": "Мавританія",
        "MS": "Монтсеррат",
        "MT": "Мальта",
        "MU": "Маврікій",
        "MV": "Мальдіви",
        "MW": "Малаві",
        "MX": "Мексика",
        "MY": "Малайзія",
        "MZ": "Мозамбік",
        "NA": "Намібія",
        "NC": "Нова Каледонія",
        "NE": "Нігер",
        "NF": "Острів Норфолк",
        "NG": "Нігерія",
        "NI": "Нікараґуа",
        "NL": "Нідерланди",
        "NO": "Норвеґія",
        "NP": "Непал",
        "NR": "Науру",
        "NU": "Ніуе",
        "NZ": "Нова Зеландія",
        "OM": "Оман",
        "PA": "Панама",
        "PE": "Перу",
        "PF": "Французька Полінезія",
        "PG": "Папуа-Нова Ґвінея",
        "PH": "Філіппіни",
        "PK": "Пакистан",
        "PL": "Польща",
        "PM": "Сен-Пʼєр і Мікелон",
        "PN": "Острови Піткерн",
        "PR": "Пуерто-Ріко",
        "PS": "Палестинські території",
        "PT": "Портуґалія",
        "PW": "Палау",
        "PY": "Параґвай",
        "QA": "Катар",
        "QO": "Віддалена Океанія",
        "RE": "Реюньйон",
        "RO": "Румунія",
        "RS": "Сербія",
        "RU": "Росія",
        "RW": "Руанда",
        "SA": "Саудівська Аравія",
        "SB": "Соломонові Острови",
        "SC": "Сейшельські Острови",
        "SD": "Судан",
        "SE": "Швеція",
        "SG": "Сінгапур",
        "SH": "Острів Святої Єлени",
        "SI": "Словенія",
        "SJ": "Шпіцберген та Ян-Маєн",
        "SK": "Словаччина",
        "SL": "Сьєрра-Леоне",
        "SM": "Сан-Маріно",
        "SN": "Сенегал",
        "SO": "Сомалі",
        "SR": "Сурінам",
        "SS": "Південний Судан",
        "ST": "Сан-Томе і Прінсіпі",
        "SV": "Сальвадор",
        "SX": "Сінт-Мартен",
        "SY": "Сирія",
        "SZ": "Свазіленд",
        "TA": "Трістан-да-Кунья",
        "TC": "Острови Теркс і Кайкос",
        "TD": "Чад",
        "TF": "Французькі Південні Території",
        "TG": "Того",
        "TH": "Таїланд",
        "TJ": "Таджикистан",
        "TK": "Токелау",
        "TL": "Тімор-Лешті",
        "TM": "Туркменістан",
        "TN": "Туніс",
        "TO": "Тонґа",
        "TR": "Туреччина",
        "TT": "Трінідад і Тобаґо",
        "TV": "Тувалу",
        "TW": "Тайвань",
        "TZ": "Танзанія",
        "UA": "Україна",
        "UG": "Уганда",
        "UM": "Віддалені острови США",
        "UN": "Організація Об’єднаних Націй",
        "US": "Сполучені Штати",
        "UY": "Уруґвай",
        "UZ": "Узбекистан",
        "VA": "Ватикан",
        "VC": "Сент-Вінсент і Ґренадіни",
        "VE": "Венесуела",
        "VG": "Британські Віргінські острови",
        "VI": "Віргінські острови, США",
        "VN": "Вʼєтнам",
        "VU": "Вануату",
        "WF": "Уолліс і Футуна",
        "WS": "Самоа",
        "XK": "Косово",
        "YE": "Ємен",
        "YT": "Майотта",
        "ZA": "Південно-Африканська Республіка",
        "ZM": "Замбія",
        "ZW": "Зімбабве",
        "ZZ": "Невідомий регіон"
    };
  }-*/;
}
