/*
 * Decompiled with CFR 0.152.
 */
package galdr.processor;

import galdr.processor.MemberChecks;
import galdr.processor.ProcessorException;
import galdr.processor.vendor.google.auto.common.AnnotationMirrors;
import galdr.processor.vendor.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;

final class AnnotationsUtil {
    private AnnotationsUtil() {
    }

    @Nonnull
    static List<TypeMirror> getTypeMirrorsAnnotationParameter(@Nonnull AnnotatedConstruct annotated, @Nonnull String annotationClassName, @Nonnull String parameterName) {
        AnnotationValue annotationValue = AnnotationsUtil.getAnnotationValue(annotated, annotationClassName, parameterName);
        return ((List)annotationValue.getValue()).stream().map(v -> (TypeMirror)v.getValue()).collect(Collectors.toList());
    }

    @Nonnull
    static AnnotationValue getAnnotationValue(@Nonnull AnnotatedConstruct annotated, @Nonnull String annotationClassName, @Nonnull String parameterName) {
        AnnotationValue value = AnnotationsUtil.findAnnotationValue(annotated, annotationClassName, parameterName);
        assert (null != value);
        return value;
    }

    @Nullable
    static AnnotationValue findAnnotationValue(@Nonnull AnnotatedConstruct annotated, @Nonnull String annotationClassName, @Nonnull String parameterName) {
        AnnotationMirror mirror = AnnotationsUtil.findAnnotationByType(annotated, annotationClassName);
        return null == mirror ? null : AnnotationsUtil.findAnnotationValue(mirror, parameterName);
    }

    @Nullable
    private static AnnotationValue findAnnotationValue(@Nonnull AnnotationMirror annotation, @Nonnull String parameterName) {
        ImmutableMap<ExecutableElement, AnnotationValue> values = AnnotationMirrors.getAnnotationValuesWithDefaults(annotation);
        ExecutableElement annotationKey = values.keySet().stream().filter(k -> parameterName.equals(k.getSimpleName().toString())).findFirst().orElse(null);
        return values.get(annotationKey);
    }

    @Nullable
    static AnnotationValue findAnnotationValueNoDefaults(@Nonnull AnnotationMirror annotation, @Nonnull String parameterName) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> values = annotation.getElementValues();
        ExecutableElement annotationKey = values.keySet().stream().filter(k -> parameterName.equals(k.getSimpleName().toString())).findFirst().orElse(null);
        return values.get(annotationKey);
    }

    @Nonnull
    static <T> T getAnnotationValue(@Nonnull AnnotationMirror annotation, @Nonnull String parameterName) {
        AnnotationValue value = AnnotationsUtil.findAnnotationValue(annotation, parameterName);
        assert (null != value);
        return (T)value.getValue();
    }

    @Nonnull
    static AnnotationMirror getAnnotationByType(@Nonnull AnnotatedConstruct annotated, @Nonnull String annotationClassName) {
        AnnotationMirror mirror = AnnotationsUtil.findAnnotationByType(annotated, annotationClassName);
        assert (null != mirror);
        return mirror;
    }

    @Nullable
    static AnnotationMirror findAnnotationByType(@Nonnull AnnotatedConstruct annotated, @Nonnull String annotationClassName) {
        return annotated.getAnnotationMirrors().stream().filter(a -> a.getAnnotationType().toString().equals(annotationClassName)).findFirst().orElse(null);
    }

    static boolean hasAnnotationOfType(@Nonnull AnnotatedConstruct annotated, @Nonnull String annotationClassName) {
        return null != AnnotationsUtil.findAnnotationByType(annotated, annotationClassName);
    }

    @Nonnull
    static String extractName(@Nonnull ExecutableElement method, @Nonnull Function<ExecutableElement, String> defaultExtractor, @Nonnull String annotationClassname, @Nonnull String parameterName, @Nonnull String sentinelValue) {
        String declaredName = (String)AnnotationsUtil.getAnnotationValue(method, annotationClassname, parameterName).getValue();
        if (sentinelValue.equals(declaredName)) {
            String defaultValue = defaultExtractor.apply(method);
            if (null == defaultValue) {
                throw new ProcessorException(MemberChecks.toSimpleName(annotationClassname) + " target did not specify the parameter " + parameterName + " and the default value could not be derived", method);
            }
            return defaultValue;
        }
        if (!SourceVersion.isIdentifier(declaredName)) {
            throw new ProcessorException(MemberChecks.toSimpleName(annotationClassname) + " target specified an invalid value '" + declaredName + "' for the parameter " + parameterName + ". The value must be a valid java identifier", method);
        }
        if (SourceVersion.isKeyword(declaredName)) {
            throw new ProcessorException(MemberChecks.toSimpleName(annotationClassname) + " target specified an invalid value '" + declaredName + "' for the parameter " + parameterName + ". The value must not be a java keyword", method);
        }
        return declaredName;
    }
}

