/*
 * Decompiled with CFR 0.152.
 */
package galdr.processor;

import galdr.processor.AnnotationsUtil;
import galdr.processor.ProcessorUtil;
import galdr.processor.vendor.google.auto.common.MoreElements;
import galdr.processor.vendor.javapoet.AnnotationSpec;
import galdr.processor.vendor.javapoet.ClassName;
import galdr.processor.vendor.javapoet.FieldSpec;
import galdr.processor.vendor.javapoet.JavaFile;
import galdr.processor.vendor.javapoet.MethodSpec;
import galdr.processor.vendor.javapoet.ParameterSpec;
import galdr.processor.vendor.javapoet.TypeName;
import galdr.processor.vendor.javapoet.TypeSpec;
import galdr.processor.vendor.javapoet.TypeVariableName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;

final class GeneratorUtil {
    private GeneratorUtil() {
    }

    @Nonnull
    static ClassName getGeneratedClassName(@Nonnull TypeElement element, @Nonnull String prefix, @Nonnull String postfix) {
        return ClassName.get(GeneratorUtil.getQualifiedPackageName(element), GeneratorUtil.getGeneratedSimpleClassName(element, prefix, postfix), new String[0]);
    }

    @Nonnull
    static String getQualifiedPackageName(@Nonnull TypeElement element) {
        return GeneratorUtil.getPackageElement(element).getQualifiedName().toString();
    }

    @Nonnull
    static String getGeneratedSimpleClassName(@Nonnull TypeElement element, @Nonnull String prefix, @Nonnull String postfix) {
        return GeneratorUtil.getNestedClassPrefix(element) + prefix + element.getSimpleName() + postfix;
    }

    @Nonnull
    private static String getNestedClassPrefix(@Nonnull TypeElement element) {
        StringBuilder name = new StringBuilder();
        TypeElement t = element;
        while (NestingKind.TOP_LEVEL != t.getNestingKind()) {
            t = (TypeElement)t.getEnclosingElement();
            name.insert(0, t.getSimpleName() + "_");
        }
        return name.toString();
    }

    @Nonnull
    static PackageElement getPackageElement(@Nonnull TypeElement element) {
        return MoreElements.getPackage(element);
    }

    static void emitJavaType(@Nonnull String packageName, @Nonnull TypeSpec typeSpec, @Nonnull Filer filer) throws IOException {
        JavaFile.builder(packageName, typeSpec).skipJavaLangImports(true).build().writeTo(filer);
    }

    @Nonnull
    static List<TypeVariableName> getTypeArgumentsAsNames(@Nonnull DeclaredType declaredType) {
        ArrayList<TypeVariableName> variables = new ArrayList<TypeVariableName>();
        for (TypeMirror typeMirror : declaredType.getTypeArguments()) {
            variables.add(TypeVariableName.get((TypeVariable)typeMirror));
        }
        return variables;
    }

    static void copyAccessModifiers(@Nonnull TypeElement element, @Nonnull TypeSpec.Builder builder) {
        if (element.getModifiers().contains((Object)Modifier.PUBLIC)) {
            builder.addModifiers(Modifier.PUBLIC);
        }
    }

    static void copyAccessModifiers(@Nonnull TypeElement element, @Nonnull MethodSpec.Builder builder) {
        if (element.getModifiers().contains((Object)Modifier.PUBLIC)) {
            builder.addModifiers(Modifier.PUBLIC);
        }
    }

    static void copyAccessModifiers(@Nonnull ExecutableElement element, @Nonnull MethodSpec.Builder builder) {
        if (element.getModifiers().contains((Object)Modifier.PUBLIC)) {
            builder.addModifiers(Modifier.PUBLIC);
        } else if (element.getModifiers().contains((Object)Modifier.PROTECTED)) {
            builder.addModifiers(Modifier.PROTECTED);
        }
    }

    static void copyExceptions(@Nonnull ExecutableType method, @Nonnull MethodSpec.Builder builder) {
        for (TypeMirror typeMirror : method.getThrownTypes()) {
            builder.addException(TypeName.get(typeMirror));
        }
    }

    static void copyTypeParameters(@Nonnull ExecutableType action, @Nonnull MethodSpec.Builder builder) {
        for (TypeVariable typeVariable : action.getTypeVariables()) {
            builder.addTypeVariable(TypeVariableName.get(typeVariable));
        }
    }

    static void copyTypeParameters(@Nonnull TypeElement element, @Nonnull MethodSpec.Builder builder) {
        for (TypeParameterElement typeParameterElement : element.getTypeParameters()) {
            builder.addTypeVariable(TypeVariableName.get(typeParameterElement));
        }
    }

    static void copyTypeParameters(@Nonnull TypeElement element, @Nonnull TypeSpec.Builder builder) {
        for (TypeParameterElement typeParameterElement : element.getTypeParameters()) {
            builder.addTypeVariable(TypeVariableName.get(typeParameterElement));
        }
    }

    static void copyWhitelistedAnnotations(@Nonnull AnnotatedConstruct element, @Nonnull TypeSpec.Builder builder, @Nonnull List<String> whitelist) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!whitelist.contains(annotationMirror.getAnnotationType().toString())) continue;
            builder.addAnnotation(AnnotationSpec.get(annotationMirror));
        }
    }

    static void copyWhitelistedAnnotations(@Nonnull AnnotatedConstruct element, @Nonnull MethodSpec.Builder builder, @Nonnull List<String> whitelist) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!whitelist.contains(annotationMirror.getAnnotationType().toString())) continue;
            builder.addAnnotation(AnnotationSpec.get(annotationMirror));
        }
    }

    static void copyWhitelistedAnnotations(@Nonnull AnnotatedConstruct element, @Nonnull ParameterSpec.Builder builder, @Nonnull List<String> whitelist) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!whitelist.contains(annotationMirror.getAnnotationType().toString())) continue;
            builder.addAnnotation(AnnotationSpec.get(annotationMirror));
        }
    }

    static void copyWhitelistedAnnotations(@Nonnull AnnotatedConstruct element, @Nonnull FieldSpec.Builder builder, @Nonnull List<String> whitelist) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!whitelist.contains(annotationMirror.getAnnotationType().toString())) continue;
            builder.addAnnotation(AnnotationSpec.get(annotationMirror));
        }
    }

    static void addOriginatingTypes(@Nonnull TypeElement element, @Nonnull TypeSpec.Builder builder) {
        builder.addOriginatingElement(element);
        ProcessorUtil.getSuperTypes(element).forEach(builder::addOriginatingElement);
    }

    static void addGeneratedAnnotation(@Nonnull ProcessingEnvironment processingEnv, @Nonnull TypeSpec.Builder builder, @Nonnull String classname) {
        SourceVersion sourceVersion = processingEnv.getSourceVersion();
        String annotationName = sourceVersion.compareTo(SourceVersion.RELEASE_8) > 0 ? "javax.annotation.processing.Generated" : "javax.annotation.Generated";
        TypeElement annotation = processingEnv.getElementUtils().getTypeElement(annotationName);
        if (null != annotation) {
            AnnotationSpec annotationSpec = AnnotationSpec.builder(ClassName.get(annotation)).addMember("value", "$S", classname).build();
            builder.addAnnotation(annotationSpec);
        }
    }

    @Nonnull
    static MethodSpec.Builder refMethod(@Nonnull ProcessingEnvironment processingEnv, @Nonnull TypeElement typeElement, @Nonnull ExecutableElement original) {
        TypeElement nonnull;
        ExecutableType originalExecutableType = (ExecutableType)processingEnv.getTypeUtils().asMemberOf((DeclaredType)typeElement.asType(), original);
        TypeMirror returnType = originalExecutableType.getReturnType();
        String methodName = original.getSimpleName().toString();
        MethodSpec.Builder method = MethodSpec.methodBuilder(methodName);
        method.addModifiers(Modifier.FINAL);
        if (AnnotationsUtil.hasAnnotationOfType(original, Deprecated.class.getName())) {
            method.addAnnotation(Deprecated.class);
        }
        method.addAnnotation(Override.class);
        if (!TypeName.get(returnType).isPrimitive() && null != (nonnull = processingEnv.getElementUtils().getTypeElement("javax.annotation.Nonnull"))) {
            method.addAnnotation(ClassName.get("javax.annotation", "Nonnull", new String[0]));
        }
        if (GeneratorUtil.hasRawTypes(processingEnv, returnType)) {
            method.addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", "rawtypes").build());
        }
        GeneratorUtil.copyAccessModifiers(original, method);
        GeneratorUtil.copyTypeParameters(originalExecutableType, method);
        method.returns(TypeName.get(returnType));
        return method;
    }

    private static boolean hasRawTypes(@Nonnull ProcessingEnvironment processingEnv, @Nonnull TypeMirror type) {
        if (type instanceof ArrayType) {
            return GeneratorUtil.hasRawTypes(processingEnv, ((ArrayType)type).getComponentType());
        }
        if (type instanceof DeclaredType) {
            TypeElement typeElement;
            DeclaredType declaredType = (DeclaredType)type;
            int typeArgumentCount = declaredType.getTypeArguments().size();
            return typeArgumentCount != (typeElement = (TypeElement)processingEnv.getTypeUtils().asElement(type)).getTypeParameters().size();
        }
        return false;
    }
}

