/*
 * Decompiled with CFR 0.152.
 */
package galdr.processor;

import galdr.processor.AnnotationsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

final class ProcessorUtil {
    private ProcessorUtil() {
    }

    static boolean isWarningSuppressed(@Nonnull Element element, @Nonnull String warning, @Nullable String alternativeSuppressWarnings) {
        Element enclosingElement;
        SuppressWarnings annotation;
        String[] value;
        AnnotationMirror suppress;
        if (null != alternativeSuppressWarnings && null != (suppress = AnnotationsUtil.findAnnotationByType(element, alternativeSuppressWarnings)) && null != (value = AnnotationsUtil.findAnnotationValueNoDefaults(suppress, "value"))) {
            List warnings = (List)value.getValue();
            for (AnnotationValue annotationValue : warnings) {
                if (!warning.equals(annotationValue.getValue())) continue;
                return true;
            }
        }
        if (null != (annotation = element.getAnnotation(SuppressWarnings.class))) {
            for (String string : annotation.value()) {
                if (!warning.equals(string)) continue;
                return true;
            }
        }
        return null != (enclosingElement = element.getEnclosingElement()) && ProcessorUtil.isWarningSuppressed(enclosingElement, warning, alternativeSuppressWarnings);
    }

    @Nonnull
    static List<TypeElement> getSuperTypes(@Nonnull TypeElement element) {
        ArrayList<TypeElement> superTypes = new ArrayList<TypeElement>();
        ProcessorUtil.enumerateSuperTypes(element, superTypes);
        return superTypes;
    }

    private static void enumerateSuperTypes(@Nonnull TypeElement element, @Nonnull List<TypeElement> superTypes) {
        TypeMirror superclass = element.getSuperclass();
        if (TypeKind.NONE != superclass.getKind()) {
            TypeElement superclassElement = (TypeElement)((DeclaredType)superclass).asElement();
            superTypes.add(superclassElement);
            ProcessorUtil.enumerateSuperTypes(superclassElement, superTypes);
        }
        for (TypeMirror typeMirror : element.getInterfaces()) {
            TypeElement interfaceElement = (TypeElement)((DeclaredType)typeMirror).asElement();
            ProcessorUtil.enumerateSuperTypes(interfaceElement, superTypes);
        }
    }

    @Nonnull
    static List<TypeElement> getInterfaces(@Nonnull TypeElement element) {
        ArrayList<TypeElement> superTypes = new ArrayList<TypeElement>();
        ProcessorUtil.enumerateInterfaces(element, superTypes);
        return superTypes;
    }

    private static void enumerateInterfaces(@Nonnull TypeElement element, @Nonnull List<TypeElement> superTypes) {
        TypeMirror superclass = element.getSuperclass();
        if (TypeKind.NONE != superclass.getKind()) {
            TypeElement superclassElement = (TypeElement)((DeclaredType)superclass).asElement();
            ProcessorUtil.enumerateInterfaces(superclassElement, superTypes);
        }
        for (TypeMirror typeMirror : element.getInterfaces()) {
            TypeElement interfaceElement = (TypeElement)((DeclaredType)typeMirror).asElement();
            superTypes.add(interfaceElement);
            ProcessorUtil.enumerateInterfaces(interfaceElement, superTypes);
        }
    }

    @Nonnull
    static List<VariableElement> getFieldElements(@Nonnull TypeElement element) {
        LinkedHashMap<String, VariableElement> methodMap = new LinkedHashMap<String, VariableElement>();
        ProcessorUtil.enumerateFieldElements(element, methodMap);
        return new ArrayList<VariableElement>(methodMap.values());
    }

    private static void enumerateFieldElements(@Nonnull TypeElement element, @Nonnull Map<String, VariableElement> fields) {
        TypeMirror superclass = element.getSuperclass();
        if (TypeKind.NONE != superclass.getKind()) {
            ProcessorUtil.enumerateFieldElements((TypeElement)((DeclaredType)superclass).asElement(), fields);
        }
        for (Element element2 : element.getEnclosedElements()) {
            if (element2.getKind() != ElementKind.FIELD) continue;
            fields.put(element2.getSimpleName().toString(), (VariableElement)element2);
        }
    }

    @Nonnull
    static List<ExecutableElement> getMethods(@Nonnull TypeElement element, @Nonnull Elements elementUtils, @Nonnull Types typeUtils) {
        LinkedHashMap<String, ArrayList<ExecutableElement>> methodMap = new LinkedHashMap<String, ArrayList<ExecutableElement>>();
        ProcessorUtil.enumerateMethods(element, elementUtils, typeUtils, element, methodMap);
        return methodMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static void enumerateMethods(@Nonnull TypeElement scope, @Nonnull Elements elementUtils, @Nonnull Types typeUtils, @Nonnull TypeElement element, @Nonnull Map<String, ArrayList<ExecutableElement>> methods) {
        TypeMirror superclass = element.getSuperclass();
        if (TypeKind.NONE != superclass.getKind()) {
            TypeElement superclassElement = (TypeElement)((DeclaredType)superclass).asElement();
            ProcessorUtil.enumerateMethods(scope, elementUtils, typeUtils, superclassElement, methods);
        }
        for (TypeMirror typeMirror : element.getInterfaces()) {
            TypeElement interfaceElement = (TypeElement)((DeclaredType)typeMirror).asElement();
            ProcessorUtil.enumerateMethods(scope, elementUtils, typeUtils, interfaceElement, methods);
        }
        for (Element element2 : element.getEnclosedElements()) {
            if (element2.getKind() != ElementKind.METHOD) continue;
            ExecutableElement method = (ExecutableElement)element2;
            ProcessorUtil.processMethod(elementUtils, typeUtils, scope, methods, method);
        }
    }

    private static void processMethod(@Nonnull Elements elementUtils, @Nonnull Types typeUtils, @Nonnull TypeElement typeElement, @Nonnull Map<String, ArrayList<ExecutableElement>> methods, @Nonnull ExecutableElement method) {
        ExecutableType methodType = (ExecutableType)typeUtils.asMemberOf((DeclaredType)typeElement.asType(), method);
        String key = method.getSimpleName().toString();
        ArrayList elements = methods.computeIfAbsent(key, k -> new ArrayList());
        boolean found = false;
        int size = elements.size();
        for (int i = 0; i < size; ++i) {
            ExecutableElement executableElement = (ExecutableElement)elements.get(i);
            if (method.equals(executableElement)) {
                found = true;
                break;
            }
            if (ProcessorUtil.isSubsignature(typeUtils, typeElement, methodType, executableElement)) {
                if (!ProcessorUtil.isAbstractInterfaceMethod(method)) {
                    elements.set(i, method);
                }
                found = true;
                break;
            }
            if (!elementUtils.overrides(method, executableElement, typeElement)) continue;
            elements.set(i, method);
            found = true;
            break;
        }
        if (!found) {
            elements.add(method);
        }
    }

    private static boolean isAbstractInterfaceMethod(@Nonnull ExecutableElement method) {
        return method.getModifiers().contains((Object)Modifier.ABSTRACT) && ElementKind.INTERFACE == method.getEnclosingElement().getKind();
    }

    private static boolean isSubsignature(@Nonnull Types typeUtils, @Nonnull TypeElement typeElement, @Nonnull ExecutableType methodType, @Nonnull ExecutableElement candidate) {
        ExecutableType candidateType = (ExecutableType)typeUtils.asMemberOf((DeclaredType)typeElement.asType(), candidate);
        boolean isEqual = methodType.equals(candidateType);
        boolean isSubsignature = typeUtils.isSubsignature(methodType, candidateType);
        return isSubsignature || isEqual;
    }

    @Nonnull
    static List<ExecutableElement> getConstructors(@Nonnull TypeElement element) {
        return element.getEnclosedElements().stream().filter(m -> m.getKind() == ElementKind.CONSTRUCTOR).map(m -> (ExecutableElement)m).collect(Collectors.toList());
    }

    @Nonnull
    static String firstCharacterToLowerCase(@Nonnull String name) {
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    static boolean doesMethodOverrideInterfaceMethod(@Nonnull Types typeUtils, @Nonnull TypeElement typeElement, @Nonnull ExecutableElement method) {
        return ProcessorUtil.getInterfaces(typeElement).stream().flatMap(i -> i.getEnclosedElements().stream()).filter(e1 -> e1 instanceof ExecutableElement).map(e1 -> (ExecutableElement)e1).collect(Collectors.toList()).stream().anyMatch(e -> ProcessorUtil.isSubsignature(typeUtils, typeElement, (ExecutableType)typeUtils.asMemberOf((DeclaredType)typeElement.asType(), (Element)e), method));
    }
}

