/*
 * Decompiled with CFR 0.152.
 */
package galdr.processor.vendor.google.auto.common;

import galdr.processor.vendor.google.common.base.Enums;
import galdr.processor.vendor.google.common.base.Preconditions;
import galdr.processor.vendor.google.common.collect.Ordering;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;

public enum Visibility {
    PRIVATE,
    DEFAULT,
    PROTECTED,
    PUBLIC;

    private static final ElementKind MODULE;

    public static Visibility ofElement(Element element) {
        Preconditions.checkNotNull(element);
        if (element.getKind().equals((Object)ElementKind.PACKAGE) || element.getKind().equals((Object)MODULE)) {
            return PUBLIC;
        }
        Set<Modifier> modifiers = element.getModifiers();
        if (modifiers.contains((Object)Modifier.PRIVATE)) {
            return PRIVATE;
        }
        if (modifiers.contains((Object)Modifier.PROTECTED)) {
            return PROTECTED;
        }
        if (modifiers.contains((Object)Modifier.PUBLIC)) {
            return PUBLIC;
        }
        return DEFAULT;
    }

    public static Visibility effectiveVisibilityOfElement(Element element) {
        Preconditions.checkNotNull(element);
        Visibility effectiveVisibility = PUBLIC;
        for (Element currentElement = element; currentElement != null; currentElement = currentElement.getEnclosingElement()) {
            effectiveVisibility = Ordering.natural().min(effectiveVisibility, Visibility.ofElement(currentElement));
        }
        return effectiveVisibility;
    }

    static {
        MODULE = Enums.getIfPresent(ElementKind.class, "MODULE").orNull();
    }
}

