/*
 * Decompiled with CFR 0.152.
 */
package galdr.processor;

import galdr.processor.AbstractGaldrProcessor;
import galdr.processor.ApplicationDescriptor;
import galdr.processor.ComponentDescriptor;
import galdr.processor.Generator;
import galdr.processor.StageDescriptor;
import galdr.processor.StorageType;
import galdr.processor.vendor.javapoet.ClassName;
import galdr.processor.vendor.proton.AnnotationsUtil;
import galdr.processor.vendor.proton.ElementsUtil;
import galdr.processor.vendor.proton.MemberChecks;
import galdr.processor.vendor.proton.ProcessorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

@SupportedAnnotationTypes(value={"galdr.annotations.GaldrApplication"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedOptions(value={"galdr.defer.unresolved", "galdr.defer.errors"})
public final class ApplicationProcessor
extends AbstractGaldrProcessor {
    @Nonnull
    protected Set<TypeElement> getTypeElementsToProcess(@Nonnull RoundEnvironment env) {
        TypeElement annotation = this.processingEnv.getElementUtils().getTypeElement("galdr.annotations.GaldrApplication");
        return env.getElementsAnnotatedWith(annotation);
    }

    @Override
    protected final void process(@Nonnull TypeElement element) throws IOException, ProcessorException {
        String message;
        if (ElementKind.CLASS != element.getKind()) {
            throw new ProcessorException(MemberChecks.must("galdr.annotations.GaldrApplication", "be a class"), element);
        }
        if (!element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            throw new ProcessorException(MemberChecks.must("galdr.annotations.GaldrApplication", "be abstract"), element);
        }
        if (NestingKind.TOP_LEVEL != element.getNestingKind() && !element.getModifiers().contains((Object)Modifier.STATIC)) {
            String message2 = MemberChecks.mustNot("galdr.annotations.GaldrApplication", "be a non-static nested class");
            throw new ProcessorException(message2, element);
        }
        ApplicationDescriptor descriptor = new ApplicationDescriptor(element);
        List<TypeMirror> components = AnnotationsUtil.getTypeMirrorsAnnotationParameter(element, "galdr.annotations.GaldrApplication", "components");
        ArrayList<ClassName> componentTypes = new ArrayList<ClassName>();
        for (TypeMirror component : components) {
            TypeElement componentType = (TypeElement)this.processingEnv.getTypeUtils().asElement(component);
            if (null == componentType || !AnnotationsUtil.hasAnnotationOfType(componentType, "galdr.annotations.Component")) {
                throw new ProcessorException(MemberChecks.must("galdr.annotations.GaldrApplication", "have a components parameter that references classes annotated by " + MemberChecks.toSimpleName("galdr.annotations.Component") + " but references the type " + component + " that is not annotated appropriately"), element);
            }
            ClassName className = ClassName.get(componentType);
            if (componentTypes.contains(className)) {
                throw new ProcessorException(MemberChecks.mustNot("galdr.annotations.GaldrApplication", "have a duplicate type in the components parameter. The type " + component + " appears multiple times"), element);
            }
            componentTypes.add(className);
            VariableElement parameter = (VariableElement)AnnotationsUtil.getAnnotationValue(componentType, "galdr.annotations.Component", "storage").getValue();
            String storageName = parameter.getSimpleName().toString();
            StorageType storageType = "AUTODETECT".equals(storageName) ? this.autoDetectComponentStorage(componentType) : StorageType.valueOf(storageName);
            descriptor.addComponent(new ComponentDescriptor(component, storageType));
        }
        if (componentTypes.isEmpty()) {
            throw new ProcessorException(MemberChecks.must("galdr.annotations.GaldrApplication", "have at least one Component defined by the components parameter"), element);
        }
        List<ExecutableElement> constructors = ElementsUtil.getConstructors(element);
        if (constructors.size() > 1) {
            message = MemberChecks.must("galdr.annotations.GaldrApplication", "have no more than one constructor");
            throw new ProcessorException(message, element);
        }
        if (!constructors.isEmpty() && !constructors.get(0).getParameters().isEmpty()) {
            message = MemberChecks.must("galdr.annotations.GaldrApplication", "have a constructor with no parameters");
            throw new ProcessorException(message, constructors.get(0));
        }
        if (!constructors.isEmpty() && constructors.get(0).getModifiers().contains((Object)Modifier.PRIVATE)) {
            message = MemberChecks.mustNot("galdr.annotations.GaldrApplication", "have a private constructor");
            throw new ProcessorException(message, constructors.get(0));
        }
        List<ExecutableElement> methods = ElementsUtil.getMethods(element, this.processingEnv.getElementUtils(), this.processingEnv.getTypeUtils());
        for (ExecutableElement method : methods) {
            AnnotationMirror stage = AnnotationsUtil.findAnnotationByType(method, "galdr.annotations.GaldrStage");
            if (null == stage) continue;
            this.addStage(descriptor, method);
        }
        this.emitTypeSpec(descriptor.getPackageName(), Generator.buildApplication(this.processingEnv, descriptor));
    }

    @Nonnull
    private StorageType autoDetectComponentStorage(@Nonnull TypeElement componentType) {
        List<VariableElement> fields = ElementsUtil.getFields(componentType);
        return fields.isEmpty() ? StorageType.NONE : StorageType.ARRAY;
    }

    private void addStage(@Nonnull ApplicationDescriptor descriptor, @Nonnull ExecutableElement method) {
        MemberChecks.mustBeAbstract("galdr.annotations.GaldrStage", method);
        TypeElement typeElement = descriptor.getElement();
        MemberChecks.mustNotBePackageAccessInDifferentPackage(typeElement, "galdr.annotations.GaldrApplication", "galdr.annotations.GaldrStage", method);
        MemberChecks.mustNotHaveAnyParameters("galdr.annotations.GaldrStage", method);
        MemberChecks.mustReturnAValue("galdr.annotations.GaldrStage", method);
        MemberChecks.mustNotThrowAnyExceptions("galdr.annotations.GaldrStage", method);
        MemberChecks.mustReturnAnInstanceOf(this.processingEnv, method, "galdr.annotations.GaldrStage", "galdr.Stage");
        String name = AnnotationsUtil.extractName(method, m -> method.getSimpleName().toString(), "galdr.annotations.GaldrStage", "name", "<default>");
        for (StageDescriptor other : descriptor.getStages()) {
            if (!other.getName().equals(name)) continue;
            throw new ProcessorException(MemberChecks.mustNot("galdr.annotations.GaldrStage", "have the same name as any other stage but the stage defined by the method named " + other.getMethod().getSimpleName().toString() + " has the same name"), method);
        }
        List<TypeMirror> subSystems = AnnotationsUtil.getTypeMirrorsAnnotationParameter(method, "galdr.annotations.GaldrStage", "value");
        ArrayList<ClassName> subSystemTypes = new ArrayList<ClassName>();
        for (TypeMirror subSystem : subSystems) {
            TypeElement subSystemType = (TypeElement)this.processingEnv.getTypeUtils().asElement(subSystem);
            if (null == subSystemType || !AnnotationsUtil.hasAnnotationOfType(subSystemType, "galdr.annotations.GaldrSubSystem")) {
                throw new ProcessorException(MemberChecks.must("galdr.annotations.GaldrStage", "have a value parameter that references classes annotated by " + MemberChecks.toSimpleName("galdr.annotations.GaldrSubSystem") + " but references the type " + subSystem + " that is not annotated appropriately"), method);
            }
            ClassName className = Generator.toGeneratedClassName(subSystemType);
            if (subSystemTypes.contains(className)) {
                throw new ProcessorException(MemberChecks.mustNot("galdr.annotations.GaldrStage", "have a duplicate type in the value parameter. The type " + subSystem + " appears multiple times"), method);
            }
            subSystemTypes.add(className);
        }
        if (subSystemTypes.isEmpty()) {
            throw new ProcessorException(MemberChecks.must("galdr.annotations.GaldrStage", "have at least one SubSystem defined by the value parameter"), method);
        }
        descriptor.addStage(new StageDescriptor(name, method, subSystemTypes));
    }
}

