/*
 * Decompiled with CFR 0.152.
 */
package galdr.processor;

import galdr.processor.ApplicationDescriptor;
import galdr.processor.ApplicationProcessor;
import galdr.processor.ComponentDescriptor;
import galdr.processor.ComponentManagerRefDescriptor;
import galdr.processor.EntityProcessorDescriptor;
import galdr.processor.StageDescriptor;
import galdr.processor.StorageType;
import galdr.processor.SubSystemDescriptor;
import galdr.processor.SubSystemProcessor;
import galdr.processor.vendor.javapoet.ClassName;
import galdr.processor.vendor.javapoet.CodeBlock;
import galdr.processor.vendor.javapoet.FieldSpec;
import galdr.processor.vendor.javapoet.MethodSpec;
import galdr.processor.vendor.javapoet.ParameterSpec;
import galdr.processor.vendor.javapoet.ParameterizedTypeName;
import galdr.processor.vendor.javapoet.TypeName;
import galdr.processor.vendor.javapoet.TypeSpec;
import galdr.processor.vendor.proton.GeneratorUtil;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

final class Generator {
    private static final ClassName AREA_OF_INTEREST_CLASSNAME = ClassName.get("galdr", "AreaOfInterest", new String[0]);
    private static final ClassName COMPONENT_MANAGER_CLASSNAME = ClassName.get("galdr", "ComponentManager", new String[0]);
    private static final ClassName COMPONENT_STORAGE_CLASSNAME = ClassName.get("galdr", "ComponentStorage", new String[0]);
    private static final ClassName GALDR_CLASSNAME = ClassName.get("galdr", "Galdr", new String[0]);
    private static final ClassName STAGE_CLASSNAME = ClassName.get("galdr", "Stage", new String[0]);
    private static final ClassName SUBSCRIPTION_CLASSNAME = ClassName.get("galdr", "Subscription", new String[0]);
    private static final ClassName WORLD_CLASSNAME = ClassName.get("galdr", "World", new String[0]);
    private static final ClassName WORLDS_CLASSNAME = ClassName.get("galdr", "Worlds", new String[0]);
    private static final ClassName POST_CONSTRUCT_FN_CLASSNAME = ClassName.get("galdr.internal", "PostConstructFn", new String[0]);
    private static final ClassName ON_ACTIVATE_FN_CLASSNAME = ClassName.get("galdr.internal", "OnActivateFn", new String[0]);
    private static final ClassName ON_DEACTIVATE_FN_CLASSNAME = ClassName.get("galdr.internal", "OnDeactivateFn", new String[0]);
    private static final ClassName PROCESSOR_FN_CLASSNAME = ClassName.get("galdr", "SubSystem", new String[0]);
    private static final ClassName NONNULL_CLASSNAME = ClassName.get("javax.annotation", "Nonnull", new String[0]);
    private static final ClassName NULLABLE_CLASSNAME = ClassName.get("javax.annotation", "Nullable", new String[0]);
    private static final String FRAMEWORK_INTERNAL_PREFIX = "$galdr$_";
    private static final String FRAMEWORK_COMPONENT_PREFIX = "$galdrc$_";
    private static final String FRAMEWORK_SUBSCRIPTION_PREFIX = "$galdrs$_";
    private static final String FRAMEWORK_AREA_OF_INTEREST_PREFIX = "$galdraoi$_";
    private static final String OUTER_FIELD = "$galdr$_outer";
    private static final String NAME_ACCESSOR_METHOD = "$galdr$_getName";
    private static final String WORLD_ACCESSOR_METHOD = "$galdr$_getWorld";
    private static final String POST_CONSTRUCT_METHOD = "$galdr$_postConstruct";
    private static final String ON_ACTIVATE_METHOD = "$galdr$_onActivate";
    private static final String ON_DEACTIVATE_METHOD = "$galdr$_onDeactivate";
    private static final String PROCESS_METHOD = "$galdr$_process";

    private Generator() {
    }

    @Nonnull
    static TypeSpec buildApplication(@Nonnull ProcessingEnvironment processingEnv, @Nonnull ApplicationDescriptor descriptor) {
        TypeSpec.Builder builder = TypeSpec.classBuilder(descriptor.getEnhancedClassName());
        GeneratorUtil.addOriginatingTypes(descriptor.getElement(), builder);
        GeneratorUtil.addGeneratedAnnotation(processingEnv, builder, ApplicationProcessor.class.getName());
        builder.addModifiers(Modifier.FINAL);
        builder.superclass(TypeName.get(descriptor.getElement().asType()));
        Generator.emitStageFields(descriptor, builder);
        Generator.emitConstructor(descriptor, builder);
        Generator.emitStageMethods(descriptor, builder);
        return builder.build();
    }

    private static void emitStageFields(@Nonnull ApplicationDescriptor descriptor, @Nonnull TypeSpec.Builder builder) {
        for (StageDescriptor stage : descriptor.getStages()) {
            builder.addField(FieldSpec.builder(STAGE_CLASSNAME, "_" + stage.getName(), Modifier.FINAL, Modifier.PRIVATE).addAnnotation(NONNULL_CLASSNAME).build());
        }
    }

    private static void emitConstructor(@Nonnull ApplicationDescriptor descriptor, @Nonnull TypeSpec.Builder builder) {
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder();
        StringBuilder sb = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        sb.append("final $T world = $T");
        params.add(WORLD_CLASSNAME);
        params.add(WORLDS_CLASSNAME);
        sb.append("\n.world()");
        for (ComponentDescriptor component : descriptor.getComponents()) {
            StorageType storageType = component.getStorageType();
            if (StorageType.NONE == storageType) {
                sb.append("\n.component( $T.class )");
                params.add(component.getComponent());
                continue;
            }
            if (StorageType.ARRAY == storageType) {
                sb.append("\n.component( $T.class, $T::new )");
                params.add(component.getComponent());
                params.add(component.getComponent());
                continue;
            }
            assert (StorageType.MAP == storageType);
            sb.append("\n.component( $T.class, $T::new, $T.MAP )");
            params.add(component.getComponent());
            params.add(component.getComponent());
            params.add(COMPONENT_STORAGE_CLASSNAME);
        }
        for (StageDescriptor stage : descriptor.getStages()) {
            sb.append("\n.stage( $S )");
            params.add(stage.getName());
            for (ClassName subSystemType : stage.getSubSystemTypes()) {
                sb.append("\n.subSystem( new $T() )");
                params.add(subSystemType);
            }
            sb.append("\n.endStage()");
        }
        sb.append("\n.build()");
        constructor.addStatement(sb.toString(), params.toArray());
        for (StageDescriptor stage : descriptor.getStages()) {
            constructor.addStatement("$N = world.getStageByName( $S )", "_" + stage.getName(), stage.getName());
        }
        builder.addMethod(constructor.build());
    }

    private static void emitStageMethods(@Nonnull ApplicationDescriptor descriptor, @Nonnull TypeSpec.Builder builder) {
        for (StageDescriptor stage : descriptor.getStages()) {
            MethodSpec.Builder method = MethodSpec.overriding(stage.getMethod());
            method.addAnnotation(NONNULL_CLASSNAME);
            method.addStatement("return $N", "_" + stage.getName());
            builder.addMethod(method.build());
        }
    }

    @Nonnull
    static TypeSpec buildSubSystem(@Nonnull ProcessingEnvironment processingEnv, @Nonnull SubSystemDescriptor descriptor) {
        TypeSpec.Builder builder = TypeSpec.classBuilder(descriptor.getEnhancedClassName());
        GeneratorUtil.addOriginatingTypes(descriptor.getElement(), builder);
        GeneratorUtil.addGeneratedAnnotation(processingEnv, builder, SubSystemProcessor.class.getName());
        builder.addModifiers(Modifier.PUBLIC, Modifier.FINAL);
        ClassName enhancedSubSystem = ClassName.bestGuess("EnhancedSubSystem");
        builder.addField(FieldSpec.builder(enhancedSubSystem, "_subsystem", Modifier.PRIVATE, Modifier.FINAL).addAnnotation(NONNULL_CLASSNAME).initializer("new $T( this )", enhancedSubSystem).build());
        builder.addMethod(MethodSpec.methodBuilder(WORLD_ACCESSOR_METHOD).addAnnotation(NONNULL_CLASSNAME).addModifiers(Modifier.PRIVATE).returns(WORLD_CLASSNAME).addStatement("return $T.current()", WORLD_CLASSNAME).build());
        if (!descriptor.getComponentManagerRefs().isEmpty() || !descriptor.getEntityProcessors().isEmpty()) {
            builder.addSuperinterface(POST_CONSTRUCT_FN_CLASSNAME);
            builder.addMethod(MethodSpec.methodBuilder("postConstruct").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).addStatement("_subsystem.$N()", POST_CONSTRUCT_METHOD).build());
        }
        if (!descriptor.getOnActivates().isEmpty() || !descriptor.getEntityProcessors().isEmpty()) {
            builder.addSuperinterface(ON_ACTIVATE_FN_CLASSNAME);
            builder.addMethod(MethodSpec.methodBuilder("activate").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).addStatement("_subsystem.$N()", ON_ACTIVATE_METHOD).build());
        }
        if (!descriptor.getOnDeactivates().isEmpty() || !descriptor.getEntityProcessors().isEmpty()) {
            builder.addSuperinterface(ON_DEACTIVATE_FN_CLASSNAME);
            builder.addMethod(MethodSpec.methodBuilder("deactivate").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).addStatement("_subsystem.$N()", ON_DEACTIVATE_METHOD).build());
        }
        if (!descriptor.getProcessors().isEmpty() || !descriptor.getEntityProcessors().isEmpty()) {
            builder.addSuperinterface(PROCESSOR_FN_CLASSNAME);
            builder.addMethod(MethodSpec.methodBuilder("process").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).addParameter(TypeName.INT, "delta", Modifier.FINAL).addStatement("_subsystem.$N( delta )", PROCESS_METHOD).build());
        }
        builder.addType(Generator.buildEnhancedSubSystem(processingEnv, descriptor));
        return builder.build();
    }

    @Nonnull
    private static TypeSpec buildEnhancedSubSystem(@Nonnull ProcessingEnvironment processingEnv, @Nonnull SubSystemDescriptor descriptor) {
        TypeSpec.Builder builder = TypeSpec.classBuilder("EnhancedSubSystem");
        builder.addModifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL);
        builder.superclass(TypeName.get(descriptor.getElement().asType()));
        builder.addField(FieldSpec.builder(descriptor.getEnhancedClassName(), OUTER_FIELD, Modifier.PRIVATE, Modifier.FINAL).addAnnotation(NONNULL_CLASSNAME).build());
        for (EntityProcessorDescriptor entityProcessorDescriptor : descriptor.getEntityProcessors()) {
            String name = entityProcessorDescriptor.getMethod().getSimpleName().toString();
            builder.addField(FieldSpec.builder(SUBSCRIPTION_CLASSNAME, FRAMEWORK_SUBSCRIPTION_PREFIX + name, Modifier.PRIVATE).addAnnotation(NULLABLE_CLASSNAME).build());
            builder.addField(FieldSpec.builder(AREA_OF_INTEREST_CLASSNAME, FRAMEWORK_AREA_OF_INTEREST_PREFIX + name, Modifier.PRIVATE).addAnnotation(NULLABLE_CLASSNAME).build());
        }
        Generator.emitConstructor(descriptor, builder);
        Generator.emitComponentManagerAccessors(processingEnv, descriptor, builder);
        Generator.emitNameAccessors(processingEnv, descriptor, builder);
        Generator.emitWorldAccessors(processingEnv, descriptor, builder);
        Generator.emitPostConstruct(descriptor, builder);
        Generator.emitOnActivate(descriptor, builder);
        Generator.emitOnDeactivate(descriptor, builder);
        Generator.emitProcess(descriptor, builder);
        Generator.emitNativeNameMethod(descriptor, builder);
        Generator.emitToString(builder);
        return builder.build();
    }

    private static void emitConstructor(@Nonnull SubSystemDescriptor descriptor, @Nonnull TypeSpec.Builder builder) {
        builder.addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PRIVATE).addParameter(ParameterSpec.builder(descriptor.getEnhancedClassName(), "outer", Modifier.FINAL).addAnnotation(NONNULL_CLASSNAME).build()).addStatement("$N = $T.requireNonNull( outer )", OUTER_FIELD, Objects.class).build());
    }

    private static void emitComponentManagerAccessors(@Nonnull ProcessingEnvironment processingEnv, @Nonnull SubSystemDescriptor descriptor, @Nonnull TypeSpec.Builder builder) {
        for (ComponentManagerRefDescriptor componentManagerRef : descriptor.getComponentManagerRefs()) {
            ParameterizedTypeName type = ParameterizedTypeName.get(COMPONENT_MANAGER_CLASSNAME, componentManagerRef.getComponentType());
            ExecutableElement methodElement = componentManagerRef.getMethod();
            String fieldName = FRAMEWORK_COMPONENT_PREFIX + methodElement.getSimpleName().toString();
            builder.addField(FieldSpec.builder(type, fieldName, Modifier.PRIVATE).addAnnotation(NULLABLE_CLASSNAME).build());
            builder.addMethod(GeneratorUtil.refMethod(processingEnv, descriptor.getElement(), methodElement).addStatement("assert null != $N", fieldName).addStatement("return $N", fieldName).build());
        }
    }

    private static void emitNameAccessors(@Nonnull ProcessingEnvironment processingEnv, @Nonnull SubSystemDescriptor descriptor, @Nonnull TypeSpec.Builder builder) {
        for (ExecutableElement nameRef : descriptor.getNameRefs()) {
            builder.addMethod(GeneratorUtil.refMethod(processingEnv, descriptor.getElement(), nameRef).addStatement("return $N()", NAME_ACCESSOR_METHOD).build());
        }
    }

    private static void emitWorldAccessors(@Nonnull ProcessingEnvironment processingEnv, @Nonnull SubSystemDescriptor descriptor, @Nonnull TypeSpec.Builder builder) {
        for (ExecutableElement worldRef : descriptor.getWorldRefs()) {
            builder.addMethod(GeneratorUtil.refMethod(processingEnv, descriptor.getElement(), worldRef).addStatement("return $N.$N()", OUTER_FIELD, WORLD_ACCESSOR_METHOD).build());
        }
    }

    private static void emitPostConstruct(@Nonnull SubSystemDescriptor descriptor, @Nonnull TypeSpec.Builder builder) {
        if (!descriptor.getComponentManagerRefs().isEmpty() || !descriptor.getEntityProcessors().isEmpty()) {
            MethodSpec.Builder method = MethodSpec.methodBuilder(POST_CONSTRUCT_METHOD).addModifiers(Modifier.PRIVATE);
            for (ComponentManagerRefDescriptor componentManagerRef : descriptor.getComponentManagerRefs()) {
                ExecutableElement methodElement = componentManagerRef.getMethod();
                String methodName = methodElement.getSimpleName().toString();
                String fieldName = FRAMEWORK_COMPONENT_PREFIX + methodName;
                method.addStatement("$N = $N.$N().getComponentByType( $T.class )", fieldName, OUTER_FIELD, WORLD_ACCESSOR_METHOD, componentManagerRef.getComponentType());
            }
            for (EntityProcessorDescriptor entityProcessorDescriptor : descriptor.getEntityProcessors()) {
                String name = entityProcessorDescriptor.getMethod().getSimpleName().toString();
                StringBuilder sb = new StringBuilder("$N = $N.$N().createAreaOfInterest( ");
                ArrayList<Object> params = new ArrayList<Object>();
                params.add(FRAMEWORK_AREA_OF_INTEREST_PREFIX + name);
                params.add(OUTER_FIELD);
                params.add(WORLD_ACCESSOR_METHOD);
                Generator.emitTypeCollection(sb, params, entityProcessorDescriptor.getAll());
                List<TypeName> one = entityProcessorDescriptor.getOne();
                List<TypeName> exclude = entityProcessorDescriptor.getExclude();
                if (!exclude.isEmpty()) {
                    sb.append(", ");
                    Generator.emitTypeCollection(sb, params, one);
                    sb.append(", ");
                    Generator.emitTypeCollection(sb, params, exclude);
                } else if (!one.isEmpty()) {
                    sb.append(", ");
                    Generator.emitTypeCollection(sb, params, one);
                }
                sb.append(" )");
                method.addStatement(sb.toString(), params.toArray());
            }
            builder.addMethod(method.build());
        }
    }

    private static void emitTypeCollection(@Nonnull StringBuilder sb, @Nonnull List<Object> params, @Nonnull List<TypeName> typeNames) {
        if (typeNames.isEmpty()) {
            sb.append("$T.emptyList()");
            params.add(Collections.class);
        } else if (1 == typeNames.size()) {
            sb.append("$T.singleton( $T.class )");
            params.add(Collections.class);
            params.add(typeNames.get(0));
        } else {
            sb.append("$T.asList( ");
            params.add(Arrays.class);
            sb.append(typeNames.stream().map(t -> "$T.class").collect(Collectors.joining(",")));
            params.addAll(typeNames);
            sb.append(" )");
        }
    }

    private static void emitOnActivate(@Nonnull SubSystemDescriptor descriptor, @Nonnull TypeSpec.Builder builder) {
        if (!descriptor.getOnActivates().isEmpty() || !descriptor.getEntityProcessors().isEmpty()) {
            MethodSpec.Builder method = MethodSpec.methodBuilder(ON_ACTIVATE_METHOD).addModifiers(Modifier.PRIVATE);
            for (EntityProcessorDescriptor entityProcessorDescriptor : descriptor.getEntityProcessors()) {
                String name = entityProcessorDescriptor.getMethod().getSimpleName().toString();
                method.addStatement("assert null == $N", FRAMEWORK_SUBSCRIPTION_PREFIX + name);
                method.addStatement("$N = $N.$N().createSubscription( $T.areNamesEnabled() ? $N() : null, $N )", FRAMEWORK_SUBSCRIPTION_PREFIX + name, OUTER_FIELD, WORLD_ACCESSOR_METHOD, GALDR_CLASSNAME, NAME_ACCESSOR_METHOD, FRAMEWORK_AREA_OF_INTEREST_PREFIX + name);
            }
            for (ExecutableElement onActivate : descriptor.getOnActivates()) {
                method.addStatement("$N()", onActivate.getSimpleName().toString());
            }
            builder.addMethod(method.build());
        }
    }

    private static void emitOnDeactivate(@Nonnull SubSystemDescriptor descriptor, @Nonnull TypeSpec.Builder builder) {
        if (!descriptor.getOnDeactivates().isEmpty() || !descriptor.getEntityProcessors().isEmpty()) {
            MethodSpec.Builder method = MethodSpec.methodBuilder(ON_DEACTIVATE_METHOD).addModifiers(Modifier.PRIVATE);
            for (ExecutableElement onDeactivate : descriptor.getOnDeactivates()) {
                method.addStatement("$N()", onDeactivate.getSimpleName().toString());
            }
            for (EntityProcessorDescriptor entityProcessorDescriptor : descriptor.getEntityProcessors()) {
                String name = FRAMEWORK_SUBSCRIPTION_PREFIX + entityProcessorDescriptor.getMethod().getSimpleName().toString();
                method.addStatement("assert null != $N", name);
                method.addStatement("$N.dispose()", name);
                method.addStatement("$N = null", name);
            }
            builder.addMethod(method.build());
        }
    }

    private static void emitProcess(@Nonnull SubSystemDescriptor descriptor, @Nonnull TypeSpec.Builder builder) {
        if (!descriptor.getProcessors().isEmpty() || !descriptor.getEntityProcessors().isEmpty()) {
            MethodSpec.Builder method = MethodSpec.methodBuilder(PROCESS_METHOD).addParameter(TypeName.INT, "delta", Modifier.FINAL).addModifiers(Modifier.PRIVATE);
            for (ExecutableElement process : descriptor.getProcessors()) {
                if (process.getParameters().isEmpty()) {
                    method.addStatement("$N()", process.getSimpleName().toString());
                    continue;
                }
                method.addStatement("$N( delta )", process.getSimpleName().toString());
            }
            for (EntityProcessorDescriptor entityProcessorDescriptor : descriptor.getEntityProcessors()) {
                ExecutableElement sourceMethod = entityProcessorDescriptor.getMethod();
                String name = sourceMethod.getSimpleName().toString();
                String subscriptionFieldName = FRAMEWORK_SUBSCRIPTION_PREFIX + name;
                String entityId = subscriptionFieldName + "_entityId";
                method.addStatement("assert null != $N", subscriptionFieldName);
                method.addStatement("$N.beginIteration()", subscriptionFieldName);
                method.addStatement("int $N", entityId);
                CodeBlock.Builder block = CodeBlock.builder();
                block.beginControlFlow("while ( -1 != ( $N = $N.nextEntity() ) )", entityId, subscriptionFieldName);
                if (1 == sourceMethod.getParameters().size()) {
                    block.addStatement("$N( $N )", name, entityId);
                } else {
                    block.addStatement("$N( delta, $N )", name, entityId);
                }
                block.endControlFlow();
                method.addCode(block.build());
            }
            builder.addMethod(method.build());
        }
    }

    private static void emitNativeNameMethod(@Nonnull SubSystemDescriptor descriptor, @Nonnull TypeSpec.Builder builder) {
        builder.addMethod(MethodSpec.methodBuilder(NAME_ACCESSOR_METHOD).addAnnotation(NONNULL_CLASSNAME).addModifiers(Modifier.PRIVATE).returns((Type)((Object)String.class)).addStatement("return $S", descriptor.getName()).build());
    }

    private static void emitToString(@Nonnull TypeSpec.Builder builder) {
        CodeBlock.Builder toStringBlock = CodeBlock.builder();
        toStringBlock.beginControlFlow("if ( $T.areDebugToStringMethodsEnabled() )", GALDR_CLASSNAME);
        toStringBlock.addStatement("return $S + $N() + $S", "SubSystem[", NAME_ACCESSOR_METHOD, "]");
        toStringBlock.nextControlFlow("else", new Object[0]);
        toStringBlock.addStatement("return super.toString()", new Object[0]);
        toStringBlock.endControlFlow();
        builder.addMethod(MethodSpec.methodBuilder("toString").addAnnotation(NONNULL_CLASSNAME).addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns((Type)((Object)String.class)).addCode(toStringBlock.build()).build());
    }

    @Nonnull
    static ClassName toGeneratedClassName(@Nonnull TypeElement element) {
        return GeneratorUtil.getGeneratedClassName(element, "Galdr_", "");
    }
}

