/*
 * Decompiled with CFR 0.152.
 */
package galdr.processor;

import galdr.processor.AbstractDescriptor;
import galdr.processor.ComponentManagerRefDescriptor;
import galdr.processor.EntityProcessorDescriptor;
import galdr.processor.vendor.javapoet.ClassName;
import galdr.processor.vendor.javapoet.TypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

final class SubSystemDescriptor
extends AbstractDescriptor {
    @Nonnull
    private final String _name;
    @Nonnull
    private final List<ComponentManagerRefDescriptor> _componentManagerRefs = new ArrayList<ComponentManagerRefDescriptor>();
    @Nonnull
    private final List<EntityProcessorDescriptor> _entityProcessors = new ArrayList<EntityProcessorDescriptor>();
    @Nonnull
    private final List<ExecutableElement> _nameRefs = new ArrayList<ExecutableElement>();
    @Nonnull
    private final List<ExecutableElement> _onActivates = new ArrayList<ExecutableElement>();
    @Nonnull
    private final List<ExecutableElement> _onDeactivates = new ArrayList<ExecutableElement>();
    @Nonnull
    private final List<ExecutableElement> _processors = new ArrayList<ExecutableElement>();
    @Nonnull
    private final List<ExecutableElement> _worldRefs = new ArrayList<ExecutableElement>();

    SubSystemDescriptor(@Nonnull TypeElement element, @Nonnull String name) {
        super(element);
        this._name = Objects.requireNonNull(name);
    }

    @Nonnull
    String getName() {
        return this._name;
    }

    void addComponentManagerRef(@Nonnull ExecutableElement method, @Nonnull ClassName componentType) {
        this._componentManagerRefs.add(new ComponentManagerRefDescriptor(method, componentType));
    }

    @Nonnull
    List<ComponentManagerRefDescriptor> getComponentManagerRefs() {
        return this._componentManagerRefs;
    }

    void addNameRef(@Nonnull ExecutableElement method) {
        this._nameRefs.add(Objects.requireNonNull(method));
    }

    @Nonnull
    List<ExecutableElement> getNameRefs() {
        return this._nameRefs;
    }

    void addEntityProcessor(@Nonnull ExecutableElement method, @Nonnull List<TypeName> all, @Nonnull List<TypeName> one, @Nonnull List<TypeName> exclude) {
        this._entityProcessors.add(new EntityProcessorDescriptor(method, all, one, exclude));
    }

    @Nonnull
    List<EntityProcessorDescriptor> getEntityProcessors() {
        return this._entityProcessors;
    }

    void addOnActivate(@Nonnull ExecutableElement method) {
        this._onActivates.add(Objects.requireNonNull(method));
    }

    @Nonnull
    List<ExecutableElement> getOnActivates() {
        return this._onActivates;
    }

    void addOnDeactivate(@Nonnull ExecutableElement method) {
        this._onDeactivates.add(Objects.requireNonNull(method));
    }

    @Nonnull
    List<ExecutableElement> getOnDeactivates() {
        return this._onDeactivates;
    }

    void addProcessor(@Nonnull ExecutableElement method) {
        this._processors.add(Objects.requireNonNull(method));
    }

    @Nonnull
    List<ExecutableElement> getProcessors() {
        return this._processors;
    }

    void addWorldRef(@Nonnull ExecutableElement method) {
        this._worldRefs.add(Objects.requireNonNull(method));
    }

    @Nonnull
    List<ExecutableElement> getWorldRefs() {
        return this._worldRefs;
    }
}

