/*
 * Decompiled with CFR 0.152.
 */
package galdr.processor;

import galdr.processor.AbstractGaldrProcessor;
import galdr.processor.Generator;
import galdr.processor.SubSystemDescriptor;
import galdr.processor.vendor.javapoet.ClassName;
import galdr.processor.vendor.javapoet.ParameterizedTypeName;
import galdr.processor.vendor.javapoet.TypeName;
import galdr.processor.vendor.proton.AnnotationsUtil;
import galdr.processor.vendor.proton.ElementsUtil;
import galdr.processor.vendor.proton.MemberChecks;
import galdr.processor.vendor.proton.ProcessorException;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

@SupportedAnnotationTypes(value={"galdr.annotations.GaldrSubSystem"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedOptions(value={"galdr.defer.errors", "galdr.defer.unresolved"})
public final class SubSystemProcessor
extends AbstractGaldrProcessor {
    @Nonnull
    protected Set<TypeElement> getTypeElementsToProcess(@Nonnull RoundEnvironment env) {
        TypeElement annotation = this.processingEnv.getElementUtils().getTypeElement("galdr.annotations.GaldrSubSystem");
        return env.getElementsAnnotatedWith(annotation);
    }

    @Override
    protected final void process(@Nonnull TypeElement element) throws IOException, ProcessorException {
        if (ElementKind.CLASS != element.getKind()) {
            throw new ProcessorException(MemberChecks.must("galdr.annotations.GaldrSubSystem", "be a class"), element);
        }
        if (!element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            throw new ProcessorException(MemberChecks.must("galdr.annotations.GaldrSubSystem", "be abstract"), element);
        }
        if (NestingKind.TOP_LEVEL != element.getNestingKind() && !element.getModifiers().contains((Object)Modifier.STATIC)) {
            String message = MemberChecks.mustNot("galdr.annotations.GaldrSubSystem", "be a non-static nested class");
            throw new ProcessorException(message, element);
        }
        AnnotationMirror annotation = AnnotationsUtil.getAnnotationByType(element, "galdr.annotations.GaldrSubSystem");
        String name = this.deriveName(element, annotation);
        SubSystemDescriptor descriptor = new SubSystemDescriptor(element, name);
        List<ExecutableElement> constructors = ElementsUtil.getConstructors(element);
        if (constructors.size() > 1) {
            String message = MemberChecks.must("galdr.annotations.GaldrSubSystem", "have no more than one constructor");
            throw new ProcessorException(message, element);
        }
        if (!constructors.isEmpty() && constructors.get(0).getModifiers().contains((Object)Modifier.PRIVATE)) {
            String message = MemberChecks.mustNot("galdr.annotations.GaldrSubSystem", "have a private constructor");
            throw new ProcessorException(message, element);
        }
        List<ExecutableElement> methods = ElementsUtil.getMethods(element, this.processingEnv.getElementUtils(), this.processingEnv.getTypeUtils());
        for (ExecutableElement method : methods) {
            AnnotationMirror componentManagerRef = AnnotationsUtil.findAnnotationByType(method, "galdr.annotations.ComponentManagerRef");
            AnnotationMirror entityProcessor = AnnotationsUtil.findAnnotationByType(method, "galdr.annotations.EntityProcessor");
            AnnotationMirror nameRef = AnnotationsUtil.findAnnotationByType(method, "galdr.annotations.NameRef");
            AnnotationMirror onActivate = AnnotationsUtil.findAnnotationByType(method, "galdr.annotations.OnActivate");
            AnnotationMirror onDeactivate = AnnotationsUtil.findAnnotationByType(method, "galdr.annotations.OnDeactivate");
            AnnotationMirror processor = AnnotationsUtil.findAnnotationByType(method, "galdr.annotations.Processor");
            AnnotationMirror worldRef = AnnotationsUtil.findAnnotationByType(method, "galdr.annotations.WorldRef");
            if (null != componentManagerRef) {
                this.addComponentManagerRef(descriptor, method);
                continue;
            }
            if (null != entityProcessor) {
                this.addEntityProcessor(descriptor, method);
                continue;
            }
            if (null != nameRef) {
                this.addNameRef(descriptor, method);
                continue;
            }
            if (null != onActivate) {
                this.addOnActivate(descriptor, method);
                continue;
            }
            if (null != onDeactivate) {
                this.addOnDeactivate(descriptor, method);
                continue;
            }
            if (null != processor) {
                this.addProcessor(descriptor, method);
                continue;
            }
            if (null == worldRef) continue;
            this.addWorldRef(descriptor, method);
        }
        this.emitTypeSpec(descriptor.getPackageName(), Generator.buildSubSystem(this.processingEnv, descriptor));
    }

    private void addComponentManagerRef(@Nonnull SubSystemDescriptor descriptor, @Nonnull ExecutableElement method) {
        this.mustBeRefMethod(descriptor, method, "galdr.annotations.ComponentManagerRef");
        TypeMirror returnType = method.getReturnType();
        TypeName typeName = TypeName.get(returnType);
        if (!(typeName instanceof ParameterizedTypeName)) {
            throw this.newBadBadComponentManagerRefTypeException(method);
        }
        ParameterizedTypeName parameterizedTypeName = (ParameterizedTypeName)typeName;
        if (!parameterizedTypeName.rawType.toString().equals("galdr.ComponentManager")) {
            throw this.newBadBadComponentManagerRefTypeException(method);
        }
        TypeName typeArgument = parameterizedTypeName.typeArguments.get(0);
        if (!(typeArgument instanceof ClassName)) {
            throw this.newBadBadComponentManagerRefTypeException(method);
        }
        ClassName componentType = (ClassName)typeArgument;
        descriptor.addComponentManagerRef(method, componentType);
    }

    @Nonnull
    private ProcessorException newBadBadComponentManagerRefTypeException(@Nonnull ExecutableElement method) {
        return new ProcessorException("@ComponentManagerRef target must return the type galdr.ComponentManager parameterized with the desired component type", method);
    }

    private void addEntityProcessor(@Nonnull SubSystemDescriptor descriptor, @Nonnull ExecutableElement method) {
        this.mustBeLifecycleMethod(descriptor, method, "galdr.annotations.EntityProcessor");
        List<? extends VariableElement> parameters = method.getParameters();
        if (parameters.isEmpty() || parameters.size() > 2 || parameters.stream().anyMatch(p -> TypeKind.INT != p.asType().getKind())) {
            throw new ProcessorException(MemberChecks.must("galdr.annotations.EntityProcessor", "have one or two integer parameters"), method);
        }
        List<TypeName> all = this.getTypeNameParameterValue(method, "all");
        List<TypeName> one = this.getTypeNameParameterValue(method, "one");
        List<TypeName> exclude = this.getTypeNameParameterValue(method, "exclude");
        for (TypeName candidate : all) {
            for (TypeName a : all) {
                if (a == candidate || !a.equals(candidate)) continue;
                throw new ProcessorException("@EntityProcessor target contains the component of type " + candidate + " multiple times in the 'all' requirement", method);
            }
            if (one.contains(candidate)) {
                throw new ProcessorException("@EntityProcessor target contains the component of type " + candidate + " in the 'all' requirement and the 'one' requirement", method);
            }
            if (!exclude.contains(candidate)) continue;
            throw new ProcessorException("@EntityProcessor target contains the component of type " + candidate + " in the 'all' requirement and the 'exclude' requirement", method);
        }
        for (TypeName candidate : one) {
            for (TypeName a : one) {
                if (a == candidate || !a.equals(candidate)) continue;
                throw new ProcessorException("@EntityProcessor target contains the component of type " + candidate + " multiple times in the 'one' requirement", method);
            }
            if (!exclude.contains(candidate)) continue;
            throw new ProcessorException("@EntityProcessor target contains the component of type " + candidate + " in the 'one' requirement and the 'exclude' requirement", method);
        }
        for (TypeName candidate : exclude) {
            for (TypeName a : exclude) {
                if (a == candidate || !a.equals(candidate)) continue;
                throw new ProcessorException("@EntityProcessor target contains the component of type " + candidate + " multiple times in the 'exclude' requirement", method);
            }
        }
        if (all.isEmpty() && one.isEmpty() && exclude.isEmpty()) {
            throw new ProcessorException("@EntityProcessor target must specify at least one component in the 'all', 'one' or 'exclude' requirements", method);
        }
        if (1 == one.size()) {
            throw new ProcessorException("@EntityProcessor target must have multiple components in the 'one' requirement or alternatively the component should be moved to the 'all' requirement", method);
        }
        descriptor.addEntityProcessor(method, all, one, exclude);
    }

    @Nonnull
    private List<TypeName> getTypeNameParameterValue(@Nonnull ExecutableElement method, @Nonnull String parameterName) {
        return AnnotationsUtil.getTypeMirrorsAnnotationParameter(method, "galdr.annotations.EntityProcessor", parameterName).stream().map(TypeName::get).collect(Collectors.toList());
    }

    private void addNameRef(@Nonnull SubSystemDescriptor descriptor, @Nonnull ExecutableElement method) {
        this.mustBeRefMethod(descriptor, method, "galdr.annotations.NameRef");
        MemberChecks.mustReturnAnInstanceOf(this.processingEnv, method, "galdr.annotations.NameRef", String.class.getName());
        descriptor.addNameRef(method);
    }

    private void addOnActivate(@Nonnull SubSystemDescriptor descriptor, @Nonnull ExecutableElement method) {
        this.mustBeLifecycleMethod(descriptor, method, "galdr.annotations.OnActivate");
        MemberChecks.mustNotHaveAnyParameters("galdr.annotations.OnActivate", method);
        descriptor.addOnActivate(method);
    }

    private void addOnDeactivate(@Nonnull SubSystemDescriptor descriptor, @Nonnull ExecutableElement method) {
        this.mustBeLifecycleMethod(descriptor, method, "galdr.annotations.OnDeactivate");
        MemberChecks.mustNotHaveAnyParameters("galdr.annotations.OnDeactivate", method);
        descriptor.addOnDeactivate(method);
    }

    private void addProcessor(@Nonnull SubSystemDescriptor descriptor, @Nonnull ExecutableElement method) {
        this.mustBeLifecycleMethod(descriptor, method, "galdr.annotations.Processor");
        List<? extends VariableElement> parameters = method.getParameters();
        if (parameters.size() > 1 || 1 == parameters.size() && TypeKind.INT != parameters.get(0).asType().getKind()) {
            throw new ProcessorException(MemberChecks.must("galdr.annotations.Processor", "have zero parameters or a single integer parameter"), method);
        }
        descriptor.addProcessor(method);
    }

    private void addWorldRef(@Nonnull SubSystemDescriptor descriptor, @Nonnull ExecutableElement method) {
        this.mustBeRefMethod(descriptor, method, "galdr.annotations.WorldRef");
        MemberChecks.mustReturnAnInstanceOf(this.processingEnv, method, "galdr.annotations.WorldRef", "galdr.World");
        descriptor.addWorldRef(method);
    }

    private void mustBeLifecycleMethod(@Nonnull SubSystemDescriptor descriptor, @Nonnull ExecutableElement method, @Nonnull String annotationClassname) {
        MemberChecks.mustNotBeAbstract(annotationClassname, method);
        MemberChecks.mustNotBePrivate(annotationClassname, method);
        MemberChecks.mustNotBeStatic(annotationClassname, method);
        TypeElement typeElement = descriptor.getElement();
        MemberChecks.mustNotBePackageAccessInDifferentPackage(typeElement, "galdr.annotations.GaldrSubSystem", annotationClassname, method);
        MemberChecks.mustNotReturnAnyValue(annotationClassname, method);
        MemberChecks.mustNotThrowAnyExceptions(annotationClassname, method);
        MemberChecks.shouldBeInternalMethod(this.processingEnv, typeElement, method, annotationClassname, "Galdr:PublicLifecycleMethod", "Galdr:ProtectedLifecycleMethod", "galdr.annotations.SuppressGaldrWarnings");
    }

    private void mustBeRefMethod(@Nonnull SubSystemDescriptor descriptor, @Nonnull ExecutableElement method, @Nonnull String annotationClassname) {
        MemberChecks.mustBeAbstract(annotationClassname, method);
        TypeElement typeElement = descriptor.getElement();
        MemberChecks.mustNotBePackageAccessInDifferentPackage(typeElement, "galdr.annotations.GaldrSubSystem", annotationClassname, method);
        MemberChecks.mustNotHaveAnyParameters(annotationClassname, method);
        MemberChecks.mustReturnAValue(annotationClassname, method);
        MemberChecks.mustNotThrowAnyExceptions(annotationClassname, method);
        MemberChecks.shouldBeInternalMethod(this.processingEnv, typeElement, method, annotationClassname, "Galdr:PublicRefMethod", "Galdr:ProtectedRefMethod", "galdr.annotations.SuppressGaldrWarnings");
    }

    @Nonnull
    private String deriveName(@Nonnull TypeElement element, @Nonnull AnnotationMirror annotation) throws ProcessorException {
        String name = (String)AnnotationsUtil.getAnnotationValue(annotation, "name");
        return "<default>".equals(name) ? element.getSimpleName().toString() : name;
    }
}

