/*
 * Decompiled with CFR 0.152.
 */
package galdr.processor.vendor.javapoet;

import galdr.processor.vendor.javapoet.Util;
import java.io.IOException;

final class LineWrapper {
    private final Appendable out;
    private final String indent;
    private final int columnLimit;
    private boolean closed;
    private final StringBuilder buffer = new StringBuilder();
    private int column = 0;
    private int indentLevel = -1;
    private FlushType nextFlush;

    LineWrapper(Appendable out, String indent, int columnLimit) {
        Util.checkNotNull(out, "out == null", new Object[0]);
        this.out = out;
        this.indent = indent;
        this.columnLimit = columnLimit;
    }

    void append(String s) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        if (this.nextFlush != null) {
            int nextNewline = s.indexOf(10);
            if (nextNewline == -1 && this.column + s.length() <= this.columnLimit) {
                this.buffer.append(s);
                this.column += s.length();
                return;
            }
            boolean wrap = nextNewline == -1 || this.column + nextNewline > this.columnLimit;
            this.flush(wrap ? FlushType.WRAP : this.nextFlush);
        }
        this.out.append(s);
        int lastNewline = s.lastIndexOf(10);
        this.column = lastNewline != -1 ? s.length() - lastNewline - 1 : this.column + s.length();
    }

    void wrappingSpace(int indentLevel) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        if (this.nextFlush != null) {
            this.flush(this.nextFlush);
        }
        ++this.column;
        this.nextFlush = FlushType.SPACE;
        this.indentLevel = indentLevel;
    }

    void zeroWidthSpace(int indentLevel) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        if (this.column == 0) {
            return;
        }
        if (this.nextFlush != null) {
            this.flush(this.nextFlush);
        }
        this.nextFlush = FlushType.EMPTY;
        this.indentLevel = indentLevel;
    }

    void close() throws IOException {
        if (this.nextFlush != null) {
            this.flush(this.nextFlush);
        }
        this.closed = true;
    }

    private void flush(FlushType flushType) throws IOException {
        switch (flushType) {
            case WRAP: {
                this.out.append('\n');
                for (int i = 0; i < this.indentLevel; ++i) {
                    this.out.append(this.indent);
                }
                this.column = this.indentLevel * this.indent.length();
                this.column += this.buffer.length();
                break;
            }
            case SPACE: {
                this.out.append(' ');
                break;
            }
            case EMPTY: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown FlushType: " + (Object)((Object)flushType));
            }
        }
        this.out.append(this.buffer);
        this.buffer.delete(0, this.buffer.length());
        this.indentLevel = -1;
        this.nextFlush = null;
    }

    private static enum FlushType {
        WRAP,
        SPACE,
        EMPTY;

    }
}

