/*
 * Decompiled with CFR 0.152.
 */
package galdr.processor.vendor.proton;

import galdr.processor.vendor.proton.AnnotationsUtil;
import galdr.processor.vendor.proton.ElementsUtil;
import galdr.processor.vendor.proton.GeneratorUtil;
import galdr.processor.vendor.proton.ProcessorException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

public final class MemberChecks {
    private MemberChecks() {
    }

    public static void mustBeWrappable(@Nonnull TypeElement targetType, @Nonnull String scopeAnnotationName, @Nonnull String annotationName, @Nonnull Element element) throws ProcessorException {
        MemberChecks.mustBeOverridable(targetType, scopeAnnotationName, annotationName, element);
        MemberChecks.mustNotBeAbstract(annotationName, element);
    }

    public static void mustBeOverridable(@Nonnull TypeElement targetType, @Nonnull String scopeAnnotationName, @Nonnull String annotationName, @Nonnull Element element) throws ProcessorException {
        MemberChecks.mustNotBeFinal(annotationName, element);
        MemberChecks.mustBeSubclassCallable(targetType, scopeAnnotationName, annotationName, element);
    }

    public static void mustBeSubclassCallable(@Nonnull TypeElement targetType, @Nonnull String scopeAnnotationName, @Nonnull String annotationName, @Nonnull Element element) throws ProcessorException {
        MemberChecks.mustNotBeStatic(annotationName, element);
        MemberChecks.mustNotBePrivate(annotationName, element);
        MemberChecks.mustNotBePackageAccessInDifferentPackage(targetType, scopeAnnotationName, annotationName, element);
    }

    public static void mustBeStaticallySubclassCallable(@Nonnull TypeElement targetType, @Nonnull String scopeAnnotationName, @Nonnull String annotationName, @Nonnull Element method) throws ProcessorException {
        MemberChecks.mustBeStatic(annotationName, method);
        MemberChecks.mustNotBePrivate(annotationName, method);
        MemberChecks.mustNotBePackageAccessInDifferentPackage(targetType, scopeAnnotationName, annotationName, method);
    }

    public static void mustBeLifecycleHook(@Nonnull TypeElement targetType, @Nonnull String scopeAnnotationName, @Nonnull String annotationName, @Nonnull ExecutableElement method) throws ProcessorException {
        MemberChecks.mustNotBeAbstract(annotationName, method);
        MemberChecks.mustBeSubclassCallable(targetType, scopeAnnotationName, annotationName, method);
        MemberChecks.mustNotHaveAnyParameters(annotationName, method);
        MemberChecks.mustNotReturnAnyValue(annotationName, method);
        MemberChecks.mustNotThrowAnyExceptions(annotationName, method);
    }

    public static void mustBeStatic(@Nonnull String annotationName, @Nonnull Element element) throws ProcessorException {
        if (!element.getModifiers().contains((Object)Modifier.STATIC)) {
            throw new ProcessorException(MemberChecks.must(annotationName, "be static"), element);
        }
    }

    public static void mustNotBeStatic(@Nonnull String annotationName, @Nonnull Element element) throws ProcessorException {
        if (element.getModifiers().contains((Object)Modifier.STATIC)) {
            throw new ProcessorException(MemberChecks.mustNot(annotationName, "be static"), element);
        }
    }

    public static void mustBeAbstract(@Nonnull String annotationName, @Nonnull Element element) throws ProcessorException {
        if (!element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            throw new ProcessorException(MemberChecks.must(annotationName, "be abstract"), element);
        }
    }

    public static void mustNotBeAbstract(@Nonnull String annotationName, @Nonnull Element element) throws ProcessorException {
        if (element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            throw new ProcessorException(MemberChecks.mustNot(annotationName, "be abstract"), element);
        }
    }

    public static void mustBeFinal(@Nonnull String annotationName, @Nonnull Element element) throws ProcessorException {
        if (!element.getModifiers().contains((Object)Modifier.FINAL)) {
            throw new ProcessorException(MemberChecks.must(annotationName, "be final"), element);
        }
    }

    public static void mustNotBeFinal(@Nonnull String annotationName, @Nonnull Element element) throws ProcessorException {
        if (element.getModifiers().contains((Object)Modifier.FINAL)) {
            throw new ProcessorException(MemberChecks.mustNot(annotationName, "be final"), element);
        }
    }

    public static void mustBePublic(@Nonnull String annotationName, @Nonnull Element element) throws ProcessorException {
        if (!element.getModifiers().contains((Object)Modifier.PUBLIC)) {
            throw new ProcessorException(MemberChecks.must(annotationName, "be public"), element);
        }
    }

    public static void mustNotBePublic(@Nonnull String annotationName, @Nonnull Element element) throws ProcessorException {
        if (element.getModifiers().contains((Object)Modifier.PUBLIC)) {
            throw new ProcessorException(MemberChecks.mustNot(annotationName, "be public"), element);
        }
    }

    public static void mustBePrivate(@Nonnull String annotationName, @Nonnull Element element) throws ProcessorException {
        if (!element.getModifiers().contains((Object)Modifier.PRIVATE)) {
            throw new ProcessorException(MemberChecks.must(annotationName, "be private"), element);
        }
    }

    public static void mustNotBePrivate(@Nonnull String annotationName, @Nonnull Element element) throws ProcessorException {
        if (element.getModifiers().contains((Object)Modifier.PRIVATE)) {
            throw new ProcessorException(MemberChecks.mustNot(annotationName, "be private"), element);
        }
    }

    public static void mustNotBePackageAccessInDifferentPackage(@Nonnull TypeElement element, @Nonnull String scopeAnnotationName, @Nonnull String annotationName, @Nonnull Element other) throws ProcessorException {
        boolean isPackageAccess;
        Set<Modifier> modifiers = other.getModifiers();
        boolean bl = isPackageAccess = !modifiers.contains((Object)Modifier.PRIVATE) && !modifiers.contains((Object)Modifier.PROTECTED) && !modifiers.contains((Object)Modifier.PUBLIC);
        if (isPackageAccess && GeneratorUtil.areTypesInDifferentPackage(element, (TypeElement)other.getEnclosingElement())) {
            throw new ProcessorException(MemberChecks.mustNot(annotationName, "be package access if the " + (other instanceof ExecutableElement ? "method" : "field") + " is in a different package from the type annotated with the " + MemberChecks.toSimpleName(scopeAnnotationName) + " annotation"), other);
        }
    }

    public static void mustNotHaveAnyParameters(@Nonnull String annotationName, @Nonnull ExecutableElement method) throws ProcessorException {
        if (!method.getParameters().isEmpty()) {
            throw new ProcessorException(MemberChecks.mustNot(annotationName, "have any parameters"), method);
        }
    }

    public static void mustNotReturnAnyValue(@Nonnull String annotationName, @Nonnull ExecutableElement method) throws ProcessorException {
        if (TypeKind.VOID != method.getReturnType().getKind()) {
            throw new ProcessorException(MemberChecks.mustNot(annotationName, "return a value"), method);
        }
    }

    public static void mustReturnAValue(@Nonnull String annotationName, @Nonnull ExecutableElement method) throws ProcessorException {
        if (TypeKind.VOID == method.getReturnType().getKind()) {
            throw new ProcessorException(MemberChecks.must(annotationName, "return a value"), method);
        }
    }

    public static void mustNotThrowAnyExceptions(@Nonnull String annotationName, @Nonnull ExecutableElement method) throws ProcessorException {
        if (!method.getThrownTypes().isEmpty()) {
            throw new ProcessorException(MemberChecks.mustNot(annotationName, "throw any exceptions"), method);
        }
    }

    public static void verifyNoOverlappingAnnotations(@Nonnull Element element, @Nonnull Collection<String> annotations, @Nonnull Map<String, Collection<String>> exceptions) throws ProcessorException {
        String[] annotationTypes = annotations.toArray(new String[0]);
        for (int i = 0; i < annotationTypes.length; ++i) {
            String type1 = annotationTypes[i];
            AnnotationMirror annotation1 = AnnotationsUtil.findAnnotationByType(element, type1);
            if (null == annotation1) continue;
            for (int j = i + 1; j < annotationTypes.length; ++j) {
                AnnotationMirror annotation2;
                String type2 = annotationTypes[j];
                if (MemberChecks.isException(exceptions, type1, type2) || null == (annotation2 = AnnotationsUtil.findAnnotationByType(element, type2))) continue;
                String message = "Method can not be annotated with both " + MemberChecks.toSimpleName(type1) + " and " + MemberChecks.toSimpleName(type2);
                throw new ProcessorException(message, element);
            }
        }
    }

    private static boolean isException(@Nonnull Map<String, Collection<String>> exceptions, @Nonnull String type1, @Nonnull String type2) {
        return exceptions.containsKey(type1) && exceptions.get(type1).contains(type2) || exceptions.containsKey(type2) && exceptions.get(type2).contains(type1);
    }

    @Nonnull
    public static String must(@Nonnull String annotationName, @Nonnull String message) {
        return MemberChecks.toSimpleName(annotationName) + " target must " + message;
    }

    @Nonnull
    public static String mustNot(@Nonnull String annotationName, @Nonnull String message) {
        return MemberChecks.must(annotationName, "not " + message);
    }

    @Nonnull
    public static String toSimpleName(@Nonnull String annotationName) {
        return "@" + annotationName.replaceAll(".*\\.", "");
    }

    @Nonnull
    public static String suppressedBy(@Nonnull String warning, @Nullable String alternativeSuppressWarnings) {
        return "This warning can be suppressed by annotating the element with @SuppressWarnings( \"" + warning + "\" )" + (null == alternativeSuppressWarnings ? "" : " or " + MemberChecks.toSimpleName(alternativeSuppressWarnings) + "( \"" + warning + "\" )");
    }

    public static void shouldNotBePublic(@Nonnull ProcessingEnvironment processingEnv, @Nonnull ExecutableElement method, @Nonnull String annotationName, @Nonnull String warning, @Nullable String alternativeSuppressWarnings) {
        if (method.getModifiers().contains((Object)Modifier.PUBLIC) && ElementsUtil.isWarningNotSuppressed(method, warning, alternativeSuppressWarnings)) {
            String message = MemberChecks.toSimpleName(annotationName) + " target should not be public. " + MemberChecks.suppressedBy(warning, alternativeSuppressWarnings);
            processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, message, method);
        }
    }

    public static void shouldNotBeProtected(@Nonnull ProcessingEnvironment processingEnv, @Nonnull ExecutableElement method, @Nonnull String annotationName, @Nonnull String warning, @Nullable String alternativeSuppressWarnings) {
        if (method.getModifiers().contains((Object)Modifier.PROTECTED) && ElementsUtil.isWarningNotSuppressed(method, warning, alternativeSuppressWarnings)) {
            String message = MemberChecks.toSimpleName(annotationName) + " target should not be protected. " + MemberChecks.suppressedBy(warning, alternativeSuppressWarnings);
            processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, message, method);
        }
    }

    public static void mustReturnAnInstanceOf(@Nonnull ProcessingEnvironment processingEnv, @Nonnull ExecutableElement method, @Nonnull String annotationClassname, @Nonnull String expectedTypename) {
        TypeElement typeElement = processingEnv.getElementUtils().getTypeElement(expectedTypename);
        assert (null != typeElement);
        TypeMirror expected = typeElement.asType();
        TypeMirror actual = method.getReturnType();
        if (!processingEnv.getTypeUtils().isSameType(actual, expected)) {
            String message = MemberChecks.must(annotationClassname, "return an instance of " + expected);
            throw new ProcessorException(message, method);
        }
    }

    public static void shouldBeInternalMethod(@Nonnull ProcessingEnvironment processingEnv, @Nonnull TypeElement typeElement, @Nonnull ExecutableElement method, @Nonnull String annotationClassname, @Nonnull String publicWarning, @Nonnull String protectedWarning, @Nullable String alternativeSuppressWarnings) {
        if (MemberChecks.doesMethodNotOverrideInterfaceMethod(processingEnv, typeElement, method)) {
            MemberChecks.shouldNotBePublic(processingEnv, method, annotationClassname, publicWarning, alternativeSuppressWarnings);
        }
        if (Objects.equals(typeElement, method.getEnclosingElement())) {
            MemberChecks.shouldNotBeProtected(processingEnv, method, annotationClassname, protectedWarning, alternativeSuppressWarnings);
        }
    }

    private static boolean doesMethodNotOverrideInterfaceMethod(@Nonnull ProcessingEnvironment processingEnv, @Nonnull TypeElement typeElement, @Nonnull ExecutableElement method) {
        return !ElementsUtil.doesMethodOverrideInterfaceMethod(processingEnv.getTypeUtils(), typeElement, method);
    }
}

