/*
 * Decompiled with CFR 0.152.
 */
package galdr.processor.vendor.proton;

import com.sun.tools.javac.code.Symbol;
import galdr.processor.vendor.javapoet.ParameterizedTypeName;
import galdr.processor.vendor.javapoet.TypeName;
import galdr.processor.vendor.proton.AnnotationsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public final class ElementsUtil {
    private ElementsUtil() {
    }

    public static boolean isWarningNotSuppressed(@Nonnull Element element, @Nonnull String warning) {
        return !ElementsUtil.isWarningSuppressed(element, warning);
    }

    public static boolean isWarningNotSuppressed(@Nonnull Element element, @Nonnull String warning, @Nullable String alternativeSuppressWarnings) {
        return !ElementsUtil.isWarningSuppressed(element, warning, alternativeSuppressWarnings);
    }

    public static boolean isWarningSuppressed(@Nonnull Element element, @Nonnull String warning) {
        return ElementsUtil.isWarningSuppressed(element, warning, null);
    }

    public static boolean isWarningSuppressed(@Nonnull Element element, @Nonnull String warning, @Nullable String alternativeSuppressWarnings) {
        Element enclosingElement;
        SuppressWarnings annotation;
        String[] value;
        AnnotationMirror suppress;
        if (null != alternativeSuppressWarnings && null != (suppress = AnnotationsUtil.findAnnotationByType(element, alternativeSuppressWarnings)) && null != (value = AnnotationsUtil.findAnnotationValueNoDefaults(suppress, "value"))) {
            List warnings = (List)value.getValue();
            for (AnnotationValue annotationValue : warnings) {
                if (!warning.equals(annotationValue.getValue())) continue;
                return true;
            }
        }
        if (null != (annotation = element.getAnnotation(SuppressWarnings.class))) {
            for (String string : annotation.value()) {
                if (!warning.equals(string)) continue;
                return true;
            }
        }
        return null != (enclosingElement = element.getEnclosingElement()) && ElementsUtil.isWarningSuppressed(enclosingElement, warning, alternativeSuppressWarnings);
    }

    @Nonnull
    public static List<TypeElement> getSuperTypes(@Nonnull TypeElement element) {
        ArrayList<TypeElement> superTypes = new ArrayList<TypeElement>();
        ElementsUtil.enumerateSuperTypes(element, superTypes);
        return superTypes;
    }

    private static void enumerateSuperTypes(@Nonnull TypeElement element, @Nonnull List<TypeElement> superTypes) {
        TypeMirror superclass = element.getSuperclass();
        if (TypeKind.NONE != superclass.getKind()) {
            TypeElement superclassElement = (TypeElement)((DeclaredType)superclass).asElement();
            superTypes.add(superclassElement);
            ElementsUtil.enumerateSuperTypes(superclassElement, superTypes);
        }
        for (TypeMirror typeMirror : element.getInterfaces()) {
            TypeElement interfaceElement = (TypeElement)((DeclaredType)typeMirror).asElement();
            ElementsUtil.enumerateSuperTypes(interfaceElement, superTypes);
        }
    }

    @Nonnull
    public static List<TypeElement> getInterfaces(@Nonnull TypeElement element) {
        ArrayList<TypeElement> superTypes = new ArrayList<TypeElement>();
        ElementsUtil.enumerateInterfaces(element, superTypes);
        return superTypes;
    }

    private static void enumerateInterfaces(@Nonnull TypeElement element, @Nonnull List<TypeElement> superTypes) {
        TypeMirror superclass = element.getSuperclass();
        if (TypeKind.NONE != superclass.getKind()) {
            TypeElement superclassElement = (TypeElement)((DeclaredType)superclass).asElement();
            ElementsUtil.enumerateInterfaces(superclassElement, superTypes);
        }
        for (TypeMirror typeMirror : element.getInterfaces()) {
            TypeElement interfaceElement = (TypeElement)((DeclaredType)typeMirror).asElement();
            superTypes.add(interfaceElement);
            ElementsUtil.enumerateInterfaces(interfaceElement, superTypes);
        }
    }

    @Nonnull
    public static List<VariableElement> getFields(@Nonnull TypeElement element) {
        LinkedHashMap<String, VariableElement> methodMap = new LinkedHashMap<String, VariableElement>();
        ElementsUtil.enumerateFields(element, methodMap);
        return new ArrayList<VariableElement>(methodMap.values());
    }

    private static void enumerateFields(@Nonnull TypeElement element, @Nonnull Map<String, VariableElement> fields) {
        TypeMirror superclass = element.getSuperclass();
        if (TypeKind.NONE != superclass.getKind()) {
            ElementsUtil.enumerateFields((TypeElement)((DeclaredType)superclass).asElement(), fields);
        }
        for (Element element2 : element.getEnclosedElements()) {
            if (ElementKind.FIELD != element2.getKind()) continue;
            fields.put(element2.getSimpleName().toString(), (VariableElement)element2);
        }
    }

    @Nonnull
    public static List<ExecutableElement> getMethods(@Nonnull TypeElement element, @Nonnull Elements elementUtils, @Nonnull Types typeUtils) {
        LinkedHashMap<String, ArrayList<ExecutableElement>> methodMap = new LinkedHashMap<String, ArrayList<ExecutableElement>>();
        ElementsUtil.enumerateMethods(element, elementUtils, typeUtils, element, methodMap);
        return methodMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static void enumerateMethods(@Nonnull TypeElement scope, @Nonnull Elements elementUtils, @Nonnull Types typeUtils, @Nonnull TypeElement element, @Nonnull Map<String, ArrayList<ExecutableElement>> methods) {
        TypeMirror superclass = element.getSuperclass();
        if (TypeKind.NONE != superclass.getKind()) {
            TypeElement superclassElement = (TypeElement)((DeclaredType)superclass).asElement();
            ElementsUtil.enumerateMethods(scope, elementUtils, typeUtils, superclassElement, methods);
        }
        for (TypeMirror typeMirror : element.getInterfaces()) {
            TypeElement interfaceElement = (TypeElement)((DeclaredType)typeMirror).asElement();
            ElementsUtil.enumerateMethods(scope, elementUtils, typeUtils, interfaceElement, methods);
        }
        for (Element element2 : element.getEnclosedElements()) {
            if (ElementKind.METHOD != element2.getKind()) continue;
            ExecutableElement method = (ExecutableElement)element2;
            ElementsUtil.processMethod(elementUtils, typeUtils, scope, methods, method);
        }
    }

    private static void processMethod(@Nonnull Elements elementUtils, @Nonnull Types typeUtils, @Nonnull TypeElement typeElement, @Nonnull Map<String, ArrayList<ExecutableElement>> methods, @Nonnull ExecutableElement method) {
        ExecutableType methodType = (ExecutableType)typeUtils.asMemberOf((DeclaredType)typeElement.asType(), method);
        String key = method.getSimpleName().toString();
        ArrayList elements = methods.computeIfAbsent(key, k -> new ArrayList());
        boolean found = false;
        int size = elements.size();
        for (int i = 0; i < size; ++i) {
            ExecutableElement executableElement = (ExecutableElement)elements.get(i);
            if (method.equals(executableElement)) {
                found = true;
                break;
            }
            if (ElementsUtil.isSubsignature(typeUtils, typeElement, methodType, executableElement)) {
                if (!ElementsUtil.isAbstractInterfaceMethod(method)) {
                    elements.set(i, method);
                }
                found = true;
                break;
            }
            if (!elementUtils.overrides(method, executableElement, typeElement)) continue;
            elements.set(i, method);
            found = true;
            break;
        }
        if (!found) {
            elements.add(method);
        }
    }

    private static boolean isAbstractInterfaceMethod(@Nonnull ExecutableElement method) {
        return method.getModifiers().contains((Object)Modifier.ABSTRACT) && ElementKind.INTERFACE == method.getEnclosingElement().getKind();
    }

    private static boolean isSubsignature(@Nonnull Types typeUtils, @Nonnull TypeElement typeElement, @Nonnull ExecutableType methodType, @Nonnull ExecutableElement candidate) {
        ExecutableType candidateType = (ExecutableType)typeUtils.asMemberOf((DeclaredType)typeElement.asType(), candidate);
        boolean isEqual = methodType.equals(candidateType);
        boolean isSubsignature = typeUtils.isSubsignature(methodType, candidateType);
        return isSubsignature || isEqual;
    }

    @Nonnull
    public static List<ExecutableElement> getConstructors(@Nonnull TypeElement element) {
        return element.getEnclosedElements().stream().filter(m -> ElementKind.CONSTRUCTOR == m.getKind()).map(m -> (ExecutableElement)m).collect(Collectors.toList());
    }

    public static boolean doesMethodOverrideInterfaceMethod(@Nonnull Types typeUtils, @Nonnull TypeElement typeElement, @Nonnull ExecutableElement method) {
        return ElementsUtil.getInterfaces(typeElement).stream().flatMap(i -> i.getEnclosedElements().stream()).filter(e -> ElementKind.METHOD == e.getKind()).map(e -> (ExecutableElement)e).anyMatch(e -> ElementsUtil.isSubsignature(typeUtils, typeElement, (ExecutableType)typeUtils.asMemberOf((DeclaredType)typeElement.asType(), (Element)e), method));
    }

    @Nonnull
    public static TypeName toRawType(@Nonnull TypeMirror type) {
        TypeName typeName = TypeName.get(type);
        if (typeName instanceof ParameterizedTypeName) {
            return ((ParameterizedTypeName)typeName).rawType;
        }
        return typeName;
    }

    @Nonnull
    public static Element getTopLevelElement(@Nonnull Element element) {
        Element result = element;
        while (ElementKind.PACKAGE != result.getEnclosingElement().getKind()) {
            result = result.getEnclosingElement();
        }
        return result;
    }

    public static boolean isNonStaticNestedClass(@Nonnull TypeElement element) {
        return NestingKind.TOP_LEVEL != element.getNestingKind() && !element.getModifiers().contains((Object)Modifier.STATIC);
    }

    @Deprecated
    public static boolean isElementDeprecated(@Nonnull Element element) {
        return ElementsUtil.hasDeprecatedAnnotation(element);
    }

    public static boolean hasDeprecatedAnnotation(@Nonnull Element element) {
        return element.getAnnotationMirrors().stream().anyMatch(a -> a.getAnnotationType().toString().equals(Deprecated.class.getName()));
    }

    public static boolean isDeprecated(@Nonnull Element element) {
        if (ElementsUtil.isElementDeprecated(element)) {
            return true;
        }
        if ((element.getKind().isClass() || element.getKind().isInterface()) && ElementKind.PACKAGE != element.getEnclosingElement().getKind()) {
            return ElementsUtil.isDeprecated(element.getEnclosingElement());
        }
        return false;
    }

    public static boolean isEffectivelyPublic(@Nonnull TypeElement element) {
        if (!element.getModifiers().contains((Object)Modifier.PUBLIC)) {
            return false;
        }
        Element enclosing = element.getEnclosingElement();
        return ElementKind.PACKAGE == enclosing.getKind() || ElementsUtil.isEffectivelyPublic((TypeElement)enclosing);
    }

    public static boolean isSynthetic(@Nonnull Element element) {
        return !ElementsUtil.isNotSynthetic(element);
    }

    public static boolean isNotSynthetic(@Nonnull Element element) {
        long flags = ((Symbol)element).flags();
        return 0L == (flags & 0x1000L) && 0L == (flags & 0x1000000000L);
    }

    @Nonnull
    public static PackageElement getPackageElement(@Nonnull Element outerElement) {
        Element element = outerElement;
        while (ElementKind.PACKAGE != element.getKind()) {
            element = element.getEnclosingElement();
        }
        return (PackageElement)element;
    }

    public static boolean areTypesInDifferentPackage(@Nonnull TypeElement typeElement1, @Nonnull TypeElement typeElement2) {
        return !ElementsUtil.areTypesInSamePackage(typeElement1, typeElement2);
    }

    public static boolean areTypesInSamePackage(@Nonnull TypeElement typeElement1, @Nonnull TypeElement typeElement2) {
        PackageElement packageElement1 = ElementsUtil.getPackageElement(typeElement1);
        PackageElement packageElement2 = ElementsUtil.getPackageElement(typeElement2);
        return Objects.equals(packageElement1.getQualifiedName(), packageElement2.getQualifiedName());
    }

    @Nullable
    public static ExecutableElement getOverriddenMethod(@Nonnull ProcessingEnvironment processingEnv, @Nonnull TypeElement typeElement, @Nonnull ExecutableElement method) {
        TypeMirror superclass = typeElement.getSuperclass();
        if (TypeKind.NONE == superclass.getKind()) {
            return null;
        }
        TypeElement parent = (TypeElement)processingEnv.getTypeUtils().asElement(superclass);
        List<? extends Element> enclosedElements = parent.getEnclosedElements();
        for (Element element : enclosedElements) {
            if (ElementKind.METHOD != element.getKind() || !processingEnv.getElementUtils().overrides(method, (ExecutableElement)element, typeElement)) continue;
            return (ExecutableElement)element;
        }
        return ElementsUtil.getOverriddenMethod(processingEnv, parent, method);
    }
}

