/*
 * Decompiled with CFR 0.152.
 */
package galdr.processor.vendor.proton;

import galdr.processor.vendor.proton.ElementsUtil;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;

public final class TypesUtil {
    private TypesUtil() {
    }

    public static boolean containsArrayType(@Nonnull TypeMirror type) {
        if (TypeKind.DECLARED == type.getKind()) {
            DeclaredType declaredType = (DeclaredType)type;
            for (TypeMirror typeMirror : declaredType.getTypeArguments()) {
                if (!TypesUtil.containsArrayType(typeMirror)) continue;
                return true;
            }
            return false;
        }
        return TypeKind.ARRAY == type.getKind();
    }

    public static boolean containsRawType(@Nonnull TypeMirror type) {
        if (TypeKind.DECLARED == type.getKind()) {
            DeclaredType declaredType = (DeclaredType)type;
            List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
            if (typeArguments.isEmpty() && !((TypeElement)declaredType.asElement()).getTypeParameters().isEmpty()) {
                return true;
            }
            for (TypeMirror typeMirror : typeArguments) {
                if (!TypesUtil.containsRawType(typeMirror)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean containsWildcard(@Nonnull TypeMirror type) {
        if (TypeKind.WILDCARD == type.getKind()) {
            return true;
        }
        if (TypeKind.DECLARED == type.getKind()) {
            DeclaredType declaredType = (DeclaredType)type;
            for (TypeMirror typeMirror : declaredType.getTypeArguments()) {
                if (!TypesUtil.containsWildcard(typeMirror)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean hasRawTypes(@Nonnull ProcessingEnvironment processingEnv, @Nonnull TypeMirror type) {
        TypeKind kind = type.getKind();
        if (TypeKind.TYPEVAR == kind) {
            TypeVariable typeVariable = (TypeVariable)type;
            return TypesUtil.hasRawTypes(processingEnv, typeVariable.getLowerBound()) || TypesUtil.hasRawTypes(processingEnv, typeVariable.getUpperBound());
        }
        if (TypeKind.ARRAY == kind) {
            return TypesUtil.hasRawTypes(processingEnv, ((ArrayType)type).getComponentType());
        }
        if (TypeKind.DECLARED == kind) {
            TypeElement typeElement;
            DeclaredType declaredType = (DeclaredType)type;
            int typeArgumentCount = declaredType.getTypeArguments().size();
            if (typeArgumentCount != (typeElement = (TypeElement)processingEnv.getTypeUtils().asElement(type)).getTypeParameters().size()) {
                return true;
            }
            return declaredType.getTypeArguments().stream().anyMatch(t -> TypesUtil.hasRawTypes(processingEnv, t));
        }
        if (TypeKind.EXECUTABLE == kind) {
            ExecutableType executableType = (ExecutableType)type;
            return TypesUtil.hasRawTypes(processingEnv, executableType.getReturnType()) || executableType.getTypeVariables().stream().anyMatch(t -> TypesUtil.hasRawTypes(processingEnv, t)) || executableType.getThrownTypes().stream().anyMatch(t -> TypesUtil.hasRawTypes(processingEnv, t)) || executableType.getParameterTypes().stream().anyMatch(t -> TypesUtil.hasRawTypes(processingEnv, t));
        }
        return false;
    }

    public static boolean isDeprecated(@Nonnull ProcessingEnvironment processingEnv, @Nonnull TypeMirror type) {
        TypeKind kind = type.getKind();
        if (TypeKind.TYPEVAR == kind) {
            TypeVariable typeVariable = (TypeVariable)type;
            return TypesUtil.isDeprecated(processingEnv, typeVariable.getLowerBound()) || TypesUtil.isDeprecated(processingEnv, typeVariable.getUpperBound());
        }
        if (TypeKind.ARRAY == kind) {
            return TypesUtil.isDeprecated(processingEnv, ((ArrayType)type).getComponentType());
        }
        if (TypeKind.DECLARED == kind) {
            if (TypesUtil.isTypeElementDeprecated(processingEnv, type)) {
                return true;
            }
            DeclaredType declaredType = (DeclaredType)type;
            return declaredType.getTypeArguments().stream().anyMatch(t -> TypesUtil.isDeprecated(processingEnv, t));
        }
        if (TypeKind.EXECUTABLE == kind) {
            ExecutableType executableType = (ExecutableType)type;
            return TypesUtil.isTypeElementDeprecated(processingEnv, executableType) || TypesUtil.isDeprecated(processingEnv, executableType.getReturnType()) || executableType.getTypeVariables().stream().anyMatch(t -> TypesUtil.isDeprecated(processingEnv, t)) || executableType.getThrownTypes().stream().anyMatch(t -> TypesUtil.isDeprecated(processingEnv, t)) || executableType.getParameterTypes().stream().anyMatch(t -> TypesUtil.isDeprecated(processingEnv, t));
        }
        return false;
    }

    private static boolean isTypeElementDeprecated(@Nonnull ProcessingEnvironment processingEnv, @Nonnull TypeMirror type) {
        Element element = processingEnv.getTypeUtils().asElement(type);
        return null != element && ElementsUtil.isDeprecated(element);
    }
}

