/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.giggle;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class Environment {
    @Nonnull
    private final Path _currentDirectory;
    @Nonnull
    private final Logger _logger;
    @Nonnull
    private final List<Path> _schemaFiles = new ArrayList<Path>();
    @Nonnull
    private final List<Path> _documentFiles = new ArrayList<Path>();
    @Nonnull
    private final List<Path> _typeMappingFiles = new ArrayList<Path>();
    @Nonnull
    private final List<Path> _fragmentMappingFiles = new ArrayList<Path>();
    @Nullable
    private Path _outputDirectory;
    @Nullable
    private String _packageName;
    @Nonnull
    private final List<String> _generators = new ArrayList<String>();

    Environment(@Nonnull Path currentDirectory, @Nonnull Logger logger) {
        this._currentDirectory = Objects.requireNonNull(currentDirectory);
        this._logger = Objects.requireNonNull(logger);
    }

    @Nonnull
    Path currentDirectory() {
        return this._currentDirectory;
    }

    @Nonnull
    Logger logger() {
        return this._logger;
    }

    void addSchemaFile(@Nonnull Path file) {
        this._schemaFiles.add(Objects.requireNonNull(file));
    }

    @Nonnull
    List<Path> getSchemaFiles() {
        return Collections.unmodifiableList(this._schemaFiles);
    }

    void addDocumentFile(@Nonnull Path file) {
        this._documentFiles.add(Objects.requireNonNull(file));
    }

    @Nonnull
    List<Path> getDocumentFiles() {
        return Collections.unmodifiableList(this._documentFiles);
    }

    void addTypeMappingFile(@Nonnull Path file) {
        this._typeMappingFiles.add(Objects.requireNonNull(file));
    }

    @Nonnull
    List<Path> getTypeMappingFiles() {
        return Collections.unmodifiableList(this._typeMappingFiles);
    }

    void addFragmentMappingFile(@Nonnull Path file) {
        this._fragmentMappingFiles.add(Objects.requireNonNull(file));
    }

    @Nonnull
    List<Path> getFragmentMappingFiles() {
        return Collections.unmodifiableList(this._fragmentMappingFiles);
    }

    boolean hasOutputDirectory() {
        return null != this._outputDirectory;
    }

    @Nonnull
    Path getOutputDirectory() {
        return Objects.requireNonNull(this._outputDirectory);
    }

    void setOutputDirectory(@Nonnull Path outputDirectory) {
        this._outputDirectory = Objects.requireNonNull(outputDirectory);
    }

    boolean hasPackageName() {
        return null != this._packageName;
    }

    @Nonnull
    String getPackageName() {
        return Objects.requireNonNull(this._packageName);
    }

    void setPackageName(@Nonnull String packageName) {
        this._packageName = Objects.requireNonNull(packageName);
    }

    void addGenerator(@Nonnull String generator) {
        this._generators.add(Objects.requireNonNull(generator));
    }

    @Nonnull
    List<String> getGenerators() {
        return Collections.unmodifiableList(this._generators);
    }
}

