/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.giggle.generator.java;

import graphql.schema.GraphQLType;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.realityforge.giggle.generator.Generator;
import org.realityforge.giggle.generator.GeneratorContext;

public abstract class AbstractJavaGenerator
implements Generator {
    protected static final String VAR_PREFIX = "$giggle$_";

    @Nonnull
    protected final String asJavadoc(@Nonnull String text) {
        return text.trim() + "\n";
    }

    protected final boolean isNotIntrospectionType(@Nonnull GraphQLType type) {
        return !type.getName().startsWith("__");
    }

    protected final void writeTypeMappingFile(@Nonnull GeneratorContext context, @Nonnull Map<GraphQLType, String> typeMap) throws IOException {
        Path typeMappingFile = context.getOutputDirectory().resolve(context.getPackageName().replaceAll("\\.", File.separator)).resolve("types.mapping");
        String typeMappingContent = typeMap.keySet().stream().map(type -> type.getName() + "=" + (String)typeMap.get(type)).sorted().collect(Collectors.joining("\n")) + "\n";
        Path dir = typeMappingFile.getParent();
        if (!Files.exists(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        Files.write(typeMappingFile, typeMappingContent.getBytes(StandardCharsets.US_ASCII), new OpenOption[0]);
    }

    @Nonnull
    protected final Map<GraphQLType, String> buildTypeMapping(@Nonnull GeneratorContext context) {
        HashMap<GraphQLType, String> typeMap = new HashMap<GraphQLType, String>();
        context.getTypeMapping().forEach((key, value) -> typeMap.put(context.getSchema().getType(key), (String)value));
        return typeMap;
    }
}

