/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.giggle.generator.java;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import graphql.Scalars;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLUnmodifiedType;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nonnull;
import org.realityforge.giggle.generator.GeneratorContext;

public final class JavaGenUtil {
    public static final ClassName NONNULL_CLASSNAME = ClassName.get((String)"javax.annotation", (String)"Nonnull", (String[])new String[0]);
    public static final ClassName NULLABLE_CLASSNAME = ClassName.get((String)"javax.annotation", (String)"Nullable", (String[])new String[0]);
    private static final ClassName LIST_CLASSNAME = ClassName.get((String)"java.util", (String)"List", (String[])new String[0]);

    private JavaGenUtil() {
    }

    public static void writeTopLevelType(@Nonnull GeneratorContext context, @Nonnull TypeSpec.Builder builder) throws IOException {
        JavaGenUtil.writeGeneratedAnnotation(builder);
        JavaFile.builder((String)context.getPackageName(), (TypeSpec)builder.build()).skipJavaLangImports(true).build().writeTo(context.getOutputDirectory());
    }

    private static void writeGeneratedAnnotation(@Nonnull TypeSpec.Builder builder) {
        Class<?> generated;
        try {
            generated = Class.forName("javax.annotation.processing.Generated");
        }
        catch (ClassNotFoundException ignored) {
            try {
                generated = Class.forName("javax.annotation.Generated");
            }
            catch (ClassNotFoundException ignored2) {
                return;
            }
        }
        builder.addAnnotation(AnnotationSpec.builder((ClassName)ClassName.get(generated)).addMember("value", "$S", new Object[]{"org.realityforge.giggle.Main"}).build());
    }

    @Nonnull
    public static TypeName getJavaType(@Nonnull Map<GraphQLType, String> typeMap, @Nonnull GraphQLDirectiveContainer container) {
        GraphQLInputType valueType = container instanceof GraphQLInputObjectField ? ((GraphQLInputObjectField)container).getType() : (container instanceof GraphQLArgument ? ((GraphQLArgument)container).getType() : container);
        boolean isList = JavaGenUtil.isList((GraphQLType)valueType);
        boolean isNonnull = GraphQLTypeUtil.isNonNull((GraphQLType)valueType);
        GraphQLUnmodifiedType type = GraphQLTypeUtil.unwrapAll((GraphQLType)valueType);
        String typeName = typeMap.get(type);
        if (null != typeName) {
            return JavaGenUtil.wrap(isList, (TypeName)ClassName.bestGuess((String)typeName));
        }
        if (Scalars.GraphQLInt.equals(type)) {
            return JavaGenUtil.wrapPrimitive(isList, isNonnull, TypeName.INT);
        }
        if (Scalars.GraphQLBoolean.equals(type)) {
            return JavaGenUtil.wrapPrimitive(isList, isNonnull, TypeName.BOOLEAN);
        }
        if (Scalars.GraphQLByte.equals(type)) {
            return JavaGenUtil.wrapPrimitive(isList, isNonnull, TypeName.BYTE);
        }
        if (Scalars.GraphQLShort.equals(type)) {
            return JavaGenUtil.wrapPrimitive(isList, isNonnull, TypeName.SHORT);
        }
        if (Scalars.GraphQLLong.equals(type)) {
            return JavaGenUtil.wrapPrimitive(isList, isNonnull, TypeName.LONG);
        }
        if (Scalars.GraphQLChar.equals(type)) {
            return JavaGenUtil.wrapPrimitive(isList, isNonnull, TypeName.CHAR);
        }
        if (Scalars.GraphQLFloat.equals(type)) {
            return JavaGenUtil.wrapPrimitive(isList, isNonnull, TypeName.FLOAT);
        }
        if (Scalars.GraphQLID.equals(type)) {
            if (JavaGenUtil.hasNumericDirective(container)) {
                return JavaGenUtil.wrapPrimitive(isList, isNonnull, TypeName.INT);
            }
            return JavaGenUtil.wrap(isList, (TypeName)ClassName.get(String.class));
        }
        if (Scalars.GraphQLString.equals(type)) {
            return JavaGenUtil.wrap(isList, (TypeName)ClassName.get(String.class));
        }
        if (Scalars.GraphQLBigDecimal.equals(type)) {
            return JavaGenUtil.wrap(isList, (TypeName)ClassName.get(BigDecimal.class));
        }
        if (Scalars.GraphQLBigInteger.equals(type)) {
            return JavaGenUtil.wrap(isList, (TypeName)ClassName.get(BigInteger.class));
        }
        if (type.getName().equals("Date") || type.getName().equals("DateTime")) {
            return JavaGenUtil.wrap(isList, (TypeName)ClassName.get(Date.class));
        }
        throw new IllegalStateException("Unknown type " + type.getName());
    }

    @Nonnull
    private static TypeName wrap(boolean isList, @Nonnull TypeName type) {
        return isList ? JavaGenUtil.listOf(type) : type;
    }

    @Nonnull
    private static TypeName wrapPrimitive(boolean isList, boolean isNonnull, @Nonnull TypeName type) {
        return isList ? JavaGenUtil.listOf(type.box()) : (isNonnull ? type : type.box());
    }

    @Nonnull
    public static TypeName listOf(@Nonnull TypeName typeName) {
        return ParameterizedTypeName.get((ClassName)LIST_CLASSNAME, (TypeName[])new TypeName[]{typeName});
    }

    public static boolean isList(@Nonnull GraphQLType type) {
        return GraphQLTypeUtil.isList((GraphQLType)type) || GraphQLTypeUtil.isWrapped((GraphQLType)type) && JavaGenUtil.isList(GraphQLTypeUtil.unwrapOne((GraphQLType)type));
    }

    public static boolean hasNumericDirective(@Nonnull GraphQLDirectiveContainer type) {
        return null != type.getDirective("numeric");
    }
}

