/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.giggle.schema;

import graphql.language.ScalarTypeDefinition;
import graphql.parser.MultiSourceReader;
import graphql.schema.Coercing;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.ScalarInfo;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.errors.SchemaProblem;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.realityforge.giggle.schema.NoopCoercing;
import org.realityforge.giggle.schema.SchemaReadException;
import org.realityforge.giggle.util.HashUtil;

public final class SchemaRepository {
    @Nonnull
    private final SchemaParser _schemaParser = new SchemaParser();
    @Nonnull
    private final SchemaGenerator _schemaGenerator = new SchemaGenerator();
    @Nonnull
    private final Map<String, WeakReference<GraphQLSchema>> _schemas = new HashMap<String, WeakReference<GraphQLSchema>>();

    @Nonnull
    public GraphQLSchema getSchema(@Nonnull List<Path> components) throws SchemaProblem, SchemaReadException {
        GraphQLSchema schema;
        List<byte[]> schemaBytes = this.loadFiles(components);
        String id = this.deriveId(schemaBytes);
        WeakReference<GraphQLSchema> reference = this._schemas.get(id);
        if (null != reference && null != (schema = (GraphQLSchema)reference.get())) {
            return schema;
        }
        TypeDefinitionRegistry typeRegistry = this.buildTypeDefinitionRegistry(components, schemaBytes);
        RuntimeWiring runtimeWiring = this.buildRuntimeWiring(typeRegistry);
        GraphQLSchema schema2 = this._schemaGenerator.makeExecutableSchema(typeRegistry, runtimeWiring);
        this._schemas.put(id, new WeakReference<GraphQLSchema>(schema2));
        return schema2;
    }

    @Nonnull
    private RuntimeWiring buildRuntimeWiring(@Nonnull TypeDefinitionRegistry typeRegistry) {
        RuntimeWiring.Builder builder = RuntimeWiring.newRuntimeWiring();
        for (ScalarTypeDefinition scalar : typeRegistry.scalars().values()) {
            if (ScalarInfo.isStandardScalar((String)scalar.getName())) continue;
            builder.scalar(GraphQLScalarType.newScalar().name(scalar.getName()).description(scalar.getName()).coercing((Coercing)new NoopCoercing()).build());
        }
        return builder.build();
    }

    @Nonnull
    private TypeDefinitionRegistry buildTypeDefinitionRegistry(@Nonnull List<Path> components, @Nonnull List<byte[]> schemaBytes) {
        TypeDefinitionRegistry typeRegistry = new TypeDefinitionRegistry();
        int index = 0;
        for (byte[] data : schemaBytes) {
            Path path = components.get(index++);
            ByteArrayInputStream input = new ByteArrayInputStream(data);
            InputStreamReader reader = new InputStreamReader((InputStream)input, StandardCharsets.UTF_8);
            MultiSourceReader msReader = MultiSourceReader.newMultiSourceReader().reader((Reader)reader, path.toString()).build();
            typeRegistry.merge(this._schemaParser.parse((Reader)msReader));
        }
        return typeRegistry;
    }

    @Nonnull
    private String deriveId(@Nonnull List<byte[]> schemaBytes) {
        return HashUtil.sha256(schemaBytes.stream().map(HashUtil::sha256).collect(Collectors.joining()).getBytes(StandardCharsets.US_ASCII));
    }

    @Nonnull
    private List<byte[]> loadFiles(@Nonnull List<Path> components) {
        ArrayList<byte[]> schemaBytes = new ArrayList<byte[]>();
        for (Path component : components) {
            try {
                schemaBytes.add(Files.readAllBytes(component));
            }
            catch (IOException ioe) {
                throw new SchemaReadException("Error reading schema file " + component, ioe);
            }
        }
        return schemaBytes;
    }
}

