/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.giggle;

import graphql.GraphQLError;
import graphql.language.Document;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.errors.SchemaProblem;
import graphql.validation.ValidationError;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.realityforge.getopt4j.CLArgsParser;
import org.realityforge.getopt4j.CLOption;
import org.realityforge.getopt4j.CLOptionDescriptor;
import org.realityforge.getopt4j.CLUtil;
import org.realityforge.giggle.Environment;
import org.realityforge.giggle.RawFormatter;
import org.realityforge.giggle.TerminalStateException;
import org.realityforge.giggle.document.DocumentReadException;
import org.realityforge.giggle.document.DocumentRepository;
import org.realityforge.giggle.document.DocumentValidateException;
import org.realityforge.giggle.generator.GenerateException;
import org.realityforge.giggle.generator.GeneratorContext;
import org.realityforge.giggle.generator.GeneratorRepository;
import org.realityforge.giggle.generator.NoSuchGeneratorException;
import org.realityforge.giggle.schema.SchemaReadException;
import org.realityforge.giggle.schema.SchemaRepository;
import org.realityforge.giggle.util.IoUtil;
import org.realityforge.giggle.util.MappingUtil;

public class Main {
    private static final int HELP_OPT = 104;
    private static final int QUIET_OPT = 113;
    private static final int VERBOSE_OPT = 118;
    private static final int SCHEMA_FILE_OPT = 1;
    private static final int DOCUMENT_FILE_OPT = 2;
    private static final int TYPE_MAPPING_FILE_OPT = 3;
    private static final int FRAGMENT_MAPPING_FILE_OPT = 4;
    private static final int OUTPUT_DIRECTORY_OPT = 6;
    private static final int PACKAGE_NAME_OPT = 7;
    private static final int GENERATOR_OPT = 8;
    private static final CLOptionDescriptor[] OPTIONS = new CLOptionDescriptor[]{new CLOptionDescriptor("help", 8, 104, "print this message and exit"), new CLOptionDescriptor("quiet", 8, 113, "Do not output unless an error occurs.", new int[]{118}), new CLOptionDescriptor("verbose", 8, 118, "Verbose output of differences.", new int[]{113}), new CLOptionDescriptor("schema", 34, 1, "The path to a graphql schema file."), new CLOptionDescriptor("document", 34, 2, "The path to a graphql document file."), new CLOptionDescriptor("type-mapping", 34, 3, "The path to a mapping file for types."), new CLOptionDescriptor("fragment-mapping", 34, 4, "The path to a mapping file for fragments."), new CLOptionDescriptor("package", 2, 7, "The java package name used to generate artifacts."), new CLOptionDescriptor("output-directory", 2, 6, "The directory where generated files are output."), new CLOptionDescriptor("generator", 34, 8, "The name of a generator to run on the model.")};
    private static final Environment c_environment = new Environment(Paths.get("", new String[0]).toAbsolutePath(), Logger.getGlobal());

    public static void main(String[] args) {
        Main.setupLogger();
        if (!Main.processOptions(c_environment, args)) {
            System.exit(2);
            return;
        }
        Logger logger = c_environment.logger();
        try {
            SchemaRepository schemaRepository = new SchemaRepository();
            GraphQLSchema schema = schemaRepository.getSchema(c_environment.getSchemaFiles());
            DocumentRepository documentRepository = new DocumentRepository();
            Document document = documentRepository.getDocument(schema, c_environment.getDocumentFiles());
            Map<String, String> typeMapping = MappingUtil.getMapping(c_environment.getTypeMappingFiles());
            Map<String, String> fragmentMapping = MappingUtil.getMapping(c_environment.getFragmentMappingFiles());
            List<String> generators = c_environment.getGenerators();
            if (!generators.isEmpty()) {
                IoUtil.deleteDirIfExists(c_environment.getOutputDirectory());
                GeneratorContext context = new GeneratorContext(schema, document, typeMapping, fragmentMapping, c_environment.getOutputDirectory(), c_environment.getPackageName());
                Main.verifyTypeMapping(context);
                GeneratorRepository generatorRepository = new GeneratorRepository();
                for (String generator : generators) {
                    generatorRepository.generate(generator, context);
                }
            }
        }
        catch (GenerateException ge) {
            logger.log(Level.WARNING, "Error: Failed generating artifacts using generator named " + ge.getName(), ge.getCause());
            System.exit(7);
        }
        catch (NoSuchGeneratorException nsge) {
            logger.log(Level.WARNING, "Error: Unable to locate generator named " + nsge.getName());
            System.exit(7);
        }
        catch (DocumentReadException dre) {
            logger.log(Level.WARNING, dre.getMessage());
            System.exit(5);
        }
        catch (DocumentValidateException dve) {
            logger.log(Level.WARNING, "Error: Failed to validate document");
            List<ValidationError> errors = dve.getErrors();
            for (ValidationError error : errors) {
                String locations = error.getLocations().stream().map(e -> e.getSourceName() + ":" + e.getLine()).collect(Collectors.joining(" "));
                logger.log(Level.WARNING, error.getErrorType() + ":" + error.getMessage() + (locations.isEmpty() ? "" : " @ " + locations));
            }
            System.exit(6);
        }
        catch (SchemaReadException sre) {
            logger.log(Level.WARNING, sre.getMessage());
            System.exit(3);
        }
        catch (SchemaProblem sp) {
            logger.log(Level.WARNING, "Error: Failed to parse schema");
            List errors = sp.getErrors();
            for (GraphQLError error : errors) {
                String locations = error.getLocations().stream().map(e -> e.getSourceName() + ":" + e.getLine()).collect(Collectors.joining(" "));
                logger.log(Level.WARNING, error.getErrorType() + ":" + error.getMessage() + (locations.isEmpty() ? "" : " @ " + locations));
            }
            System.exit(4);
        }
        catch (TerminalStateException tse) {
            String message = tse.getMessage();
            if (null != message) {
                logger.log(Level.WARNING, message);
                Throwable cause = tse.getCause();
                if (null != cause && logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, "Cause: " + cause.toString());
                    if (logger.isLoggable(Level.FINE)) {
                        cause.printStackTrace();
                    }
                }
            }
            System.exit(tse.getExitCode());
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, t.toString(), t);
            System.exit(1);
        }
        System.exit(0);
    }

    static void verifyTypeMapping(@Nonnull GeneratorContext context) {
        GraphQLSchema schema = context.getSchema();
        for (Map.Entry<String, String> entry : context.getTypeMapping().entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (null != schema.getType(key)) continue;
            throw new TerminalStateException("Type mapping attempted to map the type named '" + key + "' to " + value + " but there is no type named '" + key + "'", 8);
        }
    }

    private static void setupLogger() {
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(new RawFormatter());
        handler.setLevel(Level.ALL);
        Logger logger = c_environment.logger();
        logger.setUseParentHandlers(false);
        logger.addHandler(handler);
        logger.setLevel(Level.INFO);
    }

    static boolean processOptions(@Nonnull Environment environment, String ... args) {
        CLArgsParser parser = new CLArgsParser(args, OPTIONS);
        Logger logger = environment.logger();
        if (null != parser.getErrorString()) {
            logger.log(Level.SEVERE, "Error: " + parser.getErrorString());
            return false;
        }
        List options = parser.getArguments();
        for (CLOption option : options) {
            switch (option.getId()) {
                case 0: {
                    logger.log(Level.SEVERE, "Error: Unknown argument: " + option.getArgument());
                    return false;
                }
                case 1: {
                    if (!Main.fileArgument(environment, option, "schema", environment::addSchemaFile)) break;
                    return false;
                }
                case 2: {
                    if (!Main.fileArgument(environment, option, "document", environment::addDocumentFile)) break;
                    return false;
                }
                case 3: {
                    if (!Main.fileArgument(environment, option, "type mapping", environment::addTypeMappingFile)) break;
                    return false;
                }
                case 4: {
                    if (!Main.fileArgument(environment, option, "fragment mapping", environment::addFragmentMappingFile)) break;
                    return false;
                }
                case 6: {
                    String argument = option.getArgument();
                    Path dir = environment.currentDirectory().resolve(argument).toAbsolutePath().normalize();
                    if (dir.toFile().exists() && !dir.toFile().isDirectory()) {
                        String message = "Error: Specified output directory exists and is not a directory. Specified value: " + argument;
                        logger.log(Level.SEVERE, message);
                        return false;
                    }
                    environment.setOutputDirectory(dir);
                    break;
                }
                case 8: {
                    String argument = option.getArgument();
                    if (environment.getGenerators().contains(argument)) {
                        logger.log(Level.SEVERE, "Error: Duplicate generators specified: " + argument);
                        return false;
                    }
                    environment.addGenerator(argument);
                    break;
                }
                case 7: {
                    environment.setPackageName(option.getArgument());
                    break;
                }
                case 118: {
                    logger.setLevel(Level.ALL);
                    break;
                }
                case 113: {
                    logger.setLevel(Level.WARNING);
                    break;
                }
                case 104: {
                    Main.printUsage(environment);
                    return false;
                }
            }
        }
        if (environment.getSchemaFiles().isEmpty()) {
            logger.log(Level.SEVERE, "Error: No schema files specified.");
            return false;
        }
        if (!environment.hasOutputDirectory() && !environment.getGenerators().isEmpty()) {
            logger.log(Level.SEVERE, "Error: Must specify output directory if a generator is specified.");
            return false;
        }
        if (!environment.hasPackageName()) {
            logger.log(Level.SEVERE, "Error: Must specify output package name.");
            return false;
        }
        Main.printBanner(environment);
        return true;
    }

    static void printBanner(@Nonnull Environment environment) {
        Logger logger = environment.logger();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Giggle Starting...");
            logger.log(Level.FINE, "  Output directory: " + environment.getOutputDirectory());
            logger.log(Level.FINE, "  Output Package: " + environment.getPackageName());
            logger.log(Level.FINE, "  Generators: " + environment.getGenerators());
            logger.log(Level.FINE, "  Schema files: " + environment.getSchemaFiles());
            logger.log(Level.FINE, "  Document files: " + environment.getDocumentFiles());
            logger.log(Level.FINE, "  Type mapping files: " + environment.getTypeMappingFiles());
            logger.log(Level.FINE, "  Fragment mapping files: " + environment.getTypeMappingFiles());
        }
    }

    private static boolean fileArgument(@Nonnull Environment environment, @Nonnull CLOption option, @Nonnull String label, @Nonnull Consumer<Path> action) {
        String argument = option.getArgument();
        Path file = environment.currentDirectory().resolve(argument).toAbsolutePath().normalize();
        if (!file.toFile().exists()) {
            String message = "Error: Specified graphql " + label + " file does not exist. Specified value: " + argument;
            environment.logger().log(Level.SEVERE, message);
            return true;
        }
        action.accept(file);
        return false;
    }

    static void printUsage(@Nonnull Environment environment) {
        String[] options;
        Logger logger = environment.logger();
        logger.info("java " + Main.class.getName() + " [options]");
        logger.info("\tOptions:");
        for (String line : options = CLUtil.describeOptions((CLOptionDescriptor[])OPTIONS).toString().split(System.getProperty("line.separator"))) {
            logger.info(line);
        }
    }
}

