/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.giggle.generator;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.realityforge.giggle.generator.GenerateException;
import org.realityforge.giggle.generator.Generator;
import org.realityforge.giggle.generator.GeneratorContext;
import org.realityforge.giggle.generator.NoSuchGeneratorException;

public abstract class AbstractGeneratorRepository {
    private final Map<String, Generator> _generators = new HashMap<String, Generator>();

    public final void generate(@Nonnull String name, @Nonnull GeneratorContext context) throws NoSuchGeneratorException, GenerateException {
        Generator generator = this.getGenerator(name);
        try {
            generator.generate(context);
        }
        catch (Throwable t) {
            throw new GenerateException(name, t);
        }
    }

    @Nonnull
    final Generator getGenerator(@Nonnull String name) throws NoSuchGeneratorException {
        Generator generator = this._generators.get(name);
        if (null == generator) {
            throw new NoSuchGeneratorException(name);
        }
        return generator;
    }

    final void registerGenerator(@Nonnull Generator generator) {
        Class<?> type = generator.getClass();
        Generator.MetaData metaData = type.getAnnotation(Generator.MetaData.class);
        String name = null == metaData ? "<default>" : metaData.name();
        String actualName = "<default>".equals(name) ? type.getSimpleName().replaceAll("Generator$", "") : name;
        this._generators.put(actualName, generator);
    }
}

