/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.giggle.generator.java.client;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import graphql.execution.MergedField;
import graphql.execution.MergedSelectionSet;
import graphql.language.AstPrinter;
import graphql.language.Comment;
import graphql.language.Definition;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.Node;
import graphql.language.OperationDefinition;
import graphql.language.SelectionSetContainer;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.lang.model.element.Modifier;
import org.realityforge.giggle.generator.Generator;
import org.realityforge.giggle.generator.GeneratorContext;
import org.realityforge.giggle.generator.java.AbstractJavaGenerator;
import org.realityforge.giggle.generator.java.JavaGenUtil;
import org.realityforge.giggle.generator.java.NamingUtil;
import org.realityforge.giggle.generator.java.client.FieldCollector;
import org.realityforge.giggle.generator.java.client.FragmentCollector;

@Generator.MetaData(name="java-client")
public class JavaClientGenerator
extends AbstractJavaGenerator {
    @Override
    public void generate(@Nonnull GeneratorContext context) throws Exception {
        Map<GraphQLType, String> inputTypeMap = this.buildTypeMapping(context);
        HashMap<GraphQLType, String> generatedTypeMap = new HashMap<GraphQLType, String>();
        GraphQLSchema schema = context.getSchema();
        List types = schema.getAllTypesAsList().stream().filter(this::isNotIntrospectionType).filter(t -> !inputTypeMap.containsKey(t)).collect(Collectors.toList());
        for (Object type : types) {
            if (!(type instanceof GraphQLEnumType)) continue;
            generatedTypeMap.put((GraphQLType)type, context.getPackageName() + "." + type.getName());
        }
        HashMap<GraphQLType, String> fullTypeMap = new HashMap<GraphQLType, String>();
        fullTypeMap.putAll(inputTypeMap);
        fullTypeMap.putAll(generatedTypeMap);
        for (GraphQLType type : types) {
            if (!(type instanceof GraphQLEnumType)) continue;
            this.emitEnum(context, (GraphQLEnumType)type);
        }
        FieldCollector collector = new FieldCollector(context.getDocument());
        FragmentCollector fragmentCollector = new FragmentCollector(context.getDocument());
        for (Definition definition : context.getDocument().getDefinitions()) {
            if (!(definition instanceof OperationDefinition)) continue;
            OperationDefinition operation = (OperationDefinition)definition;
            this.emitOperation(context, collector, fullTypeMap, operation);
            this.emitOperationDocument(context, fragmentCollector, operation);
        }
        this.writeTypeMappingFile(context, generatedTypeMap);
    }

    private void emitOperationDocument(@Nonnull GeneratorContext context, @Nonnull FragmentCollector collector, @Nonnull OperationDefinition operation) throws IOException {
        ArrayList<Object> definitions = new ArrayList<Object>();
        definitions.add(operation);
        definitions.addAll(collector.collectFragments(operation.getSelectionSet()));
        Document document = context.getDocument().transform(b -> b.definitions((List)definitions));
        this.writeFile(this.getPackageOutputDirectory(context).resolve(operation.getName() + ".graphql"), AstPrinter.printAstCompact((Node)document));
    }

    private void emitOperation(@Nonnull GeneratorContext context, @Nonnull FieldCollector collector, @Nonnull Map<GraphQLType, String> typeMap, @Nonnull OperationDefinition operation) throws IOException {
        String name = operation.getName();
        if (null == name) {
            throw new IllegalStateException("Unable to generate infrastructure for anonymous operation");
        }
        OperationDefinition.Operation operationType = operation.getOperation();
        if (OperationDefinition.Operation.SUBSCRIPTION == operationType) {
            throw new IllegalStateException("Unable to generate infrastructure for SUBSCRIPTION operation");
        }
        String typeName = NamingUtil.uppercaseFirstCharacter(name) + NamingUtil.uppercaseFirstCharacter(operationType.name().toLowerCase()) + "Response";
        GraphQLSchema schema = context.getSchema();
        GraphQLObjectType fieldsContainer = OperationDefinition.Operation.QUERY == operationType ? schema.getQueryType() : (OperationDefinition.Operation.MUTATION == operationType ? schema.getMutationType() : schema.getSubscriptionType());
        JavaGenUtil.writeTopLevelType(context, this.buildType(collector, (SelectionSetContainer)operation, typeMap, typeName, (GraphQLFieldsContainer)fieldsContainer));
    }

    @Nonnull
    private TypeSpec.Builder buildType(@Nonnull FieldCollector collector, @Nonnull SelectionSetContainer container, @Nonnull Map<GraphQLType, String> typeMap, @Nonnull String typeName, @Nonnull GraphQLFieldsContainer fieldsContainer) {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)typeName);
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        this.buildSelectedValues(collector, typeMap, fieldsContainer, container, builder);
        return builder;
    }

    private void buildSelectedValues(@Nonnull FieldCollector collector, @Nonnull Map<GraphQLType, String> typeMap, @Nonnull GraphQLFieldsContainer fieldsContainer, @Nonnull SelectionSetContainer selectionSetContainer, @Nonnull TypeSpec.Builder builder) {
        MergedSelectionSet selectionSet = collector.collectFields(selectionSetContainer.getSelectionSet());
        for (MergedField field : selectionSet.getSubFields().values()) {
            this.buildFieldSelection(collector, typeMap, fieldsContainer, builder, field);
        }
    }

    private void buildFieldSelection(@Nonnull FieldCollector collector, @Nonnull Map<GraphQLType, String> typeMap, @Nonnull GraphQLFieldsContainer fieldsContainer, @Nonnull TypeSpec.Builder builder, @Nonnull MergedField mergedField) {
        List comments;
        TypeName fieldType;
        Field selection = mergedField.getSingleField();
        String alias = selection.getAlias();
        String name = null == alias ? selection.getName() : alias;
        GraphQLFieldDefinition fieldDefinition = fieldsContainer.getFieldDefinition(selection.getName());
        assert (null != fieldDefinition);
        if (selection.getChildren().isEmpty()) {
            fieldType = JavaGenUtil.getJavaType(typeMap, (GraphQLDirectiveContainer)fieldDefinition);
        } else {
            GraphQLObjectType type = (GraphQLObjectType)GraphQLTypeUtil.unwrapAll((GraphQLType)fieldDefinition.getType());
            String typeName = NamingUtil.uppercaseFirstCharacter(name);
            TypeSpec.Builder subType = this.buildType(collector, (SelectionSetContainer)selection, typeMap, typeName, (GraphQLFieldsContainer)type);
            subType.addModifiers(new Modifier[]{Modifier.STATIC});
            builder.addType(subType.build());
            boolean isList = JavaGenUtil.isList((GraphQLType)fieldDefinition.getType());
            fieldType = isList ? JavaGenUtil.listOf((TypeName)ClassName.bestGuess((String)typeName)) : ClassName.bestGuess((String)typeName);
        }
        FieldSpec.Builder field = FieldSpec.builder((TypeName)fieldType, (String)name, (Modifier[])new Modifier[]{Modifier.PRIVATE});
        if (!fieldType.isPrimitive()) {
            field.addAnnotation(GraphQLTypeUtil.isNonNull((GraphQLType)fieldDefinition.getType()) ? JavaGenUtil.NONNULL_CLASSNAME : JavaGenUtil.NULLABLE_CLASSNAME);
        }
        if (!(comments = selection.getComments()).isEmpty()) {
            for (Comment comment : comments) {
                field.addJavadoc(this.asJavadoc(comment.getContent()), new Object[0]);
            }
        }
        builder.addField(field.build());
        MethodSpec.Builder getter = MethodSpec.methodBuilder((String)((fieldType == TypeName.BOOLEAN ? "is" : "get") + NamingUtil.uppercaseFirstCharacter(name))).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(fieldType).addStatement("return $N", new Object[]{name});
        if (!fieldType.isPrimitive()) {
            getter.addAnnotation(GraphQLTypeUtil.isNonNull((GraphQLType)fieldDefinition.getType()) ? JavaGenUtil.NONNULL_CLASSNAME : JavaGenUtil.NULLABLE_CLASSNAME);
        }
        builder.addMethod(getter.build());
        ParameterSpec.Builder parameter = ParameterSpec.builder((TypeName)fieldType, (String)name, (Modifier[])new Modifier[]{Modifier.FINAL});
        if (!fieldType.isPrimitive()) {
            parameter.addAnnotation(GraphQLTypeUtil.isNonNull((GraphQLType)fieldDefinition.getType()) ? JavaGenUtil.NONNULL_CLASSNAME : JavaGenUtil.NULLABLE_CLASSNAME);
        }
        MethodSpec.Builder setter = MethodSpec.methodBuilder((String)("set" + NamingUtil.uppercaseFirstCharacter(name))).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(parameter.build()).addStatement("this.$N = $N", new Object[]{name, name});
        builder.addMethod(setter.build());
    }
}

